package com.liquidnet.service.sweet.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 小程序订阅消息记录表
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-11-22
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class SweetAppletSubMsg implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * msg_id
     */
    private String msgId;

    /**
     * open_id
     */
    private String openId;

    /**
     * template_id
     */
    private String templateId;

    /**
     * 目标id 显示是演出id
     */
    private String targetId;

    /**
     * 1草莓 2五百里 3mdsk 4正在
     */
    private Integer appletType;

    /**
     * 活动类型
     */
    private Integer activityType;

    /**
     * 是否推送 1未推送 2已推送
     */
    private Integer isPush;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 更新时间
     */
    private LocalDateTime updatedAt;


}
