package com.liquidnet.service.kylin.controller;

import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.dto.param.KylinStationCheckOrderParam;
import com.liquidnet.service.kylin.dto.vo.KylinStationCheckOrderVo;
import com.liquidnet.service.kylin.dto.vo.KylinStationPerformanceVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Collections;
import java.util.List;

@Api(tags = "验票")
@Slf4j
@RestController
@RequestMapping("station")
public class KylinStationController {

    @ApiOperation(value = "手机号密码登录")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", dataType = "String", name = "mobile", value = "手机号"),
            @ApiImplicitParam(type = "form", dataType = "String", name = "passwd", value = "密码"),
    })
    @PostMapping("login")
    public ResponseDto<String> login(@RequestParam String mobile, @RequestParam String passwd) {
        log.info("mobile:{},passwd:{}", mobile, passwd);



        return ResponseDto.success("token........");
    }

    @ApiOperation(value = "手机号验证码登录")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "body", required = true, dataType = "String", name = "mobile", value = "手机号"),
            @ApiImplicitParam(type = "body", required = true, dataType = "String", name = "code", value = "验证码"),
    })
    @PostMapping("login/sms")
    public ResponseDto<String> loginBySms(@RequestParam String mobile, @RequestParam String code) {
        log.info("mobile:{},code:{}", mobile, code);



        return ResponseDto.success("token.........");
    }

    /* ------------------------------------------------------------------ */

    @ApiOperation(value = "演出列表")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "body", required = true, dataType = "String", name = "mod", value = "模块[recent-近期的,down-已下载,over-历史]", allowableValues = "recent,down,over"),
    })
    @GetMapping("performances/{mod}")
    public ResponseDto<KylinStationPerformanceVo> performances(@PathVariable String mod) {
        log.info("mod:{}", mod);



        return ResponseDto.success(KylinStationPerformanceVo.getNew());
    }

    @ApiOperation(value = "下载验票数据")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "body", required = true, dataType = "String", name = "type", value = "类型[101-音乐节,102小型演出(livehouse演出),103巡演]", allowableValues = "101,102,103"),
            @ApiImplicitParam(type = "body", required = true, dataType = "String", name = "performanceId", value = "演出ID[64]"),
    })
    @GetMapping("download/{type}/{performanceId}")
    public ResponseDto<List<KylinStationCheckOrderVo>> downloadTicketData(@PathVariable String type, @PathVariable String performanceId) {
        log.info("type:{},performanceId:{}", type, performanceId);



        return ResponseDto.success(Collections.singletonList(KylinStationCheckOrderVo.getNew()));
    }

    @ApiOperation(value = "上载验票数据")
    @PostMapping("upload")
    public ResponseDto<Boolean> uploadTicketData(@RequestBody List<KylinStationCheckOrderParam> checkDataParams) {
        log.info("checkDataParams:{}", JsonUtils.toJson(checkDataParams));



        return ResponseDto.success(true);
    }

    /* ------------------------------------------------------------------ */

    private String loginProcess() {

        return null;
    }
}
