package com.liquidnet.service.kylin.controller.admin;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.service.impl.admin.KylinRefundsServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * <p>
 * 后台单订单退款 服务实现类
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-05-25 10:58 上午
 */

@Api(tags = "后端-单订单退款")
@RestController
@RequestMapping("admin/refund")

public class KylinRefundAdminController {

    @Autowired
    private KylinRefundsServiceImpl kylinRefundsServiceImpl;

    @PostMapping("apply")
    @ApiOperation("申请退款")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "body", dataType = "String", name = "orderTicketsId", value = "订单id", required = true),
            @ApiImplicitParam(type = "body", dataType = "String", name = "orderType", value = "订单order_ticket 商品order_product", required = true),
            @ApiImplicitParam(type = "body", dataType = "String", name = "reason", value = "备注", required = true),
            @ApiImplicitParam(type = "body", dataType = "String", name = "remark", value = "备注"),
            @ApiImplicitParam(type = "body", dataType = "Integer", name = "batch_id", value = "批量id"),
            @ApiImplicitParam(type = "body", dataType = "String", name = "refundData", value = "退款数据")
    })
    public ResponseDto<Object> refundApply(
            @RequestBody String orderTicketsId,
            @RequestBody String orderType,
            @RequestBody String reason,
            @RequestBody String remark,
            @RequestBody Integer batch_id,
            @RequestBody String refundData
    ) throws Exception {
        Boolean res = kylinRefundsServiceImpl.refundApply(orderTicketsId, orderType, reason, remark, batch_id, refundData);
        if (res) {
            return ResponseDto.success();
        } else {
            return ResponseDto.failure("申请退款失败");
        }
    }

}
