package com.liquidnet.service.adam.dto.vo;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.adam.entity.AdamEnters;
import com.liquidnet.service.adam.entity.AdamMember;
import com.liquidnet.service.adam.entity.AdamMemberPrice;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.beans.BeanUtils;

import java.util.ArrayList;
import java.util.List;

@ApiModel(value = "AdamMemberVo", description = "会员")
@Data
public class AdamMemberVo implements java.io.Serializable, Cloneable {
    private static final long serialVersionUID = 5258094625450569125L;
    @ApiModelProperty(position = 0, value = "会员ID[50]")
    private String memberId;
    @ApiModelProperty(position = 1, value = "会员名称[50]", example = "摩登天空会员卡")
    private String name;
    @ApiModelProperty(position = 2, value = "会员标题[50]", example = "摩登天空会员卡")
    private String title;
    @ApiModelProperty(position = 3, value = "会员副标题[50]", example = "摩登天空会员卡副标题")
    private String subTitle;
    @ApiModelProperty(position = 4, value = "icon图标[200]", example = "https://img.zhengzai.tv/files/2020/08/28/5f490418d30b4.png")
    private String icon;
    @ApiModelProperty(position = 5, value = "会员头像[200]", example = "https://img.zhengzai.tv/files/2020/08/31/5f4c75095e9bc.pngv")
    private String avatar;
    @ApiModelProperty(position = 6, value = "权益详情[200]", example = "加入摩登天空会员您可享受到.....")
    private String interestsDetail;
    @ApiModelProperty(position = 7, value = "注意事项[200]", example = "摩登天空会员需注意以下事项.....")
    private String notes;
    @ApiModelProperty(position = 8, value = "是否展示须知[200]", example = "0")
    private Integer isNotice;
    @ApiModelProperty(position = 9, value = "会员须知内容[200]", example = "会员须知细则1.xxxx\n2.xxxx")
    private String noticeInfo;
    @ApiModelProperty(position = 10, value = "会员须知标题[200]", example = "摩登天空会员须知")
    private String noticeTitle;
    @ApiModelProperty(position = 11, value = "是否需要答题[200]", example = "0")
    private Integer needQuestion;
    @ApiModelProperty(position = 12, value = "是否展示协议[200]", example = "0")
    private Integer displayAgreement;
//    @ApiModelProperty(position = 13, value = "会员协议内容[200]", example = "摩登天空会员协议须知....")
//    private String agreement;
    @ApiModelProperty(position = 14, value = "限购数量，0不限购[200]", example = "0")
    private Integer limitation;
    @ApiModelProperty(position = 15, value = "会员卡价格信息")
    private List<AdamMemberPriceVo> priceVoList;
    @ApiModelProperty(position = 16, value = "会员专属权益")
    private List<AdamMemberRightsVo> rightsVoList;
    @ApiModelProperty(position = 17, value = "用户会员信息")
    private AdamUserMemberVo memberInfo;

    private static final AdamMemberVo obj = new AdamMemberVo();

    public static AdamMemberVo getNew() {
        try {
            return (AdamMemberVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new AdamMemberVo();
    }

    /**
     * 设置会员价格
     * @param adamMemberPrices
     * @return
     */
    @JsonIgnore
    public static List<AdamMemberPriceVo> setMemberPrice(List<AdamMemberPrice> adamMemberPrices){
        List<AdamMemberPriceVo> adamMemberPricesVo = new ArrayList<>();
        for (int i =0;i<adamMemberPrices.size();i++){
            AdamMemberPrice adamMemberPrice = adamMemberPrices.get(i);
            AdamMemberPriceVo adamMemberPriceVo = new AdamMemberPriceVo();
            BeanUtils.copyProperties(adamMemberPrice, adamMemberPriceVo);
            adamMemberPriceVo.setCreatedAt(DateUtil.format(adamMemberPrice.getCreatedAt(), DateUtil.Formatter.yyyyMMddHHmmss));
            adamMemberPriceVo.setUpdatedAt(DateUtil.format(adamMemberPrice.getUpdatedAt(), DateUtil.Formatter.yyyyMMddHHmmss));
        }
        return adamMemberPricesVo;
    }

    /**
     * 组装MQ需要的对象
     * @param adamMember
     * @return
     */
    @JsonIgnore
    public List<Object> getMqList(AdamMember adamMember){
        List<Object> paramList = new ArrayList<>();
        paramList.add(adamMember.getName());
        paramList.add(adamMember.getTitle());
        paramList.add(adamMember.getSubTitle());
        paramList.add(adamMember.getIcon());
        paramList.add(adamMember.getAvatar());
        paramList.add(adamMember.getStartNo());
        paramList.add(adamMember.getType());
        paramList.add(adamMember.getInterestsDetail());
        paramList.add(adamMember.getNotes());
        paramList.add(adamMember.getIsNotice());
        paramList.add(adamMember.getNoticeInfo());
        paramList.add(adamMember.getNoticeTitle());
        paramList.add(adamMember.getNeedQuestion());
        paramList.add(adamMember.getDisplayAgreement());
        paramList.add(adamMember.getAgreement());
        paramList.add(adamMember.getMemberId());
        paramList.add(adamMember.getLimitation());
        return paramList;
    }
}
