package com.liquidnet.service.account.funding.dto;

import com.liquidnet.service.account.funding.dto.base.FundingCallParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * FundingEditorParam.class
 *
 * @author zhanggb
 * Created by IntelliJ IDEA at 2020/10/20
 */
@ApiModel(value = "FundingEditorParam", description = "Parameters of funding account edit")
public class FundingEditorParam extends FundingCallParam {
    private static final long serialVersionUID = 1698388587978280459L;
    @ApiModelProperty(position = 11, required = true, value = "Funding account number [32]", example = "18400000001000")
    private String accNo;
    @ApiModelProperty(position = 12, required = false, value = "Funding account alias [100]", example = "184001")
    private String accAlias;
    @ApiModelProperty(position = 13, required = false, value = "Funding account status [5]", example = "4")
    private int accStatus;

    public String getAccNo() {
        return accNo;
    }

    public void setAccNo(String accNo) {
        this.accNo = accNo;
    }

    public String getAccAlias() {
        return accAlias;
    }

    public void setAccAlias(String accAlias) {
        this.accAlias = accAlias;
    }

    public int getAccStatus() {
        return accStatus;
    }

    public void setAccStatus(int accStatus) {
        this.accStatus = accStatus;
    }
}