package com.liquidnet.service.base.constant;

public class MQConst {
    public static final String QUEUE_MESSAGE_KEY = "message";

    public enum AdamQueue {
        SMS_NOTICE("adam:stream:rk.sms.notice", "group.sms.sender", "短信通知"),
//        SMS_SPREAD("adam:stream:rk.sms.spread", "group.sms.sender", "短信推广"),

        SQL_UREGISTER("adam:stream:rk.sql.uregister", "group.sql.ucenter", "用户注册"),
        SQL_UCENTER("adam:stream:rk.sql.ucenter", "group.sql.ucenter", "用户中心"),
        SQL_UMEMBER("adam:stream:rk.sql.umember", "group.sql.ucenter", "购买会员"),
        ;
        private final String key;
        private final String group;
        private final String desc;

        AdamQueue(String key, String group, String desc) {
            this.key = key;
            this.group = group;
            this.desc = desc;
        }

        public String getKey() {
            return key;
        }

        public String getGroup() {
            return group;
        }

        public String getDesc() {
            return desc;
        }
    }

    public enum KylinQueue {
        SMS_NOTICE("adam:stream:rk.sms.notice", "group.sms.sender", "短信通知"),
//        SMS_SPREAD("adam:stream:rk.sms.spread", "group.sms.sender", "短信推广"),

        SQL_PERFORMANCE_LACK("kylin:stream:rk.performance.lack", "group.performance.lack", "缺票登记"),
        SQL_ORDER_CREATE("kylin:stream:rk.order.create", "group.order.create", "创建订单"),
        SQL_ORDER_AGAIN("kylin:stream:rk.order.again", "group.order.again", "订单再次支付"),
        SQL_ORDER_CLOSE("kylin:stream:rk.order.close", "group.order.close", "订单关闭"),
        SQL_ORDER_PAY("kylin:stream:rk.order.pay", "group.order.pay", "订单支付"),
        SQL_ORDER_REFUND("kylin:stream:rk.order.refund", "group.order.refund", "订单申请退款"),
        SQL_ORDER_REFUND_EXPRESS("kylin:stream:rk.refundOrderExpress", "group.refundOrderExpress", "用户退款发快递"),
        SQL_ORDER_WITHDRAW("kylin:stream:rk.order.withdraw", "group.order.withdraw", "订单申请撤回"),
        SQL_ORDER_OVERTIME_REFUND("kylin:stream:rk.order.overtime.refund", "group.order.overtime.refund", "超时支付申请退款"),
        SQL_STATION("kylin:stream:rk.station", "group.station", "验票更新"),
        SQL_TRANSFER("kylin:stream:rk.transfer", "group.transfer", "订单发起转赠/万青补偿快递"),
        SQL_TRANSFER_RESULT("kylin:stream:rk.transfer.result", "group.transfer.result", "订单结果转赠"),
        SQL_TRANSFER_OVERTIME("kylin:stream:rk.transfer.overtime", "group.transfer.overtime", "订单结果转赠"),
        ;
        private final String key;
        private final String group;
        private final String desc;

        KylinQueue(String key, String group, String desc) {
            this.key = key;
            this.group = group;
            this.desc = desc;
        }

        public String getKey() {
            return key;
        }

        public String getGroup() {
            return group;
        }

        public String getDesc() {
            return desc;
        }
    }


    public enum SweetQueue {
        ARTISTS_RELATION("sweet:stream:rk.artists.relation", "group.artists.relation", "用户-关系"),
        ARTISTS_RELATION_MDSK("sweet:stream:rk.artists.mdsk.relation", "group.artists.mdsk.relation", "用户-关系"),
        LUCK_DRAW("sweet:stream:rk.luckDraw", "group.luckDraw", "用户-抽奖"),
        SWEET_ANSWER_INSERT("sweet:stream:rk.answerInsert", "group.answerInsert", "答案"),
        SWEET_WECHAT_USER_INSERT("sweet:stream:rk.sweetUserInsert", "group.sweetUserInsert", "关注服务号的用户信息"),
        SWEET_REMIND_INSERT("sweet:stream:rk.remindInsert", "group.remindInsert", "提醒记录"),
        SWEET_TEMPLATE_MSG("sweet:stream:rk.sweetTemplateMsg", "group.sweetTemplateMsg", "发送模版消息"),
        SWEET_CITY_VOTE("sweet:stream:rk.cityVote", "group.cityVote", "用户投票记录"),
        SWEET_ANTIGENIC_QUESTION("sweet:stream:rk.antigenicQuestion", "group.antigenicQuestion", "防疫答题"),
        SWEET_POSTER("sweet:stream:rk.userLikeMusician", "group.userLikeMusician", "用户喜欢的音乐人"),
        SWEET_WECHAT_MAODENG_TEXT_INSERT("sweet:stream:rk.textAndImgInsert", "group.sweetMaoDengInsert", "猫登天空"),

        SWEET_INTEGRAL_ACTIVITY_DRAW("sweet:stream:rk.integralActivityDraw", "group.integralActivityDraw", "积分抽奖"),
        SWEET_STONE_INTEGRAL("sweet:stream:rk.stoneIntegral", "group.stoneIntegral", "stone积分处理"),
        ;

        private final String key;
        private final String group;
        private final String desc;

        SweetQueue(String key, String group, String desc) {
            this.key = key;
            this.group = group;
            this.desc = desc;
        }

        public String getKey() {
            return key;
        }

        public String getGroup() {
            return group;
        }

        public String getDesc() {
            return desc;
        }
    }

    public enum CandyQueue {
        COUPON_USE("candy:stream:rk.coupon.use", "group.coupon.use", "券-使用"),
        COUPON_BACK("candy:stream:rk.coupon.back", "group.coupon.back", "券-回退"),
        COUPON_RECEIVE("candy:stream:rk.coupon.receive", "group.coupon.receive", "券-领取"),
        COUPON_ORDER_BACK("candy:stream:rk.coupon.order.back", "group.coupon.order.back", "券-订单-回退"),
        ;

        private final String key;
        private final String group;
        private final String desc;

        CandyQueue(String key, String group, String desc) {
            this.key = key;
            this.group = group;
            this.desc = desc;
        }

        public String getKey() {
            return key;
        }

        public String getGroup() {
            return group;
        }

        public String getDesc() {
            return desc;
        }
    }

    public enum SlimeQueue {
        SQL_SLIME_FIELD("slime:stream:rk.sql.field", "group.sql.field", "场地相关"),
        SQL_SLIME_SPONSOR("slime:stream:rk.sql.sponsor", "group.sql.sponsor", "主办相关"),


        SQL_SLIME_TICKET_UPDATE("slime:stream:rk.ticket", "group.ticket", "票种相关"),
        SQL_SLIME_PERFORMANCE_UPDATE("slime:stream:rk.performance", "group.performance", "演出相关"),
        SQL_SLIME_STEP2("slime:stream:rk.performance.step2", "group.performance.step2", "修改演出第二部"),
        SQL_SLIME_LINE("slime:stream:rk.any.line", "group.any.line", "上下线相关"),
        SQL_SLIME_PERFORMANCE_INSERT("slime:stream:rk.performance.insert", "group.performance.insert", "创建演出"),
        ;

        private final String key;
        private final String group;
        private final String desc;

        SlimeQueue(String key, String group, String desc) {
            this.key = key;
            this.group = group;
            this.desc = desc;
        }

        public String getKey() {
            return key;
        }

        public String getGroup() {
            return group;
        }

        public String getDesc() {
            return desc;
        }
    }

    public enum StoneQueue {
        STONE_INSERT_LOGS("stone:stream:rk.logs.insert", "group.stone.logs.insert", "积分日志-添加"),
        STONE_INSERT_USER("stone:stream:rk.user.insert", "group.stone.user.insert", "积分用户-添加"),
//        STONE_COUPON_SEED("stone:stream:rk.coupon.send", "group.stone.coupon.send", "购买券-发放"),
        STONE_ORDER_COUPON("stone:stream:rk.order.pay", "group.stone.order.pay", "下订单-发放券"),
        ;

        private final String key;
        private final String group;
        private final String desc;

        StoneQueue(String key, String group, String desc) {
            this.key = key;
            this.group = group;
            this.desc = desc;
        }

        public String getKey() {
            return key;
        }

        public String getGroup() {
            return group;
        }

        public String getDesc() {
            return desc;
        }
    }
    public enum SmileQueue {
        SMILE_USER("smile:stream:sql.user", "group.smile.user", "用户的增删改");
        private final String key;
        private final String group;
        private final String desc;

        SmileQueue(String key, String group, String desc) {
            this.key = key;
            this.group = group;
            this.desc = desc;
        }

        public String getKey() {
            return key;
        }

        public String getGroup() {
            return group;
        }

        public String getDesc() {
            return desc;
        }
    }
    public enum ChimeQueue {
        USER_OPERATION_LIKE("chime:stream:rk.user.operation.like", "group.user.operation.like", "划卡操作-喜欢"),
        USER_OPERATION_DISLIKE("chime:stream:rk.user.operation.dislike", "group.user.operation.dislike", "划卡操作-不喜欢");
        private final String key;
        private final String group;
        private final String desc;

        ChimeQueue(String key, String group, String desc) {
            this.key = key;
            this.group = group;
            this.desc = desc;
        }

        public String getKey() {
            return key;
        }

        public String getGroup() {
            return group;
        }

        public String getDesc() {
            return desc;
        }
    }

    public enum GoblinQueue {
        SQL_STORE("goblin:stream:sql.store", "group.sql.ustore", "店铺相关"),
        SQL_GOODS("goblin:stream:sql.goods", "group.sql.ustore", "商品相关"),
        SQL_COUPON("goblin:stream:sql.coupon", "group.sql.ustore", "店铺优惠券相关"),

        GOBLIN_STORE_MARKET("goblin:stream:store.market", "group.store.market", "店铺活动"),
        GOBLIN_SELF_MARKET("goblin:stream:self.market", "group.self.market", "平台活动"),
        GOBLIN_ORDER_CREATE_PAY("goblin:stream:order:create_pay", "group.order:create_pay", "订单创建&支付"),
        GOBLIN_SHOP_CART("goblin:stream:sql.shopcart","group.shop.shopcart","购物车"),
        GOBLIN_ORDER_AGAIN("goblin:stream:order:again", "group.order:again", "订单再次支付"),
        GOBLIN_ORDER_CLOSE("goblin:stream:order:close", "group.order:close", "订单关闭"),
        GOBLIN_STORE_ORDER_OPERA("goblin:stream:order:store", "group.order:store", "商铺订单操作"),
        GOBLIN_USER_ORDER_OPERA("goblin:stream:order:user", "group.order:user", "用户订单操作"),
        GOBLIN_XLS_OPERA("goblin:stream:xls", "group.xls", "xls文件操作"),
        GOBLIN_PHONE_CODE_OPERA("goblin:stream:phone:code","group.phone:code","批量空投操作"),
        GOBLIN_CODE_OPERA("goblin:stream:code","group.code","修改兑换码操作人"),

        GOBLIN_UN_PAY_0("goblin:stream:order:back:0", "group.order:back", "回滚关闭订单库存队列"),
        GOBLIN_UN_PAY_1("goblin:stream:order:back:1", "group.order:back", "回滚关闭订单库存队列"),
        GOBLIN_UN_PAY_2("goblin:stream:order:back:2", "group.order:back", "回滚关闭订单库存队列"),
        GOBLIN_UN_PAY_3("goblin:stream:order:back:3", "group.order:back", "回滚关闭订单库存队列"),
        GOBLIN_UN_PAY_4("goblin:stream:order:back:4", "group.order:back", "回滚关闭订单库存队列"),
        GOBLIN_UN_PAY_5("goblin:stream:order:back:5", "group.order:back", "回滚关闭订单库存队列"),
        GOBLIN_UN_PAY_6("goblin:stream:order:back:6", "group.order:back", "回滚关闭订单库存队列"),
        GOBLIN_UN_PAY_7("goblin:stream:order:back:7", "group.order:back", "回滚关闭订单库存队列"),
        GOBLIN_UN_PAY_8("goblin:stream:order:back:8", "group.order:back", "回滚关闭订单库存队列"),
        GOBLIN_UN_PAY_9("goblin:stream:order:back:9", "group.order:back", "回滚关闭订单库存队列"),

        BIZ_ARTWORK_UPL("goblin:stream:biz_art:upl", "group.biz.artwork", "藏品上传声明"),
        BIZ_ARTWORK_CLQ("goblin:stream:biz_art:clq", "group.biz.artwork", "藏品声明查询"),
        BIZ_ARTWORK_GEN("goblin:stream:biz_art:gen", "group.biz.artwork", "藏品生成"),
        SQL_ARTWORK_GEN("goblin:stream:sql_art:gen", "group.biz.artwork", "藏品生成"),

        GOBLIN_NFT_ORDER("goblin:stream:nftOrder:create", "group.nftOrder:create", "NFT订单处理"),
        BIZ_INTEGRAL("goblin:stream:biz_integral", "group.biz.integral", "增减积分操作"),
        BIZ_NFT_MONGO("goblin:stream:biz:mongo:nft", "group.biz.mongo.nft", "NFT的mongo操作"),

        ;

        private final String key;
        private final String group;
        private final String desc;

        GoblinQueue(String key, String group, String desc) {
            this.key = key;
            this.group = group;
            this.desc = desc;
        }

        public String getKey() {
            return key;
        }

        public String getGroup() {
            return group;
        }

        public String getDesc() {
            return desc;
        }
    }

    public enum GalaxyQueue {
        SQL_USER_INFO("galaxy:stream:rk.sql.userInfo", "group.sql.userInfo", "用户注册信息"),
        SQL_SERIES_INFO("galaxy:stream:rk.sql.seriesInfo", "group.sql.seriesInfo", "系列信息"),
        SQL_NFT_ORDER_INFO("galaxy:stream:rk.sql.nftOrderInfo", "group.sql.nftOrderInfo", "订单信息"),
        SQL_NFT_TRADE_INFO("galaxy:stream:rk.sql.nftTradeInfo", "group.sql.nftTradeInfo", "交易信息"),
        SQL_NFT_ORDER_FAIL_LOG("galaxy:stream:rk.sql.nftOrderFailLog", "group.sql.nftOrderFailLog", "交易发行购买失败记录"),
        JSON_NFT_PUBLISH_AND_BUY("galaxy:stream:rk.json.nftPublishAndBuy", "group.json.nftPublishAndBuy", "NFT发行和购买"),
        JSON_NFT_USER_REGISTER("galaxy:stream:rk.json.userRegister", "group.json.userRegister", "NFT用户注册"),
        JSON_NFT_TRANSFER("galaxy:stream:rk.json.nftTransfer", "group.json.nftTransfer", "NFT转让");
        private final String key;
        private final String group;
        private final String desc;

        GalaxyQueue(String key, String group, String desc) {
            this.key = key;
            this.group = group;
            this.desc = desc;
        }

        public String getKey() {
            return key;
        }

        public String getGroup() {
            return group;
        }

        public String getDesc() {
            return desc;
        }
    }

    public enum DragonQueue {
        //支付相关队列
        DRAGON_PAY_KEY("dragon:stream:dragon-pay","dragon-pay-group","同步数据-支付"),
        DRAGON_REFUND_KEY ("dragon:stream:dragon-refund","dragon-refund-group","同步数据-退款"),
        //三方异步通知相关队列
        DRAGON_PAY_NOTIFY_KEY("dragon:stream:dragon-pay-notify-key","dragon-pay-notify-group","支付异步通知"),
        //商户通知相关队列
        PAY_MCH_NOTIFY_KEY("dragon:stream:pay-mch-notify-key","pay-mch-notify-group","商户异步通知"),
        PAY_MCH_NOTIFY_ERROR_KEY("dragon:stream:pay-mch-notify-error-key","pay-mch-notify-error-group","商户异步通知失败");

        private final String key;
        private final String group;
        private final String desc;

        DragonQueue(String key, String group, String desc) {
            this.key = key;
            this.group = group;
            this.desc = desc;
        }

        public String getKey() {
            return key;
        }

        public String getGroup() {
            return group;
        }

        public String getDesc() {
            return desc;
        }
    }

    public enum CommonQueue {
        /**
         * SQL持久化：优先级0<1<2<3...
         */
        SQL0("stream:common:sql:0", "group.sql", "Mysql持久化0"),
        SQL1("stream:common:sql:1", "group.sql", "Mysql持久化1"),
        SQL2("stream:common:sql:2", "group.sql", "Mysql持久化2"),
        SQL3("stream:common:sql:3", "group.sql", "Mysql持久化3"),

        MDB0("stream:common:mdb:0", "group.mdb", "Mongo持久化0"),

        ;
        private final String key;
        private final String group;
        private final String desc;

        CommonQueue(String key, String group, String desc) {
            this.key = key;
            this.group = group;
            this.desc = desc;
        }

        public String getKey() {
            return key;
        }

        public String getGroup() {
            return group;
        }

        public String getDesc() {
            return desc;
        }
    }

    public static void main(String[] args) {
    }
}
