package com.liquidnet.common.third.xuper.constant;

import java.util.Arrays;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: XuperErrorEnum
 * @Package com.liquidnet.common.third.xuper.constant
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/6/21 14:09
 */
public enum XuperErrorEnum {
    SECCESS("0","成功"),
    FAILURE("1","失败"),
    SYSTEM_ERROR("SYS0010001", "系统异常，请联系管理员"),
    SERVER_INNER_ERROR("SYS0010002", "系统内部错误"),
    SERVER_ERROR("SYS0010003", "服务不可用,调用后端服务失败"),
    INVALID_PARAM_ERROR("XUPER0010001", "参数错误"),
    GENERATE_KEYPAIR_ERROR("XUPER0010002", "生成公私钥错误"),
    SIGN_ERROR("XUPER0010003", "签名错误"),
    VERIFY_ERROR("XUPER0010004", "验签错误"),
    ENCRYPT_ERROR("XUPER0010005", "加密数据错误"),
    DECODE_ERROR("XUPER0010006", "解密数据错误"),
    IMAGE_CHECK_ERROR("XUPER0010007", "图片内容检测未通过"),
    PARAM_FORMAT_ERROR("XUPER0010008", "参数格式错误"),
    ORDER_NOT_FOUND_ERROR("XUPER0010009", "此编号未查到对应信息"),
    UPLOAD_TEMP_SECRET("XUPER0010010", "生成素材上传临时密钥失败");
    private String code;
    private String msg;
    XuperErrorEnum(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }
    public String getCode() { return this.code; }
    public String getMsg() { return this.msg; }
    public static String errorMsg(String content) {
        XuperErrorEnum err = Arrays.<XuperErrorEnum>asList(values()).stream().filter(errorEnum -> errorEnum.getCode().equals(content)).findFirst().orElse(SERVER_INNER_ERROR);
        return err.getMsg();
    }
}
