package com.liquidnet.service.sweet.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 提醒记录表
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-08-13
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class SweetRemind implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * remind_id
     */
    private String remindId;

    /**
     * openId
     */
    @TableField("openId")
    private String openId;

    /**
     * unionId
     */
    @TableField("unionId")
    private String unionId;

    /**
     * 演出id
     */
    @TableField("performancesId")
    private String performancesId;

    /**
     * 是否推送 1未推送 2已推送
     */
    private Integer isPush;

    /**
     * 推送时间
     */
    private String pushTime;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 更新时间
     */
    private LocalDateTime updatedAt;

    private static final SweetRemind obj = new SweetRemind();
    public static SweetRemind getNew() {
        try {
            return (SweetRemind) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new SweetRemind();
        }
    }


}
