package com.liquidnet.service.goblin.dto.vo;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.liquidnet.service.goblin.entity.GoblinNftExCode;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @Author: wll
 * @Description: NFT兑换码表
 * @Date:Create：in 2022/4/19 1:55 下午
 */

@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinNftExCodeVo implements Serializable, Cloneable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;


    /**
     * 兑换码id
     */
    @ApiModelProperty(position = 10,required = true,value ="兑换码id")
    private String codeId;

    /**
     * 活动id
     */
    @ApiModelProperty(position = 10,required = true,value ="活动id")
    private String activityId;


    /**
     * 兑换码
     */
    @ApiModelProperty(position = 10,required = true,value ="兑换码")
    private String code;

    /**
     * 商品id
     */
    @ApiModelProperty(position = 10,required = true,value ="款式id")
    private String spuId;

    /**
     * 款式id
     */
    @ApiModelProperty(position = 10,required = true,value ="")
    private String skuId;

    /**
     * 盲盒抽取的款式id
     */
    @ApiModelProperty(position = 10,required = true,value ="")
    private String boxSkuId;

    /**
     * 店铺id
     */
    @ApiModelProperty(position = 10,required = true,value ="")
    private String storeId;


    /**
     * 兑换码状态 1 未兑换  2  已兑换
     */
    @ApiModelProperty(position = 10,required = true,value ="")
    private Integer state;


    /**
     * 兑换用户id
     */
    @ApiModelProperty(position = 10,required = true,value ="")
    private String redeemUid;

    /**
     * 操作用户id
     */
    @ApiModelProperty(position = 10,required = true,value ="")
    private String adminUid;


    /**
     * 兑换时间
     */
    @ApiModelProperty(position = 10,required = true,value ="")
    private LocalDateTime redeemAt;


    /**
     * 创建时间
     */
    @ApiModelProperty(position = 10,required = true,value ="")
    private LocalDateTime createdAt;


    /**
     * 更新时间
     */
    @ApiModelProperty(position = 10,required = true,value ="")
    private LocalDateTime updatedAt;

    /**
     * 兑换限购
     */
    @ApiModelProperty(position = 10,required = true,value ="")
    private Integer exLimit;


    /**
     * 兑换生效开始时间
     */
    @ApiModelProperty(position = 10,required = true,value ="")
    private LocalDateTime exStartTime;


    /**
     * 兑换生效结束时间
     */
    @ApiModelProperty(position = 10,required = true,value ="")
    private LocalDateTime exStopTime;

    /**
     * sku名称
     */
    @ApiModelProperty(position = 10,required = true,value ="")
    private String skuName;






    private static final GoblinNftExCodeVo obj = new GoblinNftExCodeVo();

    public static GoblinNftExCodeVo getNew() {
        try {
            return (GoblinNftExCodeVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinNftExCodeVo();
        }
    }

    public GoblinNftExCodeVo copy(GoblinNftExCode goblinNftExCode){
        if (null == goblinNftExCode)return this;
        this.setCodeId(goblinNftExCode.getCodeId());
        this.setActivityId(goblinNftExCode.getActivityId());
        this.setCode(goblinNftExCode.getCode());
        this.setSkuId(goblinNftExCode.getSkuId());
        this.setState(goblinNftExCode.getState());
        this.setRedeemUid(goblinNftExCode.getRedeemUid());
        this.setAdminUid(goblinNftExCode.getAdminUid());
        this.setRedeemAt(goblinNftExCode.getRedeemAt());
        this.setCreatedAt(goblinNftExCode.getCreatedAt());
        this.setUpdatedAt(goblinNftExCode.getUpdatedAt());
        return this;
    }


}
