package com.liquidnet.service.goblin.dto.vo;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.liquidnet.service.goblin.entity.GoblinNftExSku;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.time.LocalDateTime;

/**
 * @Author: wll
 * @Description:
 * @Date:Create：in 2022/4/19 2:23 下午
 */

@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinNftExSkuVo {


    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;


    /**
     * 活动id
     */
    @ApiModelProperty(position = 10,required = true,value ="")
    private String activityId;

    /**
     * 商品id
     */
    @ApiModelProperty(position = 10,required = true,value ="")
    private String spuId;


    /**
     * 款式id
     */
    @ApiModelProperty(position = 10,required = true,value ="")
    private String skuId;

    /**
     * 是否盲盒 0：否   1：是
     */
    @ApiModelProperty(position = 10,required = true,value ="")
    private String unBox;

    /**
     * 店铺id
     */
    @ApiModelProperty(position = 10,required = true,value ="")
    private String storeId;


    /**
     * 兑换库存
     */
    @ApiModelProperty(position = 10,required = true,value ="")
    private Integer exStock;

    /**
     * 兑换限购
     */
    @ApiModelProperty(position = 10,required = true,value ="")
    private Integer exLimit;


    /**
     * 兑换生效开始时间
     */
    @ApiModelProperty(position = 10,required = true,value ="")
    private LocalDateTime exStartTime;


    /**
     * 兑换生效结束时间
     */
    @ApiModelProperty(position = 10,required = true,value ="")
    private LocalDateTime exStopTime;

    /**
     * 创建时间
     */
    @ApiModelProperty(position = 10,required = true,value ="")
    private LocalDateTime createdAt;

    /**
     * 修改时间
     */
    @ApiModelProperty(position = 10,required = true,value ="")
    private LocalDateTime updatedAt;

    private  static  final GoblinNftExSkuVo obj = new GoblinNftExSkuVo();

    public  static GoblinNftExSkuVo getNew(){
        try{
           return  (GoblinNftExSkuVo) obj.clone();
        }catch (CloneNotSupportedException e){
            return new GoblinNftExSkuVo();
        }
    }



    public GoblinNftExSkuVo copy(GoblinNftExSku goblinNftExSku){
        if (null == goblinNftExSku) return this;
        this.setActivityId(goblinNftExSku.getActivityId());
        this.setSpuId(goblinNftExSku.getSpuId());
        this.setSkuId(goblinNftExSku.getSkuId());
        this.setUnBox(goblinNftExSku.getUnBox());
        this.setStoreId(goblinNftExSku.getStoreId());
        this.setExStock(goblinNftExSku.getExStock());
        this.setExLimit(goblinNftExSku.getExLimit());
        this.setExStartTime(goblinNftExSku.getExStartTime());
        this.setExStopTime(goblinNftExSku.getExStopTime());
        this.setCreatedAt(goblinNftExSku.getCreatedAt());
        this.setUpdatedAt(goblinNftExSku.getUpdatedAt());
        return this;
    }














}
