package com.liquidnet.service.reconciliation.util.excel2bean.base;

import com.liquidnet.service.reconciliation.util.excel2bean.annotation.ExcelCell;
import org.apache.commons.lang.StringUtils;

import java.text.SimpleDateFormat;

/**
 * @author AnJiabin <jiabin.an@lightnet.io>
 * @version V1.0
 * @Description: DateConvertData
 * @class: DateConvertData
 * @Package com.liquidnet.service.reconciliation.util.excel2bean.base
 * @Copyright: LightNet @ Copyright (c) 2020
 * @date 2020/10/22 10:19
 */
public class DateConvertData implements ConvertData {
    public Object convertData(ExcelCell excelCell, Object origin) throws Exception {
        if(StringUtils.isNotEmpty(excelCell.formatPattern())) {
            return origin != null ? new SimpleDateFormat(excelCell.formatPattern()).parse(origin.toString()):null;
        }
        return origin;
    }
}
