package com.liquidnet.service.reconciliation.strategy.transtype.impl;

import com.liquidnet.service.reconciliation.constant.ReconConstants.TransTypeEnum;
import com.liquidnet.service.reconciliation.strategy.transtype.ITransTypeStrategy;
import com.liquidnet.service.reconciliation.strategy.transtype.annotation.StrategyTransTypeHandler;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * @author AnJiabin <jiabin.an@lightnet.io>
 * @version V1.0
 * @Description: 换汇
 * @class: RechargeTransTypeStrategyImpl
 * @Package com.liquidnet.service.reconciliation.strategy.transtype.impl
 * @Copyright: LightNet @ Copyright (c) 2020
 * @date 2020/10/27 14:58
 */
@Slf4j
@Component
@StrategyTransTypeHandler(TransTypeEnum.EXCHANGE)
public class TransTypeStrategyExchangeImpl implements ITransTypeStrategy {
    @Override
    public void doBusiness() {
        log.info("执行{}-交易类型对账逻辑",TransTypeEnum.EXCHANGE);
    }
}
