package com.liquidnet.service.merchant.dto.param.admin;

import com.liquidnet.commons.lang.constant.LnsRegex;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;

@ApiModel(value = "MerchantFieldEditParam", description = "编辑场地入参")
@Data
public class MerchantFieldEditParam implements java.io.Serializable {
    private static final long serialVersionUID = 7831800656130696525L;

    @ApiModelProperty(position = 10, required = true, value = "场地ID")
    @NotBlank(message = "场地ID不能为空")
    private String fieldId;

    @ApiModelProperty(position = 11, required = true, value = "场地名称[30]", example = "测试")
    @Size(max = 30, message = "场地长度限制1-30位")
    @NotBlank(message = "名称不能为空")
    private String name;
    @ApiModelProperty(position = 12, required = true, value = "logo图", example = "https://img.zhengzai.tv/partner/2019/05/14/5cda2d0520177.png")
    @NotBlank(message = "logo图不能为空")
    private String logo;
    @ApiModelProperty(position = 13, required = true, value = "背景图", example = "https://img.zhengzai.tv/partner/2019/05/14/5cda2d0520177.png")
    @NotBlank(message = "背景图不能为空")
    private String background;
    @ApiModelProperty(position = 14, required = true, value = "介绍[1000]", example = "这是一段介绍文字")
    private String description;
    @ApiModelProperty(position = 15, required = true, value = "建立日期[yyyy-MM-dd]", example = "2021-05-17")
    @Pattern(regexp = LnsRegex.Valid.DATETIME_YMD, message = "建立日期格式有误")
    private String builtDate;

    @ApiModelProperty(position = 16, required = true, value = "省id")
    @NotNull(message = "省id不能为null")
    private String provinceId;
    @ApiModelProperty(position = 17, required = true, value = "省名称")
    @NotNull(message = "省名称不能为null")
    private String provinceName;
    @ApiModelProperty(position = 18, required = true, value = "城市id")
    @NotNull(message = "城市id不能为null")
    private String cityId;
    @ApiModelProperty(position = 19, required = true, value = "城市名称")
    @NotNull(message = "城市名称不能为null")
    private String cityName;
    @ApiModelProperty(position = 20, required = true, value = "县id")
    @NotNull(message = "县id不能为null")
    private String districtId;
    @ApiModelProperty(position = 21, required = true, value = "县名称")
    @NotNull(message = "县名称不能为null")
    private String districtName;
    @ApiModelProperty(position = 22, required = true, value = "详细地址[100]", example = "广渠路1号创1958园区")
    @Size(max = 100, message = "已超出详细地址长度限制")
    @NotNull()
    private String address;
    @ApiModelProperty(position = 23, required = true, value = "经度")
    @NotNull()
    private String longitude;
    @ApiModelProperty(position = 24, required = true, value = "纬度")
    @NotNull()
    private String latitude;

    @ApiModelProperty(position = 25, required = true, value = "联系人姓名", example = "张三")
    @NotNull()
    private String contactName;
    @ApiModelProperty(position = 26, required = true, value = "联系人邮箱", example = "zhangsan@zhengzai.tv")
    @NotNull()
    private String contactEmail;
}
