package com.liquidnet.service.galaxy.utils;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.BeanUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.galaxy.constant.GalaxyConstant;
import com.liquidnet.service.galaxy.constant.GalaxyEnum;
import com.liquidnet.service.galaxy.dto.bo.GalaxyNftOrderBo;
import com.liquidnet.service.galaxy.dto.bo.GalaxySeriesInfoBo;
import com.liquidnet.service.galaxy.dto.bo.GalaxyUserInfoBo;
import com.liquidnet.service.galaxy.dto.vo.mongo.GalaxyNftOrderVo;
import com.liquidnet.service.galaxy.dto.vo.mongo.GalaxyNftTradeVo;
import com.liquidnet.service.galaxy.dto.vo.mongo.GalaxySeriesInfoVo;
import com.liquidnet.service.galaxy.dto.vo.mongo.GalaxyUserInfoVo;
import com.mongodb.client.result.UpdateResult;
import lombok.extern.slf4j.Slf4j;
import org.bson.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.Date;

@Slf4j
@Component
public class DataUtils {
    @Autowired
    private RedisUtil redisUtil;

    @Autowired
    private MongoTemplate mongoTemplate;

    @Autowired
    private QueueUtil queueUtil;

    private long keyExpireTime = 3600*24*30;

    public void setGalaxyUserInfo(String routeType,String userId, GalaxyUserInfoBo userInfoBo) {
        String userType = GalaxyEnum.RegisterTypeEnum.COMPANY.getCode();
        redisUtil.set(GalaxyConstant.REDIS_KET_GALAXY_USER.concat(routeType).concat(":") + userId,userInfoBo,keyExpireTime);
        //入库mongo
        GalaxyUserInfoVo userInfoVo = GalaxyUserInfoVo.getNew();
        BeanUtil.copy(userInfoBo,userInfoVo);

        userInfoVo.setCreatedAt(LocalDateTime.now());
        mongoTemplate.save(userInfoVo,GalaxyUserInfoVo.class.getSimpleName());
//        insert into galaxy_user_info (mid, user_id, user_name, user_type, mobile, id_card_type
//                , id_card, mnemonic, index,user_identification, user_pub_key
//                , user_pri_key, block_chain_address, router_type,created_at, updated_at)
        try{
            queueUtil.sendMySqlRedis(
                    SqlMapping.get("galaxy_user_info.insert"),
                    new Object[]{userId,userInfoBo.getUserName(),userType,userInfoBo.getMobile(),userInfoBo.getIdCardType()
                                 ,userInfoBo.getIdCard(),userInfoBo.getMnemonic(),userInfoBo.getIndex(),userInfoBo.getUserIdentification(),userInfoBo.getUserPubKey()
                                 ,userInfoBo.getUserPriKey(),userInfoBo.getBlockChainAddress(),userInfoBo.getRouterType(),new Date(),null
                    }
                    , MQConst.GalaxyQueue.SQL_USER_INFO.getKey()
            );
        }catch(Exception e){
            log.error(e.getMessage(),e);
            log.error("#setGalaxyUserInfo error ==> MESSAGE:{}",e.getMessage());
        }
    }

    public GalaxyUserInfoBo getGalaxyUserInfo(String routeType,String userId) {
        Object obj = redisUtil.get(GalaxyConstant.REDIS_KET_GALAXY_USER.concat(routeType).concat(":") + userId);
        if(obj!=null){
            return (GalaxyUserInfoBo) obj;
        }else {
            GalaxyUserInfoBo userInfoBo = mongoTemplate.findOne(Query.query(Criteria.where("userId").is(userId)), GalaxyUserInfoBo.class, GalaxyUserInfoBo.class.getSimpleName());
            if (userInfoBo == null) {
                return null;
            }
            redisUtil.set(GalaxyConstant.REDIS_KET_GALAXY_USER.concat(routeType).concat(":") + userId, userInfoBo);
            return userInfoBo;
        }
    }

    public void setSeriesInfoBo(String routeType,String skuId, GalaxySeriesInfoBo seriesInfoBo) {
        redisUtil.set(GalaxyConstant.REDIS_KET_GALAXY_SERIES.concat(routeType).concat(":") + skuId,seriesInfoBo,keyExpireTime);

        //mongo入库
        GalaxySeriesInfoVo seriesInfoVo = GalaxySeriesInfoVo.getNew();
        BeanUtil.copy(seriesInfoBo,seriesInfoVo);
        seriesInfoVo.setCreatedAt(LocalDateTime.now());
        mongoTemplate.save(seriesInfoVo,GalaxySeriesInfoVo.class.getSimpleName());

//        insert into galaxy_series_info (mid, sku_id, series_name, series_id, total_count, crt_count
//                , original_nft_url,original_display_url, series_claim_task_id, series_claim_status, author
//                , nft_name,nft_url, display_url, nft_desc, nft_flag
//                , sell_count, cover_url, series_desc, nft_hash,router_type
//                , created_at, updated_at)
        try{
            queueUtil.sendMySqlRedis(
                    SqlMapping.get("galaxy_series_info.insert"),
                    new Object[]{skuId,seriesInfoBo.getSeriesName(),seriesInfoBo.getSeriesId(),seriesInfoBo.getTotalCount(),seriesInfoBo.getCrtCount()
                            ,seriesInfoBo.getOriginalNftUrl(),seriesInfoBo.getOriginalDisplayUrl(),seriesInfoBo.getSeriesClaimTaskId(),seriesInfoBo.getSeriesClaimStatus(),seriesInfoBo.getAuthor()
                            ,seriesInfoBo.getNftName(),seriesInfoBo.getNftUrl(),seriesInfoBo.getDisplayUrl(),seriesInfoBo.getNftDesc(),seriesInfoBo.getNftFlag()
                            ,seriesInfoBo.getSellCount(),seriesInfoBo.getCoverUrl(),seriesInfoBo.getSeriesDesc(),seriesInfoBo.getNftHash(),seriesInfoBo.getRouterType()
                            ,LocalDateTime.now()
                    }
                    , MQConst.GalaxyQueue.SQL_SERIES_INFO.getKey()
            );
        }catch(Exception e){
            log.error(e.getMessage(),e);
            log.error("#setSeriesInfoBo error ==> MESSAGE:{}",e.getMessage());
        }
    }

    public GalaxySeriesInfoBo getSeriesInfoBo(String routeType, String skuId) {
        Object obj = redisUtil.get(GalaxyConstant.REDIS_KET_GALAXY_SERIES.concat(routeType).concat(":") + skuId);
        if(obj!=null){
            return (GalaxySeriesInfoBo) obj;
        }else {
            GalaxySeriesInfoBo seriesInfoBo = mongoTemplate.findOne(Query.query(Criteria.where("skuId").is(skuId)), GalaxySeriesInfoBo.class, GalaxySeriesInfoBo.class.getSimpleName());
            if (seriesInfoBo == null) {
                return null;
            }
            redisUtil.set(GalaxyConstant.REDIS_KET_GALAXY_SERIES.concat(routeType).concat(":") + skuId, seriesInfoBo);
            return seriesInfoBo;
        }
    }

    public void updateSeriesClaimStatus(String routeType,String skuId, GalaxySeriesInfoBo seriesInfoBo) {
        redisUtil.set(GalaxyConstant.REDIS_KET_GALAXY_SERIES.concat(routeType).concat(":") + skuId,seriesInfoBo,keyExpireTime);

        Query query = Query.query(Criteria.where("skuId").is(seriesInfoBo.getSkuId()));
        Update update = Update.fromDocument(Document.parse(JsonUtils.toJson(seriesInfoBo)));
        update.set("seriesClaimStatus", seriesInfoBo.getSeriesClaimStatus());
        String nowTimeStr = DateUtil.Formatter.yyyyMMddHHmmss.format(LocalDateTime.now());
        update.set("updatedAt",nowTimeStr);
        UpdateResult result = mongoTemplate.updateFirst(query,update, GalaxySeriesInfoVo.class,GalaxySeriesInfoVo.class.getSimpleName());
        log.info("updateSeriesClaimStatus result:{}",result.toString());
    }

    public void setNftOrderBo(String routeType,String nftOrderPayId, GalaxyNftOrderBo nftOrderBo) {

        redisUtil.set(GalaxyConstant.REDIS_KET_GALAXY_TRADE.concat(routeType).concat(":") + nftOrderPayId,nftOrderBo,keyExpireTime);
        /**
         * 入库mongo
         */
        GalaxyNftOrderVo nftOrderVo = GalaxyNftOrderVo.getNew();
        BeanUtil.copy(nftOrderBo,nftOrderVo);
        mongoTemplate.save(nftOrderVo,GalaxyNftOrderVo.class.getSimpleName());

//        insert into galaxy_nft_order_info (mid, nft_order_pay_id, user_id, sku_id, series_name, series_id
//                , nft_id, nft_price,from_address, to_address, nft_publish_task_id, nft_buy_task_id
//                , nft_buy_pay_task_id,router_type, created_at, updated_at)
        try{
            queueUtil.sendMySqlRedis(
                    SqlMapping.get("galaxy_nft_order_info.insert"),
                    new Object[]{nftOrderPayId,nftOrderBo.getUserId(),nftOrderBo.getSkuId(),nftOrderBo.getSeriesName(),nftOrderBo.getSeriesId()
                            ,nftOrderBo.getNftId(),nftOrderBo.getNftPrice(),nftOrderBo.getFromAddress(),nftOrderBo.getToAddress(),nftOrderBo.getNftPublishTaskId()
                            ,nftOrderBo.getNftBuyTaskId(),nftOrderBo.getNftBuyPayTaskId(),nftOrderBo.getRouterType(),LocalDateTime.now(),null
                    }
                    , MQConst.GalaxyQueue.SQL_NFT_ORDER_INFO.getKey()
            );
        }catch(Exception e){
            log.error(e.getMessage(),e);
            log.error("#setNftOrderBo error ==> MESSAGE:{}",e.getMessage());
        }
    }

    public GalaxyNftOrderBo getNftOrderBo(String routeType, String nftOrderPayId) {
        Object obj = redisUtil.get(GalaxyConstant.REDIS_KET_GALAXY_TRADE.concat(routeType).concat(":") + nftOrderPayId);
        if(obj!=null){
            return (GalaxyNftOrderBo) obj;
        }else {
            GalaxyNftOrderVo nftOrderVo = mongoTemplate.findOne(Query.query(Criteria.where("nftOrderPayId").is(nftOrderPayId)), GalaxyNftOrderVo.class, GalaxyNftOrderVo.class.getSimpleName());
            if (nftOrderVo == null) {
                return null;
            }
            GalaxyNftOrderBo nftOrderBo = GalaxyNftOrderBo.getNew();
            BeanUtil.copy(nftOrderVo,nftOrderBo);
            redisUtil.set(GalaxyConstant.REDIS_KET_GALAXY_TRADE.concat(routeType).concat(":") + nftOrderPayId, nftOrderBo);
            return nftOrderBo;
        }
    }

    public void updateNftOrderInfo(String routeType,String nftOrderPayId,GalaxyNftOrderBo nftOrderBo) {
        redisUtil.set(GalaxyConstant.REDIS_KET_GALAXY_TRADE.concat(routeType).concat(":") + nftOrderPayId,nftOrderBo,keyExpireTime);

        Query query = Query.query(Criteria.where("nftOrderPayId").is(nftOrderBo.getNftOrderPayId()));
        Update update = Update.fromDocument(Document.parse(JsonUtils.toJson(nftOrderBo)));
        update.set("nftId", nftOrderBo.getNftId());
        String nowTimeStr = DateUtil.Formatter.yyyyMMddHHmmss.format(LocalDateTime.now());
        update.set("updatedAt",nowTimeStr);
        UpdateResult result = mongoTemplate.updateFirst(query,update, GalaxyNftOrderBo.class,GalaxyNftOrderBo.class.getSimpleName());
        log.info("updateNftOrderInfo result:{}",result.toString());

        try{
            queueUtil.sendMySqlRedis(
                    SqlMapping.get("galaxy_nft_order_info.updateNftId"),
                    new Object[]{nftOrderBo.getNftId(),LocalDateTime.now(),nftOrderBo.getNftOrderPayId()}
                    , MQConst.GalaxyQueue.SQL_NFT_TRADE_INFO.getKey()
            );
        }catch(Exception e){
            log.error(e.getMessage(),e);
            log.error("#setNftTradeInfo error ==> MESSAGE:{}",e.getMessage());
        }
    }

    public void updateNftOrderBuyTaskId(String routeType,String nftOrderPayId,GalaxyNftOrderBo nftOrderBo) {
        redisUtil.set(GalaxyConstant.REDIS_KET_GALAXY_TRADE.concat(routeType).concat(":") + nftOrderPayId,nftOrderBo,keyExpireTime);

        Query query = Query.query(Criteria.where("nftOrderPayId").is(nftOrderPayId));
        Update update = Update.fromDocument(Document.parse(JsonUtils.toJson(nftOrderBo)));
        update.set("nftBuyTaskId", nftOrderBo.getNftBuyTaskId());
        String nowTimeStr = DateUtil.Formatter.yyyyMMddHHmmss.format(LocalDateTime.now());
        update.set("updatedAt",nowTimeStr);
        UpdateResult result = mongoTemplate.updateFirst(query,update, GalaxyNftOrderBo.class,GalaxyNftOrderBo.class.getSimpleName());
        log.info("updateNftOrderInfo result:{}",result.toString());

        try{
            queueUtil.sendMySqlRedis(
                    SqlMapping.get("galaxy_nft_order_info.updateNftBuyTaskId"),
                    new Object[]{nftOrderBo.getNftBuyTaskId(),LocalDateTime.now(),nftOrderBo.getNftOrderPayId()}
                    , MQConst.GalaxyQueue.SQL_NFT_TRADE_INFO.getKey()
            );
        }catch(Exception e){
            log.error(e.getMessage(),e);
            log.error("#setNftTradeInfo error ==> MESSAGE:{}",e.getMessage());
        }
    }

    public void setNftTradeInfo(String routeType, GalaxyNftTradeVo nftTradeVo) {
        /**
         * 入库mongo
         */
        mongoTemplate.save(nftTradeVo,GalaxyNftTradeVo.class.getSimpleName());

//        insert into galaxy_nft_trade_info (mid, nft_id, series_id, trade_hash, chain_timestamp, from_address
//        , to_address,trade_price, trade_type, created_at, updated_at)
        try{
            queueUtil.sendMySqlRedis(
                    SqlMapping.get("galaxy_nft_trade_info.insert"),
                    new Object[]{nftTradeVo.getNftId(),nftTradeVo.getSeriesId(),nftTradeVo.getTradeHash(),nftTradeVo.getChainTimestamp(),nftTradeVo.getFromAddress()
                            ,nftTradeVo.getToAddress(),nftTradeVo.getTradePrice(),nftTradeVo.getTradeType(),LocalDateTime.now(),null
                    }
                    , MQConst.GalaxyQueue.SQL_NFT_TRADE_INFO.getKey()
            );
        }catch(Exception e){
            log.error(e.getMessage(),e);
            log.error("#setNftTradeInfo error ==> MESSAGE:{}",e.getMessage());
        }
    }

}
