package com.liquidnet.service.goblin.dto.manage;

import com.liquidnet.commons.lang.constant.LnsRegex;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.Pattern;
import java.io.Serializable;
import java.math.BigDecimal;

@ApiModel(value = "GoblinStoreMgtGoodsFilterParam", description = "商品管理:商品列表筛选条件")
@Data
public class GoblinStoreMgtGoodsFilterParam implements Serializable {
    private static final long serialVersionUID = -4698854628491039006L;
    @ApiModelProperty(position = 11, value = "当前记录起始索引", example = "1")
    private Integer pageNum;
    @ApiModelProperty(position = 12, value = "每页显示记录数", example = "20")
    private Integer pageSize;
    @ApiModelProperty(position = 13, value = "搜索关键字[128]")
    private String keyword;
    @ApiModelProperty(position = 14, value = "商品上架状态[0-待上架|1-下架|2-违规|3-上架]", allowableValues = "0,1,2,3")
    private String shelvesStatus;
    @ApiModelProperty(position = 15, value = "商品一级分类ID[30]")
    private String cateFid;
    @ApiModelProperty(position = 16, value = "商品二级分类ID[30]")
    private String cateSid;
    @ApiModelProperty(position = 17, value = "商品三级分类ID[30]")
    private String cateTid;
    @ApiModelProperty(position = 18, value = "创建日期[YYYY-MM-DD]")
    @Pattern(regexp = LnsRegex.Valid.DATETIME_YMD, message = "创建日期格式有误")
    private String createdDt;
    @ApiModelProperty(position = 19, value = "价格区间MIN")
    private BigDecimal priceMin;
    @ApiModelProperty(position = 20, value = "价格区间MAX")
    private BigDecimal priceMax;
}
