package com.liquidnet.service.goblin.dto.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@ApiModel(value = "GoblinGoodsServiceSupportVo", description = "商品服务保障信息")
@Data
public class GoblinGoodsServiceSupportVo implements Serializable, Cloneable {
    private static final long serialVersionUID = -6408263563025607959L;
    @ApiModelProperty(position = 10, value = "服务支持ID[30]")
    private String ssid;
    @ApiModelProperty(position = 11, value = "服务支持名称[50]")
    private String name;
    @ApiModelProperty(position = 12, value = "服务支持描述[256]")
    private String desc;
    @ApiModelProperty(position = 13, value = "服务支持图片地址[256]")
    private String url;

    private static final GoblinGoodsServiceSupportVo obj = new GoblinGoodsServiceSupportVo();
    public static GoblinGoodsServiceSupportVo getNew() {
        try {
            return (GoblinGoodsServiceSupportVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinGoodsServiceSupportVo();
        }
    }
}
