create database if not exists ln_scene character set utf8mb4 collate utf8mb4_unicode_ci;
-- >>------------------------------------------------------------------------------------
use
    ln_scene;

-- 轮播图
drop TABLE if exists `kylin_banners`;
CREATE TABLE `kylin_banners`
(
    `mid`               int          NOT NULL AUTO_INCREMENT,
    `banners_id`        varchar(255) NOT NULL DEFAULT '' COMMENT 'banners_id',
    `banners_name`      varchar(255) NOT NULL DEFAULT '' COMMENT '标题',
    `cover_img`         varchar(255) NOT NULL DEFAULT '' COMMENT '封面图',
    `target_type`       smallint     NOT NULL DEFAULT 0 COMMENT '跳转类型(由接口提供)',
    `target_obj`        varchar(255) NOT NULL DEFAULT '' COMMENT '跳转目标 id/url等',
    `target_obj_name`   varchar(255) NOT NULL DEFAULT '' COMMENT '跳转目标 name 选择的时候回显使用',
    `is_online`         tinyint      NOT NULL DEFAULT 0 COMMENT '是否上线展示 0下线 1上线',
    `online_start_time` varchar(255) NOT NULL DEFAULT '' COMMENT '上线开始时间',
    `online_end_time`   varchar(255) NOT NULL DEFAULT '' COMMENT '上线结束时间',
    `promotion_type`    tinyint      NOT NULL DEFAULT 1 COMMENT '推广类型 1全国 2省份',
    `banners_sort`      int          NOT NULL DEFAULT 0 COMMENT '排序 越大越靠前',
    `is_deleted`        tinyint      NOT NULL DEFAULT 1 COMMENT '是否删除 0已删除 1正常',
    `created_at`        datetime(3)  NULL     DEFAULT NULL COMMENT '创建时间',
    `updated_at`        datetime(3)  NULL     DEFAULT NULL COMMENT '修改时间',
    KEY `kylin_banners_banners_id_index` (`banners_id`),
    KEY `kylin_banners_banners_name_index` (`banners_name`),
    KEY `kylin_banners_banners_sort_index` (`banners_sort`),
    PRIMARY KEY (`mid`)
) ENGINE = InnoDB
  DEFAULT CHARSET utf8mb4
  COLLATE utf8mb4_unicode_ci
    COMMENT '轮播图';

drop TABLE if exists `kylin_banners_relations`;
CREATE TABLE `kylin_banners_relations`
(
    `mid`                  int          NOT NULL AUTO_INCREMENT,
    `banners_relations_id` varchar(255) NOT NULL DEFAULT '' COMMENT 'banners_relations_id',
    `banners_id`           varchar(255) NOT NULL DEFAULT '' COMMENT 'banners_id',
    `field_id`             int          NOT NULL DEFAULT 0 COMMENT '展示位置id/推广省份code',
    `field_name`           varchar(255) NOT NULL DEFAULT '' COMMENT '省份名称',
    `field_id_type`        tinyint      NOT NULL DEFAULT 1 COMMENT '关联字段类型 1展示位置(由接口提供) 2推广省份(由接口提供)',
    `created_at`           datetime(3)  NULL     DEFAULT NULL COMMENT '创建时间',
    `updated_at`           datetime(3)  NULL     DEFAULT NULL COMMENT '修改时间',
    KEY `kylin_banners_relations_banners_relations_id_index` (`banners_relations_id`),
    KEY `kylin_banners_relations_banners_id_index` (`banners_id`),
    PRIMARY KEY (`mid`)
) ENGINE = InnoDB
  DEFAULT CHARSET utf8mb4
  COLLATE utf8mb4_unicode_ci COMMENT '轮播图 展示位置/推广省份 关联表';

-- 场地
drop TABLE if exists `kylin_fields`;
CREATE TABLE `kylin_fields`
(
    `mid`            int(11)      NOT NULL AUTO_INCREMENT,
    `fields_id`      varchar(255) NOT NULL DEFAULT '' COMMENT 'fields_id',
    `name`           varchar(255) NOT NULL DEFAULT '' COMMENT '场地名称',
    `name_eng`       varchar(255) NOT NULL DEFAULT '' COMMENT '英文名',
    `pinyin`         varchar(255) NOT NULL DEFAULT '' COMMENT '拼音',
    `cover_img`      varchar(255) NOT NULL DEFAULT '' COMMENT '封面图',
    `address`        varchar(255) NOT NULL DEFAULT '' COMMENT '详细地址',
    `longitude`      varchar(255) NOT NULL DEFAULT '' COMMENT '经度',
    `latitude`       varchar(255) NOT NULL DEFAULT '' COMMENT '维度',
    `phone`          varchar(255) NOT NULL DEFAULT '' COMMENT '联系电话',
    `description`    varchar(255) NOT NULL DEFAULT '' COMMENT '描述',
    `province_id`    int(255)     NOT NULL DEFAULT 0 COMMENT '省id',
    `province_name`  varchar(255) NOT NULL DEFAULT '' COMMENT '省名称',
    `city_id`        int(11)      NOT NULL DEFAULT 0 COMMENT '城市id',
    `city_name`      varchar(255) NOT NULL DEFAULT '' COMMENT '城市名称',
    `district_id`    int(11)      NOT NULL DEFAULT 0 COMMENT '县id',
    `district_name`  varchar(255) NOT NULL DEFAULT '' COMMENT '县名称',
    `refuse_message` varchar(255) NOT NULL DEFAULT '' COMMENT '拒绝理由',
    `comment`        varchar(255) NULL     DEFAULT '' COMMENT 'comment',
    `created_at`     datetime(3)  NULL     DEFAULT NULL COMMENT '创建时间',
    `updated_at`     datetime(3)  NULL     DEFAULT NULL COMMENT '修改时间',
    KEY `kylin_fields_uid_index` (`fields_id`),
    PRIMARY KEY (`mid`)
) ENGINE = InnoDB
  DEFAULT CHARSET utf8mb4
  COLLATE utf8mb4_unicode_ci COMMENT '场地数据';
-- 场地状态
drop TABLE if exists `kylin_field_status`;
CREATE TABLE `kylin_field_status`
(
    `mid`             int(11)      NOT NULL AUTO_INCREMENT,
    `field_status_id` varchar(255) NOT NULL DEFAULT '' COMMENT 'field_status_id',
    `field_id`        varchar(255) NOT NULL DEFAULT '' COMMENT '场地关联id',
    `valid_status`    tinyint      NOT NULL DEFAULT 0 COMMENT '认证状态 0未认证 1已认证 2被拒绝',
    `is_display`      tinyint      NOT NULL DEFAULT 1 COMMENT '是否显示 0不显示 1显示',
    `is_business`     tinyint      NOT NULL DEFAULT 0 COMMENT '是否营业 0不营业 1营业中',
    `change_status`   tinyint      NOT NULL DEFAULT 0 COMMENT '审核状态 0待审核 1已审核 2被拒绝',
    `created_at`      datetime(3)  NULL     DEFAULT NULL COMMENT '创建时间',
    `updated_at`      datetime(3)  NULL     DEFAULT NULL COMMENT '修改时间',
    KEY `kylin_field_status_uid_index` (`field_status_id`),
    PRIMARY KEY (`mid`)
) ENGINE = InnoDB
  DEFAULT CHARSET utf8mb4
  COLLATE utf8mb4_unicode_ci COMMENT '场地状态';
-- 场地关联关系关系
drop TABLE if exists `kylin_field_relations`;
CREATE TABLE `kylin_field_relations`
(
    `mid`                int(11)      NOT NULL AUTO_INCREMENT,
    `field_relations_id` varchar(255) NOT NULL DEFAULT '' COMMENT 'field_relations_id',
    `field_id`           varchar(255) NOT NULL DEFAULT '' COMMENT '场地关联id',
    `created_at`         datetime(3)  NULL     DEFAULT NULL COMMENT '创建时间',
    `updated_at`         datetime(3)  NULL     DEFAULT NULL COMMENT '修改时间',
    KEY `kylin_field_relations_uid_index` (`field_relations_id`),
    PRIMARY KEY (`mid`)
) ENGINE = InnoDB
  DEFAULT CHARSET utf8mb4
  COLLATE utf8mb4_unicode_ci COMMENT '场地关系';


-- 演出
drop TABLE if exists `kylin_performances`;
CREATE TABLE `kylin_performances`
(
    `mid`             int(11)      NOT NULL AUTO_INCREMENT,
    `performances_id` varchar(255) NOT NULL DEFAULT '' COMMENT 'performances_id',
    `title`           varchar(255) NOT NULL DEFAULT '' COMMENT '演出名称',
    `type`            tinyint      NOT NULL DEFAULT 3 COMMENT '1音乐节 2演唱会 3小型演出 4展览 6舞台剧 101音乐节 102小型演出(livehouse演出) 103巡演',
    `img_poster`      varchar(255) NOT NULL DEFAULT '' COMMENT '演出海报',
    `province_id`     varchar(255) NOT NULL DEFAULT '' COMMENT '省id',
    `province_name`   varchar(255) NOT NULL DEFAULT '' COMMENT '省名称',
    `city_id`         int(11)      NOT NULL DEFAULT 0 COMMENT '城市id',
    `city_name`       varchar(255) NOT NULL DEFAULT '' COMMENT '城市名称',
    `district_id`     int(11)      NOT NULL DEFAULT 0 COMMENT '县id',
    `district_name`   varchar(255) NOT NULL DEFAULT '' COMMENT '县名称',
    `approval_url`    varchar(255) NOT NULL DEFAULT '' COMMENT '批文地址',
    `notice`          varchar(255) NOT NULL DEFAULT '' COMMENT '演出公告',
    `sponsor_id`      varchar(255) NOT NULL DEFAULT '' COMMENT '主办方id',
    `sponsor_type`    varchar(255) NOT NULL DEFAULT 'Brand' COMMENT '主办方类型',
    `sponsor`         varchar(255) NOT NULL DEFAULT '' COMMENT '主办方',
    `contacts`        varchar(255) NOT NULL DEFAULT '' COMMENT '联系人',
    `mobile`          varchar(255) NOT NULL DEFAULT '' COMMENT '联系电话',
    `describes`       text         NULL     DEFAULT NULL COMMENT '演出简介',
    `details`         longtext              DEFAULT NULL COMMENT '演出详情',
    `notice_image`    text                  DEFAULT NULL COMMENT '购票须知',
    `time_start`      datetime     NOT NULL DEFAULT '2000-01-01 12:00:00' COMMENT '演出开始时间',
    `time_end`        datetime     NOT NULL DEFAULT '2000-01-01 12:00:00' COMMENT '演出结束时间',
    `audit_time`      datetime     NOT NULL DEFAULT '2000-01-01 12:00:00' COMMENT '提审时间',
    `reject_txt`      varchar(255) NOT NULL DEFAULT '' COMMENT '拒绝理由',
    `sort`            int(11)      NOT NULL DEFAULT 0 COMMENT '权重 高则在上',
    `comment`         varchar(255) NULL     DEFAULT '' COMMENT 'comment',
    `created_at`      datetime(3)  NULL     DEFAULT NULL COMMENT '创建时间',
    `updated_at`      datetime(3)  NULL     DEFAULT NULL COMMENT '修改时间',
    KEY `kylin_performances_uid_index` (`performances_id`),
    PRIMARY KEY (`mid`)
) ENGINE = InnoDB
  DEFAULT CHARSET utf8mb4
  COLLATE utf8mb4_unicode_ci COMMENT '演出';
-- 演出状态
drop TABLE if exists `kylin_performance_status`;
CREATE TABLE `kylin_performance_status`
(
    `mid`                    int(11)      NOT NULL AUTO_INCREMENT,
    `performance_status_id`  varchar(255) NOT NULL DEFAULT '' COMMENT 'performance_status_id',
    `performance_id`         varchar(255) NOT NULL DEFAULT '' COMMENT '演出关联id',
    `is_show`                tinyint      NOT NULL DEFAULT 1 COMMENT '是否显示 0全部用户可见 1白名单可见 2任何不显示',
    `status`                 int          NOT NULL DEFAULT 0 COMMENT '状态:-1删除;0未提交;1审核中;2审核中（自动上线）;3审核通过;4审核未通过;6上线;7下架;8活动售罄;9活动未开始;10活动结束',
    `status_sell`            tinyint      NOT NULL DEFAULT 1 COMMENT '是否售卖 0停止 1正常',
    `is_distribution`        tinyint      NOT NULL DEFAULT 0 COMMENT '是否开启分销 0关闭 1开启',
    `sync_agent`             tinyint      NOT NULL DEFAULT 0 COMMENT '是否关联小程序 0不关联 1关联',
    `sync_damai`             tinyint      NOT NULL DEFAULT 0 COMMENT '是否同步大麦 0不关联 1关联',
    `audit_status`           tinyint      NOT NULL DEFAULT -1 COMMENT '-1未提交审核，0提交审核，1审核通过，2审核拒绝',
    `is_true_name`           tinyint      NOT NULL DEFAULT 0 COMMENT '是否实名 0不需要 1需要',
    `limit_count`            int(11)      NOT NULL DEFAULT 0 COMMENT '限购张数 0无限 (开启实名 则实名限购 未开始为账号限购)',
    `limit_count_member`     int(11)      NOT NULL DEFAULT 0 COMMENT '会员限购张数 0无限 (开启实名 则实名限购 未开始为账号限购)',
    `is_recommend`           tinyint(255) NOT NULL DEFAULT 0 COMMENT '是否推荐 0否 1是',

    `is_can_refund`          tinyint      NOT NULL DEFAULT 0 COMMENT '是否支持退款 0否 1是',
    `is_open_refund_present` tinyint      NOT NULL DEFAULT 0 COMMENT '是否开启退款比例 0否 1是',
    `refund_open_time`       datetime(3)  NULL     DEFAULT NULL COMMENT '退款开始时间',
    `refund_close_time`      datetime(3)  NULL     DEFAULT NULL COMMENT '退款结束时间',

    `created_at`             datetime(3)  NULL     DEFAULT NULL COMMENT '创建时间',
    `updated_at`             datetime(3)  NULL     DEFAULT NULL COMMENT '修改时间',
    KEY `kylin_performance_status_uid_index` (`performance_status_id`),
    KEY `kylin_performances_status_status_index` (`status`),
    KEY `kylin_performances_status_audit_status_index` (`audit_status`),
    KEY `kylin_performances_status_is_true_name_index` (`is_true_name`),
    KEY `kylin_performances_status_performance_id_index` (`performance_id`),
    PRIMARY KEY (`mid`)
) ENGINE = InnoDB
  DEFAULT CHARSET utf8mb4
  COLLATE utf8mb4_unicode_ci COMMENT '演出状态';
-- 演出关联关系
drop TABLE if exists `kylin_performance_relations`;
CREATE TABLE `kylin_performance_relations`
(
    `mid`                      int(11)      NOT NULL AUTO_INCREMENT,
    `performance_relations_id` varchar(255) NOT NULL DEFAULT '' COMMENT 'performance_relations_id',
    `performance_id`           varchar(255) NOT NULL DEFAULT '' COMMENT '演出关联id',
    `copy_id`                  varchar(255) NOT NULL DEFAULT '' COMMENT '复制来源演出id',
    `merchant_id`              varchar(255) NOT NULL DEFAULT '' COMMENT '商户id',
    `field_id`                 varchar(255) NOT NULL DEFAULT '' COMMENT '场地id',
    `road_show_id`             varchar(255) NOT NULL DEFAULT '' COMMENT '巡演id',
    `project_id`               varchar(255) NOT NULL DEFAULT '' COMMENT '专题id',
    `video_id`                 varchar(255) NOT NULL DEFAULT '' COMMENT '视频id',
    `created_at`               datetime(3)  NULL     DEFAULT NULL COMMENT '创建时间',
    `updated_at`               datetime(3)  NULL     DEFAULT NULL COMMENT '修改时间',
    KEY `performance_relations_uid_index` (`performance_relations_id`),
    KEY `performance_relations_copy_id_index` (`copy_id`),
    KEY `performance_relations_performance_id_index` (`performance_id`),
    PRIMARY KEY (`mid`)
) ENGINE = InnoDB
  DEFAULT CHARSET utf8mb4
  COLLATE utf8mb4_unicode_ci COMMENT '演出状态';
# -- 演出退款比例表
# drop TABLE if exists `kylin_performance_refund_present`;
# CREATE TABLE `kylin_performance_refund_present`
# (
#     `mid`                      int(11)      NOT NULL AUTO_INCREMENT,
#     `performance_present_id` varchar(255) NOT NULL DEFAULT '' COMMENT 'performance_present_id',
#     `performance_id`           varchar(255) NOT NULL DEFAULT '' COMMENT '演出关联id',
#     `present`                  varchar(255) NOT NULL DEFAULT '' COMMENT '百分比',
#     `days`              varchar(255) NOT NULL DEFAULT '' COMMENT '天数',
#     `created_at`               datetime(3)  NULL     DEFAULT NULL COMMENT '创建时间',
#     `updated_at`               datetime(3)  NULL     DEFAULT NULL COMMENT '修改时间',
#     KEY `kylin_performance_refund_present_uid_index` (`performance_present_id`),
#     KEY `kylin_performance_refund_present_performance_id_index` (`performance_id`),
#     PRIMARY KEY (`mid`)
# ) ENGINE = InnoDB
#   DEFAULT CHARSET = utf8mb4 COMMENT '演出退款比例';

-- 演出分销数据 票逻辑
drop TABLE if exists `kylin_performance_distributions`;
CREATE TABLE `kylin_performance_distributions`
(
    `mid`                          int(11)      NOT NULL AUTO_INCREMENT,
    `performance_distributions_id` varchar(255) NOT NULL DEFAULT '' COMMENT 'performance_distributions_id',
    `ticket_id`                    varchar(255) NOT NULL DEFAULT '' COMMENT '票关联id',
    `ticket_scale`                 varchar(5)   NOT NULL DEFAULT '0' COMMENT '演出票提单位%',
    `limit_barter`                 varchar(5)   NOT NULL DEFAULT '0' COMMENT '1级现金奖励占比',
    `first_agent_scale_money`      varchar(5)   NOT NULL DEFAULT '0' COMMENT '1级现金奖励占比',
    `first_agent_scale_barter`     varchar(5)   NOT NULL DEFAULT '0' COMMENT '2级积分奖励占比',
    `second_agent_scale_money`     varchar(5)   NOT NULL DEFAULT '0' COMMENT '1级现金奖励占比',
    `second_agent_scale_barter`    varchar(5)   NOT NULL DEFAULT '0' COMMENT '2级积分奖励占比',
    `comment`                      varchar(255) NULL     DEFAULT '' COMMENT 'comment',
    `created_at`                   datetime(3)  NULL     DEFAULT NULL COMMENT '创建时间',
    `updated_at`                   datetime(3)  NULL     DEFAULT NULL COMMENT '修改时间',
    KEY `kylin_performance_distributions_uid_index` (`performance_distributions_id`),
    PRIMARY KEY (`mid`)
) ENGINE = InnoDB
  DEFAULT CHARSET utf8mb4
  COLLATE utf8mb4_unicode_ci COMMENT '演出状态';


-- 场次
drop TABLE if exists `kylin_ticket_times`;
CREATE TABLE `kylin_ticket_times`
(
    `mid`             int(11)      NOT NULL AUTO_INCREMENT,
    `ticket_times_id` varchar(255) NOT NULL DEFAULT '' COMMENT 'ticket_times_id',
    `title`           varchar(255) NOT NULL DEFAULT '' COMMENT '标题',
    `type`            tinyint      NOT NULL DEFAULT 1 COMMENT '状态 1单日票 2通票',
    `status`          tinyint      NOT NULL DEFAULT 1 COMMENT '状态 0不可用 1可用',
    `use_start`       datetime     NOT NULL DEFAULT '2000-01-01 12:00:00' COMMENT '售票开始时间',
    `use_end`         datetime              DEFAULT NULL COMMENT '售票结束时间',
    `comment`         varchar(255) NULL     DEFAULT '' COMMENT 'comment',
    `created_at`      datetime(3)  NULL     DEFAULT NULL COMMENT '创建时间',
    `updated_at`      datetime(3)  NULL     DEFAULT NULL COMMENT '修改时间',
    KEY `kylin_ticket_times_uid_index` (`ticket_times_id`),
    PRIMARY KEY (`mid`)
) ENGINE = InnoDB
  DEFAULT CHARSET utf8mb4
  COLLATE utf8mb4_unicode_ci COMMENT '场次';

-- 场次关联
drop TABLE if exists `kylin_ticket_time_relation`;
CREATE TABLE `kylin_ticket_time_relation`
(
    `mid`                     int(11)      NOT NULL AUTO_INCREMENT,
    `ticket_time_relation_id` varchar(255) NOT NULL DEFAULT '' COMMENT 'ticket_time_relation_id',
    `times_id`                varchar(255) NOT NULL DEFAULT '' COMMENT '场次id',
    `performance_id`          varchar(255) NOT NULL DEFAULT '' COMMENT '关联演出id',
    `created_at`              datetime(3)  NULL     DEFAULT NULL COMMENT '创建时间',
    `updated_at`              datetime(3)  NULL     DEFAULT NULL COMMENT '修改时间',
    KEY `kylin_ticket_time_relation_uid_index` (`ticket_time_relation_id`),
    KEY `kylin_ticket_time_relation_times_id_index` (`times_id`),
    KEY `kylin_ticket_time_relation_performance_id_index` (`performance_id`),
    PRIMARY KEY (`mid`)
) ENGINE = InnoDB
  DEFAULT CHARSET utf8mb4
  COLLATE utf8mb4_unicode_ci COMMENT '场次关联';

-- 票
drop TABLE if exists `kylin_tickets`;
CREATE TABLE `kylin_tickets`
(
    `mid`                   int(11)       NOT NULL AUTO_INCREMENT,
    `tickets_id`            varchar(255)  NOT NULL DEFAULT '' COMMENT 'tickets_id',
    `title`                 varchar(255)  NOT NULL DEFAULT '' COMMENT '票名称',
    `type`                  tinyint       NOT NULL DEFAULT 1 COMMENT '票类型 1单日票 2通票',
    `price`                 decimal(8, 2) NOT NULL DEFAULT '0.00' COMMENT '票单价',
    `price_express`         decimal(8, 2) NOT NULL DEFAULT '0.00' COMMENT '快递费',
    `price_discount_member` decimal(8, 2) NOT NULL DEFAULT '0.00' COMMENT '会员优惠价格',
    `price_discount`        decimal(8, 2) NOT NULL DEFAULT '0.00' COMMENT '优惠价格',
    `describes`             varchar(500)  NOT NULL DEFAULT '' COMMENT '票种描述',
    `describe_express`      varchar(500)  NOT NULL DEFAULT '' COMMENT '快递票类型说明',
    `describe_electronic`   varchar(500)  NOT NULL DEFAULT '' COMMENT '电子票票类型说明',
    `advance_minute_member` int(11)       NOT NULL DEFAULT 5 COMMENT '会员提前购买分钟数',
    `time_start`            datetime      NOT NULL DEFAULT '2030-01-01 12:00:00' COMMENT '售卖开始时间',
    `time_end`              datetime      NOT NULL DEFAULT '2030-01-01 12:00:00' COMMENT '售卖结束时间',
    `time_end_express`      datetime      NOT NULL DEFAULT '2030-01-01 12:00:00' COMMENT '快递票结束时间',
    `use_start`             datetime      NOT NULL DEFAULT '2030-01-01 12:00:00' COMMENT '适用开始时间',
    `use_end`               datetime               DEFAULT NULL COMMENT '适用结束时间',
    `pay_countdown_minute`  int(11)       NOT NULL DEFAULT 5 COMMENT '支付倒计时时间',
    `sale_remind_minute`    int(11)       NOT NULL DEFAULT 60 COMMENT '开票提醒倒计时（分钟数）',
    `comment`               varchar(255)  NULL     DEFAULT '' COMMENT 'comment',
    `created_at`            datetime(3)   NULL     DEFAULT NULL COMMENT '创建时间',
    `updated_at`            datetime(3)   NULL     DEFAULT NULL COMMENT '修改时间',
    KEY `kylin_tickets_uid_index` (`tickets_id`),
    PRIMARY KEY (`mid`)
) ENGINE = InnoDB
  DEFAULT CHARSET utf8mb4
  COLLATE utf8mb4_unicode_ci COMMENT '票';
-- 票状态
drop TABLE if exists `kylin_ticket_status`;
CREATE TABLE `kylin_ticket_status`
(
    `mid`                int(11)      NOT NULL AUTO_INCREMENT,
    `ticket_status_id`   varchar(255) NOT NULL DEFAULT '' COMMENT 'ticket_status_id',
    `ticket_id`          varchar(255) NOT NULL DEFAULT '' COMMENT '票关联id',
    `is_student`         tinyint      NOT NULL DEFAULT 0 COMMENT '是否学生票 0否 1是',
    `is_electronic`      tinyint      NOT NULL DEFAULT 0 COMMENT '是否电子票 0否 1是',
    `is_express`         tinyint      NOT NULL DEFAULT 0 COMMENT '是否快递票 0否 1是',
    `status`             tinyint      NOT NULL DEFAULT 0 COMMENT '票状态 -2新建 -1删除;0未提交;1审核中;2审核中（自动在售）;3审核通过;4审核未通过;6在售;7停售;8售罄;9未开始;10已结束',
    `counts`             int(11)      NOT NULL DEFAULT 1 COMMENT '可验证次数',
    `status_exchange`    tinyint      NOT NULL DEFAULT 0 COMMENT '兑换状态 6可兑换 7不可兑换',
    `is_show_code`       tinyint      NOT NULL DEFAULT 0 COMMENT '是否显示二维码 0否 1是',
    `qr_code_show_time`  datetime     NOT NULL DEFAULT '2030-01-01 12:00:00' COMMENT '二维码显示时间',
    `is_lack_register`   tinyint      NOT NULL DEFAULT 0 COMMENT '是否开启缺票登记 0否 1是',
    `total_general`      int(11)      NOT NULL DEFAULT 0 COMMENT '总库存',
    `total_exchange`     int(11)      NOT NULL DEFAULT 0 COMMENT '总兑换库存',
    `surplus_general`    int(11)      NOT NULL DEFAULT 0 COMMENT '剩余库存',
    `surplus_exchange`   int(11)      NOT NULL DEFAULT 0 COMMENT '剩余兑换库存',
    `express_type`       tinyint      NOT NULL DEFAULT 1 COMMENT '1寄付 2到付',
    `is_true_name`       tinyint      NOT NULL DEFAULT 0 COMMENT '是否实名 0不需要 1需要',
    `limit_count`        int(11)      NOT NULL DEFAULT 0 COMMENT '限购张数 0无限 (开启实名 则实名限购 未开始为账号限购)',
    `member_limit_count` int(11)      NOT NULL DEFAULT 0 COMMENT '会员限购张数 0无限 (开启实名 则实名限购 未开始为账号限购)',
    `is_transfer`        tinyint      NOT NULL DEFAULT 0 COMMENT '是否开启转赠 0关闭 1开启',
    `is_exclusive`       tinyint      NOT NULL DEFAULT 0 COMMENT '是否会员专属 0不是 1是',
    `is_member`          tinyint      NOT NULL DEFAULT 0 COMMENT '是否关联会员 0不是 1是',
    `is_agent`           tinyint      NOT NULL DEFAULT 0 COMMENT '是否关联代理 0不是 1是',
    `sync_damai`         tinyint      NOT NULL DEFAULT 0 COMMENT '是否同步大麦 0不关联 1关联',
    `created_at`         datetime(3)  NULL     DEFAULT NULL COMMENT '创建时间',
    `updated_at`         datetime(3)  NULL     DEFAULT NULL COMMENT '修改时间',
    KEY `kylin_ticket_status_uid_index` (`ticket_status_id`),
    KEY `kylin_ticket_status_status_index` (`status`),
    KEY `kylin_ticket_status_is_member_index` (`is_member`),
    KEY `kylin_ticket_status_is_agent_index` (`is_agent`),
    KEY `kylin_ticket_status_is_exclusive_index` (`is_exclusive`),
    KEY `kylin_ticket_status_is_true_name_index` (`is_true_name`),
    PRIMARY KEY (`mid`)
) ENGINE = InnoDB
  DEFAULT CHARSET utf8mb4
  COLLATE utf8mb4_unicode_ci COMMENT '票';
-- 票关系
drop TABLE if exists `kylin_ticket_relations`;
CREATE TABLE `kylin_ticket_relations`
(
    `mid`                 int(11)      NOT NULL AUTO_INCREMENT,
    `ticket_relations_id` varchar(255) NOT NULL DEFAULT '' COMMENT 'ticket_relations_id',
    `ticket_id`           varchar(255) NOT NULL DEFAULT '' COMMENT '票关联id',
    `times_id`            varchar(255) NOT NULL DEFAULT '' COMMENT '关联场次id',
    `created_at`          datetime(3)  NULL     DEFAULT NULL COMMENT '创建时间',
    `updated_at`          datetime(3)  NULL     DEFAULT NULL COMMENT '修改时间',
    KEY `ticket_relations_uid_index` (`ticket_relations_id`),
    KEY `ticket_relations_ticket_id_index` (`ticket_id`),
    KEY `ticket_relations_times_id_index` (`times_id`),
    PRIMARY KEY (`mid`)
) ENGINE = InnoDB
  DEFAULT CHARSET utf8mb4
  COLLATE utf8mb4_unicode_ci COMMENT '票';

-- 巡演
drop TABLE if exists `kylin_road_shows`;
CREATE TABLE `kylin_road_shows`
(
    `mid`           int(11)      NOT NULL AUTO_INCREMENT,
    `road_shows_id` varchar(255) NOT NULL DEFAULT '' COMMENT 'road_shows_id',
    `title`         varchar(255) NOT NULL DEFAULT '' COMMENT '封面图',
    `img_poster`    varchar(255) NOT NULL DEFAULT '' COMMENT '巡演封面图',
    `status`        tinyint      NOT NULL DEFAULT 1 COMMENT '状态 0停用 1启用',
    `comment`       varchar(255) NULL     DEFAULT '' COMMENT 'comment',
    `created_at`    datetime(3)  NULL     DEFAULT NULL COMMENT '创建时间',
    `updated_at`    datetime(3)  NULL     DEFAULT NULL COMMENT '修改时间',
    KEY `kylin_road_shows_uid_index` (`road_shows_id`),
    KEY `ticket_relations_times_status_index` (`status`),
    PRIMARY KEY (`mid`)
) ENGINE = InnoDB
  DEFAULT CHARSET utf8mb4
  COLLATE utf8mb4_unicode_ci COMMENT '巡演';


-- 缺票登记 记录
drop TABLE if exists `kylin_lack_registers`;
CREATE TABLE `kylin_lack_registers`
(
    `mid`               int(11)      NOT NULL AUTO_INCREMENT,
    `lack_registers_id` varchar(255) NOT NULL DEFAULT '' COMMENT 'lack_registers_id',
    `performance_id`    varchar(255) NOT NULL DEFAULT '' COMMENT '票种id',
    `ticket_id`         varchar(255) NOT NULL DEFAULT '' COMMENT '票种id',
    `user_id`           varchar(255) NOT NULL DEFAULT '' COMMENT '用户id',
    `user_name`         varchar(255) NOT NULL DEFAULT '' COMMENT '用户昵称',
    `user_mobile`       varchar(255) NOT NULL DEFAULT '' COMMENT '用户手机号',
    `send_status`       tinyint      NOT NULL DEFAULT 0 COMMENT '是否发送短信',
    `ip_address`        varchar(255) NOT NULL DEFAULT '' COMMENT 'IP 地址',
    `created_at`        datetime(3)  NULL     DEFAULT NULL COMMENT '创建时间',
    `updated_at`        datetime(3)  NULL     DEFAULT NULL COMMENT '修改时间',
    KEY `kylin_lack_registers_uid_index` (`lack_registers_id`),
    KEY `kylin_lack_registers_performance_id_index` (`performance_id`),
    KEY `kylin_lack_registers_ticket_id_index` (`ticket_id`),
    KEY `kylin_lack_registers_user_id_index` (`user_id`),
    PRIMARY KEY (`mid`)
) ENGINE = InnoDB
  DEFAULT CHARSET utf8mb4
  COLLATE utf8mb4_unicode_ci COMMENT '缺票登记';

-- 专题 <搭售>
drop TABLE if exists `kylin_projects`;
CREATE TABLE `kylin_projects`
(
    `mid`              int(10) unsigned                     NOT NULL AUTO_INCREMENT,
    `projects_id`      varchar(255)                         NOT NULL DEFAULT '' COMMENT 'projects_id',
    `title`            varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '专题名称',
    `time_limit`       int(11)                                       DEFAULT NULL COMMENT '限购时间 单位分钟',
    `status`           tinyint(4)                           NOT NULL DEFAULT '0' COMMENT '0下线 1上线',
    `open_performance` tinyint(4)                           NOT NULL DEFAULT '0' COMMENT '是否开启 推荐演出',
    `open_goods`       tinyint(4)                           NOT NULL DEFAULT '0' COMMENT '是否开启 推荐商品',
    `open_tied`        tinyint(4)                           NOT NULL DEFAULT '0' COMMENT '是否开启 推荐搭售',
    `comment`          varchar(255)                         NULL     DEFAULT '' COMMENT 'comment',
    `created_at`       datetime(3)                          NULL     DEFAULT NULL,
    `updated_at`       datetime(3)                          NULL     DEFAULT NULL,
    KEY `kylin_projects_uid_index` (`projects_id`),
    PRIMARY KEY (`mid`)
) ENGINE = InnoDB
  DEFAULT CHARSET utf8mb4
  COLLATE utf8mb4_unicode_ci COMMENT '专题';
-- 专题关系
drop TABLE if exists `kylin_project_relations`;
CREATE TABLE `kylin_project_relations`
(
    `mid`                  int(10) unsigned                     NOT NULL AUTO_INCREMENT,
    `project_relations_id` varchar(255)                         NOT NULL DEFAULT '' COMMENT 'project_relations_id',
    `project_id`           int(11)                              NOT NULL DEFAULT '0' COMMENT '专题id',
    `type`                 int(11)                              NOT NULL DEFAULT '0' COMMENT '关联类型 1演出 2商品 3限时商品',
    `target_name`          varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '关联名称 关联',
    `target_id`            int(11)                              NOT NULL DEFAULT '0' COMMENT '关联id',
    `item_id`              int(11)                              NOT NULL DEFAULT '0' COMMENT '搭售款式id',
    `item_name`            varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '搭售款式名称',
    `tied_price`           decimal(8, 2)                        NOT NULL DEFAULT '0.00' COMMENT '搭售价格',
    `is_limit`             tinyint(4)                           NOT NULL DEFAULT '0' COMMENT '是否限购',
    `limit_num`            int(11)                              NOT NULL DEFAULT '0' COMMENT '限购数量 0不限购',
    `created_at`           datetime(3)                          NULL     DEFAULT NULL,
    `updated_at`           datetime(3)                          NULL     DEFAULT NULL,
    PRIMARY KEY (`mid`),
    KEY `kylin_project_relations_uid_index` (`project_relations_id`),
    KEY `kylin_project_relations_project_id_index` (`project_id`),
    KEY `kylin_project_relations_target_id_index` (`target_id`),
    KEY `kylin_project_relations_item_id_index` (`item_id`)
) ENGINE = InnoDB
  DEFAULT CHARSET utf8mb4
  COLLATE utf8mb4_unicode_ci COMMENT '专题关系';


-- 订单
drop TABLE if exists `kylin_order_tickets`;
CREATE TABLE `kylin_order_tickets`
(
    `mid`                  int(10) unsigned NOT NULL AUTO_INCREMENT,
    `order_tickets_id`     varchar(255)     NOT NULL DEFAULT '' COMMENT 'order_tickets_id',
    `user_id`              varchar(255)     NOT NULL DEFAULT '' COMMENT '用户id',
    `user_name`            varchar(255)     NOT NULL DEFAULT '' COMMENT '用户昵称',
    `user_mobile`          varchar(255)     NOT NULL DEFAULT '' COMMENT '用户手机号',
    `performance_title`    varchar(255)     NOT NULL DEFAULT '' COMMENT '演出名称',
    `order_code`           varchar(255)     NOT NULL DEFAULT '' COMMENT '订单号',
    `pay_code`             varchar(255)     NOT NULL DEFAULT '' COMMENT '支付单号',
    `qr_code`              varchar(255)     NOT NULL DEFAULT '' COMMENT '二维码地址',
    `order_type`           varchar(255)     NOT NULL DEFAULT '' COMMENT '下单方式',
    `order_source`         varchar(255)     NOT NULL DEFAULT '' COMMENT '下单来源',
    `order_version`        varchar(255)     NOT NULL DEFAULT '' COMMENT '下单版本',
    `number`               int(32)          NOT NULL DEFAULT 0 COMMENT '数量',
    `price`                decimal(8, 2)    NOT NULL DEFAULT '0.00' COMMENT '单价',
    `price_member`         decimal(8, 2)    NOT NULL DEFAULT '0.00' COMMENT '会员单价',
    `price_total`          decimal(8, 2)    NOT NULL DEFAULT '0.00' COMMENT '应付价格',
    `price_voucher`        decimal(8, 2)    NOT NULL DEFAULT '0.00' COMMENT '优惠价格',
    `price_actual`         decimal(8, 2)    NOT NULL DEFAULT '0.00' COMMENT '实付价格',
    `price_express`        decimal(8, 2)    NOT NULL DEFAULT '0.00' COMMENT '快递价格',
    `price_refund`         decimal(8, 2)    NOT NULL DEFAULT '0.00' COMMENT '退款价格',
    `refund_number`        int(32)          NOT NULL DEFAULT 0 COMMENT '退款张数',
    `pay_type`             varchar(255)     NOT NULL DEFAULT '' COMMENT '选择支付方式',
    `payment_type`         varchar(255)     NULL     DEFAULT '' COMMENT '实际支付方式',
    `payment_id`           varchar(255)     NULL     DEFAULT '' COMMENT '支付的订单号',
    `time_pay`             varchar(255)     NULL     DEFAULT '' COMMENT '支付时间',
    `express_contacts`     varchar(255)     NOT NULL DEFAULT '' COMMENT '收货人',
    `express_address`      varchar(255)     NOT NULL DEFAULT '' COMMENT '收货地址',
    `province`             varchar(60)      NOT NULL DEFAULT '' COMMENT '省份',
    `city`                 varchar(60)      NOT NULL DEFAULT '' COMMENT '城市',
    `county`               varchar(60)      NOT NULL DEFAULT '' COMMENT '区县',
    `express_phone`        varchar(255)     NOT NULL DEFAULT '' COMMENT '收货人联系方式',
    `coupon_type`          varchar(255)     NOT NULL DEFAULT '' COMMENT '券使用类别',
    `get_ticket_type`      varchar(255)     NOT NULL DEFAULT '' COMMENT '取票方式 电子票electronic快递票express',
    `get_ticket_describe`  varchar(255)     NOT NULL DEFAULT '' COMMENT '直播用取票观演码，隔开',
    `pay_countdown_minute` int(32)          NOT NULL DEFAULT 15 COMMENT '订单过期时间(分钟)',
    `comment`              varchar(255)     NULL     DEFAULT '' COMMENT 'comment',
    `created_at`           datetime(3)      NULL     DEFAULT NULL COMMENT '创建时间',
    `updated_at`           datetime(3)      NULL     DEFAULT NULL COMMENT '修改时间',
    KEY `kylin_order_tickets_uid_index` (`order_tickets_id`),
    KEY `kylin_order_tickets_user_id_index` (`user_id`),
    KEY `kylin_order_tickets_order_code_index` (`order_code`),
    KEY `kylin_order_tickets_order_type_index` (`order_type`),
    PRIMARY KEY (`mid`)
) ENGINE = InnoDB
  DEFAULT CHARSET utf8mb4
  COLLATE utf8mb4_unicode_ci COMMENT '订单';

alter table kylin_order_tickets add refund_price_charges decimal(10, 2) NOT NULL DEFAULT '0.00' COMMENT '退款扣除的手续费金额' after price_refund;

-- 订单关系
drop TABLE if exists `kylin_order_ticket_relations`;
CREATE TABLE `kylin_order_ticket_relations`
(
    `mid`                       int(10) unsigned NOT NULL AUTO_INCREMENT,
    `order_ticket_relations_id` varchar(255)     NOT NULL DEFAULT '' COMMENT 'order_ticket_relations_id',
    `order_id`                  varchar(255)     NOT NULL DEFAULT '' COMMENT '订单id',
    `transfer_id`               varchar(255)     NOT NULL DEFAULT '' COMMENT '转增订单id',
    `live_id`                   varchar(255)     NOT NULL DEFAULT '' COMMENT '关联直播id',
    `performance_id`            varchar(255)     NOT NULL DEFAULT '' COMMENT '演出id',
    `time_id`                   varchar(255)     NOT NULL DEFAULT '' COMMENT '场次id',
    `ticket_id`                 varchar(255)     NOT NULL DEFAULT '' COMMENT '票id',
    `agent_id`                  varchar(255)     NOT NULL DEFAULT '' COMMENT '分销代理id',
    `is_member`                 int              NOT NULL DEFAULT 0 COMMENT '购买者是否是会员',
    `created_at`                datetime(3)      NULL     DEFAULT NULL COMMENT '创建时间',
    `updated_at`                datetime(3)      NULL     DEFAULT NULL COMMENT '修改时间',
    KEY `kylin_order_ticket_relations_uid_index` (`order_ticket_relations_id`),
    KEY `kylin_order_ticket_relations_order_id_index` (`order_id`),
    KEY `kylin_order_ticket_relations_performance_id_index` (`performance_id`),
    KEY `kylin_order_ticket_relations_time_id_index` (`time_id`),
    KEY `kylin_order_ticket_relations_ticket_id_index` (`ticket_id`),
    KEY `kylin_order_ticket_relations_agent_id_index` (`agent_id`),
    KEY `kylin_order_ticket_relations_is_member_index` (`is_member`),
    PRIMARY KEY (`mid`)
) ENGINE = InnoDB
  DEFAULT CHARSET utf8mb4
  COLLATE utf8mb4_unicode_ci COMMENT '订单关系';
-- 订单状态
drop TABLE if exists `kylin_order_ticket_status`;
CREATE TABLE `kylin_order_ticket_status`
(
    `mid`                    int(10) unsigned NOT NULL AUTO_INCREMENT,
    `order_ticket_status_id` varchar(255)     NOT NULL DEFAULT '' COMMENT 'order_ticket_status_id',
    `order_id`               varchar(255)     NOT NULL DEFAULT '' COMMENT '订单id',
    `express_type`           tinyint          NOT NULL DEFAULT 1 COMMENT '快递方式 1寄付 2到付',
    `is_student`             tinyint          NOT NULL DEFAULT 0 COMMENT '是否学生票 1是 2否',
    `transfer_status`        tinyint          NOT NULL DEFAULT 0 COMMENT '转移状态，0未转移，1收到他人转赠，2已转赠给他人',
    `status`                 tinyint          NOT NULL DEFAULT 0 COMMENT '订单状态:0待付款，1已付款，2已关闭，3正在退款，4已退款, 5待关闭 6部分退款',
    `pay_status`             tinyint          NOT NULL DEFAULT 0 COMMENT '支付状态:0未支付 1已支付 2支付失败',
    `created_at`             datetime(3)      NULL     DEFAULT NULL COMMENT '创建时间',
    `updated_at`             datetime(3)      NULL     DEFAULT NULL COMMENT '修改时间',
    KEY `kylin_order_ticket_status_uid_index` (`order_ticket_status_id`),
    KEY `kylin_order_ticket_status_order_id_index` (`order_id`),
    KEY `kylin_order_ticket_status_status_index` (`status`),
    KEY `kylin_order_ticket_status_pay_status_index` (`pay_status`),
    PRIMARY KEY (`mid`)
) ENGINE = InnoDB
  DEFAULT CHARSET utf8mb4
  COLLATE utf8mb4_unicode_ci COMMENT '订单状态';


-- 订单详情
drop TABLE if exists `kylin_order_ticket_entities`;
CREATE TABLE `kylin_order_ticket_entities`
(
    `mid`                      int(10) unsigned NOT NULL AUTO_INCREMENT,
    `order_ticket_entities_id` varchar(255)     NOT NULL DEFAULT '' COMMENT 'order_ticket_entities_id',
    `order_id`                 varchar(255)     NOT NULL DEFAULT '' COMMENT '订单详情关联id',
    `ticket_id`                varchar(255)     NOT NULL DEFAULT '' COMMENT '票务id',
    `user_id`                  varchar(255)     NOT NULL DEFAULT '' COMMENT '用户id',
    `performance_id`           varchar(255)     NOT NULL DEFAULT '' COMMENT '演出id',
    `time_id`                  varchar(255)     NOT NULL DEFAULT '' COMMENT '场次id',
    `enter_type`               int(11)          NOT NULL DEFAULT 1 COMMENT '入场人证件类型 1大陆身份证 2港澳通行证 3台胞证 4护照 5军官证',
    `enter_name`               varchar(255)     NOT NULL DEFAULT '' COMMENT '入场人姓名',
    `enter_mobile`             varchar(255)     NOT NULL DEFAULT '' COMMENT '入场人联系电话',
    `enter_id_code`            varchar(255)     NOT NULL DEFAULT '' COMMENT '入场人证件号',
    `status`                   int(11)          NOT NULL DEFAULT 0 COMMENT '出票状态: 0未出票 1已出票',
    `sys_damai`                int(11)          NOT NULL DEFAULT 0 COMMENT '大麦同步状态: 0不同步 1待同步 2同步完成 3同步失败',
    `check_client`             varchar(255)     NOT NULL DEFAULT '' COMMENT '出票端 例如 pda 验票app android/ios 大麦出票',
    `is_payment`               int(11)          NOT NULL DEFAULT 0 COMMENT '支付状态: 0未支付 1已支付 2退款中 3已退款 4部分退款',
    `refund_price`             decimal(8, 2)    NOT NULL DEFAULT '0.00' COMMENT '已退款金额',
    `comment`                  varchar(255)     NULL     DEFAULT '' COMMENT 'comment',
    `created_at`               datetime(3)      NULL     DEFAULT NULL COMMENT '创建时间',
    `updated_at`               datetime(3)      NULL     DEFAULT NULL COMMENT '修改时间',
    KEY `kylin_order_ticket_entities_uid_index` (`order_ticket_entities_id`),
    KEY `kylin_order_ticket_entities_order_id_index` (`order_id`),
    KEY `kylin_order_ticket_entities_ticket_id_index` (`ticket_id`),
    KEY `kylin_order_ticket_entities_user_id_index` (`user_id`),
    KEY `kylin_order_ticket_entities_time_id_index` (`time_id`),
    PRIMARY KEY (`mid`)
) ENGINE = InnoDB
  DEFAULT CHARSET utf8mb4
  COLLATE utf8mb4_unicode_ci COMMENT '订单详情';

-- 购票须知表
drop TABLE if exists `kylin_buy_notice`;
CREATE TABLE `kylin_buy_notice`
(
    `mid`           int(10) unsigned NOT NULL AUTO_INCREMENT,
    `buy_notice_id` varchar(255)     NOT NULL DEFAULT '' COMMENT 'buy_notice_id',
    `title`         varchar(255)     NOT NULL DEFAULT '' COMMENT '标题',
    `img_url`       varchar(255)     NOT NULL DEFAULT '' COMMENT '图片地址',
    `message`       varchar(255)     NOT NULL DEFAULT '' COMMENT '内容',
    `status`        tinyint          NOT NULL DEFAULT 1 COMMENT '状态 1可用 0弃用',
    `sort`          int(10)          NOT NULL DEFAULT 0 COMMENT '排序 大在上',
    `created_at`    datetime(3)      NULL     DEFAULT NULL COMMENT '创建时间',
    `updated_at`    datetime(3)      NULL     DEFAULT NULL COMMENT '修改时间',
    KEY `kylin_buy_notice_uid_index` (`buy_notice_id`),
    KEY `kylin_buy_notice_status_index` (`status`),
    PRIMARY KEY (`mid`)
) ENGINE = InnoDB
  DEFAULT CHARSET utf8mb4
  COLLATE utf8mb4_unicode_ci COMMENT '购票须知表';

-- 验票用户表
drop TABLE if exists `kylin_check_user`;
CREATE TABLE `kylin_check_user`
(
    `mid`           int(10) unsigned NOT NULL AUTO_INCREMENT,
    `check_user_id` varchar(255)     NOT NULL DEFAULT '' COMMENT 'check_user_id',
    `name`          varchar(255)     NOT NULL DEFAULT '' COMMENT '姓名',
    `mobile`        varchar(255)     NOT NULL DEFAULT '' COMMENT '手机号',
    `pwd`           varchar(255)     NOT NULL DEFAULT '' COMMENT '密码',
    `status`        tinyint          NOT NULL DEFAULT 1 COMMENT '是否可用 0否 1是',
    `merchant_id`   varchar(255)     NOT NULL DEFAULT '' COMMENT 'merchantId 第三方id',
    `created_at`    datetime(3)      NULL     DEFAULT NULL COMMENT '创建时间',
    `updated_at`    datetime(3)      NULL     DEFAULT NULL COMMENT '修改时间',
    KEY `kylin_check_user_uid_index` (`check_user_id`),
    KEY `kylin_check_user_mobile_index` (`mobile`),
    KEY `kylin_check_user_pwd_index` (`pwd`),
    PRIMARY KEY (`mid`)
) ENGINE = InnoDB
  DEFAULT CHARSET utf8mb4
  COLLATE utf8mb4_unicode_ci COMMENT '验票用户表';

-- 验票用户可看演出表
drop TABLE if exists `kylin_check_user_performances`;
CREATE TABLE `kylin_check_user_performances`
(
    `mid`                       int(10) unsigned NOT NULL AUTO_INCREMENT,
    `check_user_performance_id` varchar(255)     NOT NULL DEFAULT '' COMMENT 'check_user_performance_id',
    `performance_id`            varchar(255)     NOT NULL DEFAULT '' COMMENT '演出id',
    `check_user_id`             varchar(255)     NOT NULL DEFAULT '' COMMENT 'check_user_id',
    `status`                    tinyint          NOT NULL DEFAULT 1 COMMENT '状态 1可用 0不可',
    `can_down_time`             datetime         NULL     DEFAULT NULL COMMENT '可下载时间',
    `created_at`                datetime(3)      NULL     DEFAULT NULL COMMENT '创建时间',
    `updated_at`                datetime(3)      NULL     DEFAULT NULL COMMENT '修改时间',
    KEY `kylin_check_user_uid_index` (`check_user_id`),
    KEY `kylin_check_user_performance_id_index` (`performance_id`),
    KEY `kylin_check_user_check_user_id_index` (`check_user_id`),
    KEY `kylin_check_user_status_index` (`status`),
    PRIMARY KEY (`mid`)
) ENGINE = InnoDB
  DEFAULT CHARSET utf8mb4
  COLLATE utf8mb4_unicode_ci COMMENT '验票用户可看演出表';


insert into `kylin_buy_notice` (`buy_notice_id`, `img_url`, `message`, `status`, `sort`, `created_at`,
                                `updated_at`, `title`)
values ('1', 'http://img-zhengzai-tv.oss-cn-hangzhou.aliyuncs.com/partner/2019/01/21/5c45722882a13.png',
        '门票为有价证券，并非商品，一经售出不予退换。因“不可抗力”导致的演出取消或延期除外。', '1', '0', '2019-01-29 13:51:42', '2019-01-29 13:51:42', '门票不退不换');
insert into `kylin_buy_notice` (`buy_notice_id`, `img_url`, `message`, `status`, `sort`, `created_at`,
                                `updated_at`, `title`)
values ('2', 'http://img-zhengzai-tv.oss-cn-hangzhou.aliyuncs.com/partner/2019/01/21/5c456e93db0b9.png',
        '本场演出不设座位，均为站席观演。', '1', '0', '2019-01-29 13:51:42', '2019-01-29 13:51:42', '仅设站席');
insert into `kylin_buy_notice` (`buy_notice_id`, `img_url`, `message`, `status`, `sort`, `created_at`,
                                `updated_at`, `title`)
values ('3', 'http://img-zhengzai-tv.oss-cn-hangzhou.aliyuncs.com/partner/2019/01/21/5c456e5c27644.png',
        '为防止不法分子利用票务转让诈骗钱款，建议广大乐迷不要进行个人间票务买卖，不要轻易相信来源不明的转票，以免自身利益受到侵害。', '1', '0', '2019-01-29 13:51:42',
        '2019-01-29 13:51:42', '禁止个人票务买卖');
insert into `kylin_buy_notice` (`buy_notice_id`, `img_url`, `message`, `status`, `sort`, `created_at`,
                                `updated_at`, `title`)
values ('4', 'http://img-zhengzai-tv.oss-cn-hangzhou.aliyuncs.com/partner/2019/01/21/5c456d9482fb9.png',
        '本场演出凭纸质票验票入场，不支持选座，根据支付顺序择优安排。', '1', '0', '2019-01-29 13:51:42', '2019-01-29 13:51:42', '凭票入场');
insert into `kylin_buy_notice` (`buy_notice_id`, `img_url`, `message`, `status`, `sort`, `created_at`,
                                `updated_at`, `title`)
values ('5', 'http://img-zhengzai-tv.oss-cn-hangzhou.aliyuncs.com/partner/2019/01/21/5c456e163f0e5.png',
        '本场演出请按照票面标注对号入座。', '1', '0', '2019-01-29 13:51:42', '2019-01-29 13:51:42', '对号入座');
insert into `kylin_buy_notice` (`buy_notice_id`, `img_url`, `message`, `status`, `sort`, `created_at`,
                                `updated_at`, `title`)
values ('6', 'http://img-zhengzai-tv.oss-cn-hangzhou.aliyuncs.com/partner/2019/01/21/5c456d9482fb9.png',
        '凭订单二维码或手机号兑票入场，二维码或手机号请勿泄露，以免影响入场。个人原因导致的信息泄露，主办方/平台方不承担任何责任。', '1', '0', '2019-01-29 13:51:42',
        '2019-01-29 13:51:42', '电子票');
insert into `kylin_buy_notice` (`buy_notice_id`, `img_url`, `message`, `status`, `sort`, `created_at`,
                                `updated_at`, `title`)
values ('7', 'http://img-zhengzai-tv.oss-cn-hangzhou.aliyuncs.com/partner/2019/01/21/5c456d9482fb9.png',
        '电子票购票人须持本人身份证原件兑换实体票后验票入场。请不要将身份证信息提供给他人，因此导致的损失，主办方/平台方不承担任何责任。', '1', '0', '2019-01-29 13:51:42',
        '2019-01-29 13:51:42', '凭身份证原件兑票');
insert into `kylin_buy_notice` (`buy_notice_id`, `img_url`, `message`, `status`, `sort`, `created_at`,
                                `updated_at`, `title`)
values ('8', 'http://img-zhengzai-tv.oss-cn-hangzhou.aliyuncs.com/partner/2019/06/17/5d0763c262a30.png',
        '凭实体票验票入场的演出，门票请妥善保管，忘带、丢失、损坏等情况，主办方/平台方无法办理补票。', '1', '0', '2019-06-17 18:06:06', '2019-06-17 18:06:06',
        '门票丢失不补');
insert into `kylin_buy_notice` (`buy_notice_id`, `img_url`, `message`, `status`, `sort`, `created_at`,
                                `updated_at`, `title`)
values ('9', 'http://img-zhengzai-tv.oss-cn-hangzhou.aliyuncs.com/partner/2019/06/17/5d0764a613742.png',
        '请通过官方平台【正在现场】购买门票。通过个人转让购买的门票，若遇到假票、一票多卖等情况，导致的损失，主办方/平台方不承担任何责任。', '1', '0', '2019-06-17 18:06:06',
        '2019-06-17 18:06:06', '购买官方门票');
insert into `kylin_buy_notice` (`buy_notice_id`, `img_url`, `message`, `status`, `sort`, `created_at`,
                                `updated_at`, `title`)
values ('10', 'http://img-zhengzai-tv.oss-cn-hangzhou.aliyuncs.com/partner/2019/06/17/5d0764c565d9e.png',
        '学生票仅适用于年龄在25周岁以下的在校生。学生票购票人须持本人学生证或校园卡等有效学生证件兑换实体票后验票入场，无法提供有效学生证件则需补全差价。', '1', '0', '2019-06-17 18:06:06',
        '2019-06-17 18:06:06', '学生票');
insert into `kylin_buy_notice` (`buy_notice_id`, `img_url`, `message`, `status`, `sort`, `created_at`,
                                `updated_at`, `title`)
values ('11', 'http://img-zhengzai-tv.oss-cn-hangzhou.aliyuncs.com/partner/2019/06/17/5d07647eaa55f.png',
        '每场现场票数量由场地方决定，具体请到现场询问。', '1', '0', '2019-06-17 18:06:06', '2019-06-17 18:06:06', '现场票');
insert into `kylin_buy_notice` (`buy_notice_id`, `img_url`, `message`, `status`, `sort`, `created_at`,
                                `updated_at`, `title`)
values ('12', 'http://img-zhengzai-tv.oss-cn-hangzhou.aliyuncs.com/partner/2019/01/21/5c456d9482fb9.png',
        '电子票购票人须持本人身份证原件和订单二维码验票入场。请不要将身份证信息和订单二维码提供给他人，因此导致的损失，主办方/平台方不承担任何责任。', '1', '0', '2019-01-29 13:51:42',
        '2019-01-29 13:51:42', '凭身份证原件兑票');

#批量退款表
drop TABLE if exists `kylin_order_refund_batches`;
CREATE TABLE `kylin_order_refund_batches`
(
    `mid`             int unsigned   NOT NULL AUTO_INCREMENT,
    `refund_batch_id` varchar(255)   NOT NULL DEFAULT '' COMMENT 'refund_batch_id',
    `target_id`       varchar(255)   NOT NULL DEFAULT '' COMMENT '目标id target_type=1为演出id',
    `status`          tinyint        NOT NULL DEFAULT '1' COMMENT '批量退款状态 1申请退款 2取消退款 3运营驳回审核 4运营通过审核 5财务驳回审核 6财务通过审核',
    `total_num`       int            NOT NULL DEFAULT '0' COMMENT '申请时退票总数',
    `total_alipay`    decimal(11, 2) NOT NULL DEFAULT '0.00' COMMENT '申请时支付宝需退款总金额 包含快递费',
    `total_wepay`     decimal(11, 2) NOT NULL DEFAULT '0.00' COMMENT '申请时微信需退款总金额 包含快递费',
    `created_at`      timestamp      NULL     DEFAULT NULL,
    `updated_at`      timestamp      NULL     DEFAULT NULL,
    KEY `kylin_order_refund_batch_id_index` (`refund_batch_id`),
    PRIMARY KEY (`mid`)
) ENGINE = InnoDB
  DEFAULT CHARSET utf8mb4
  COLLATE utf8mb4_unicode_ci COMMENT '批量退款表';

#订单退款表
drop TABLE if exists `kylin_order_refunds`;
CREATE TABLE `kylin_order_refunds`
(
    `mid`                     int unsigned   NOT NULL AUTO_INCREMENT,
    `order_refunds_id`        varchar(255)   NOT NULL DEFAULT '' COMMENT 'order_refunds_id',
    `order_tickets_id`        varchar(255)   NOT NULL DEFAULT '' COMMENT '票务订单id',
    `order_refund_code`       varchar(50)    NOT NULL COMMENT '退款编号 order_code + 001编号',
    `order_refund_batches_id` varchar(255)   NOT NULL DEFAULT '' COMMENT '批量退款id',
    `refund_code`             varchar(50)    NOT NULL DEFAULT '' COMMENT '退款中心退款编号',
    `refund_at`               timestamp      NULL     DEFAULT NULL COMMENT '成功退款时间',
    `refund_id`               varchar(50)    NOT NULL DEFAULT '' COMMENT '第三方退款编号',
    `refund_error`            varchar(100)   NOT NULL DEFAULT '' COMMENT '退款失败原因',
    `price`                   decimal(10, 2) NOT NULL DEFAULT '0.00' COMMENT '退款票总金额',
    `price_express`           decimal(10, 2) NOT NULL DEFAULT '0.00' COMMENT '退款快递费',
    `status`                  tinyint        NOT NULL DEFAULT '0' COMMENT '退款状态: 0请求退款 2取消退款 1审核通过 5驳回退款 7等待退款 3正在退款 4完成退款 6退款失败',
    `type`                    tinyint        NOT NULL DEFAULT '0' COMMENT '退款发起类型 0客服、票务人工申请 1超时退款 2用户申请普通退款 3用户申请快递退款',
    `applicant_id`            varchar(255)   NOT NULL DEFAULT '' COMMENT '申请人id',
    `applicant_name`          varchar(100)   NOT NULL DEFAULT '' COMMENT '申请人名称',
    `applicant_at`            timestamp      NULL     DEFAULT NULL COMMENT '申请时间',
    `reason`                  varchar(200)   NOT NULL DEFAULT '' COMMENT '退款原因',
    `auditor_id`              varchar(255)   NOT NULL DEFAULT '' COMMENT '审核人id',
    `auditor_name`            varchar(100)   NOT NULL DEFAULT '' COMMENT '审核人名称',
    `auditor_at`              timestamp      NULL     DEFAULT NULL COMMENT '审核时间',
    `reject`                  varchar(200)   NOT NULL DEFAULT '' COMMENT '驳回原因',
    `executor_id`             varchar(255)   NOT NULL DEFAULT '' COMMENT '执行人id',
    `executor_name`           varchar(100)   NOT NULL DEFAULT '' COMMENT '执行人名称',
    `executor_at`             timestamp      NULL     DEFAULT NULL COMMENT '执行时间',
    `refuse`                  varchar(200)   NOT NULL DEFAULT '' COMMENT '回绝原因',
    `refund_type`             varchar(200)   NOT NULL DEFAULT '' COMMENT '退款方式',
    `created_at`              timestamp      NULL     DEFAULT NULL,
    `updated_at`              timestamp      NULL     DEFAULT NULL,
    PRIMARY KEY (`mid`),
    UNIQUE KEY `kylin_order_refunds_order_refund_code_unique` (`order_refund_code`),
    KEY `kylin_order_refunds_order_tickets_id_index` (`order_tickets_id`),
    KEY `kylin_order_refunds_refund_type_index` (`refund_type`),
    KEY `kylin_order_refunds_order_refunds_id_index` (`order_refunds_id`)
) ENGINE = InnoDB
  DEFAULT CHARSET utf8mb4
  COLLATE utf8mb4_unicode_ci COMMENT ='订单退款表';

alter table kylin_order_refunds add price_charges decimal(10, 2) NOT NULL DEFAULT '0.00' COMMENT '退款扣除的手续费金额' after price_express;

drop TABLE if exists `kylin_order_refund_entities`;
CREATE TABLE `kylin_order_refund_entities`
(
    `mid`                       int unsigned   NOT NULL AUTO_INCREMENT,
    `order_refunds_entities_id` varchar(255)   NOT NULL DEFAULT '' COMMENT 'order_refunds_entities_id',
    `order_refunds_id`          varchar(255)   NOT NULL DEFAULT '' COMMENT 'order_refunds_id',
    `order_ticket_entities_id`  varchar(255)   NOT NULL DEFAULT '' COMMENT 'order_ticket_entities_id',
    `refund_price`              decimal(11, 2) NOT NULL DEFAULT '0.00' COMMENT '退款金额',
    `created_at`                timestamp      NULL     DEFAULT NULL,
    `updated_at`                timestamp      NULL     DEFAULT NULL,
    KEY `kylin_order_refunds_entities_id_index` (`order_refunds_entities_id`),
    PRIMARY KEY (`mid`)
) ENGINE = InnoDB
  DEFAULT CHARSET utf8mb4
  COLLATE utf8mb4_unicode_ci COMMENT '退款入场人表';

drop TABLE if exists `kylin_order_express`;
CREATE TABLE `kylin_order_express`
(
    `mid`                    int unsigned   NOT NULL AUTO_INCREMENT,
    `order_express_id`       varchar(255)   NOT NULL DEFAULT '' COMMENT 'order_express_id',
    `performances_id`        varchar(255)   NOT NULL DEFAULT '' COMMENT 'performances_id',
    `order_tickets_id`       varchar(255)   NOT NULL DEFAULT '' COMMENT '订单id',
    `order_express_code`     varchar(255)   NOT NULL DEFAULT '' COMMENT '订单快递编号',
    `mailno`                 varchar(255)   NOT NULL DEFAULT '' COMMENT '顺丰运单号',
    `express_type`           tinyint        NOT NULL DEFAULT 0 COMMENT '快件产品类型 1顺丰特快...',
    `filter_result`          varchar(2)     NOT NULL DEFAULT '0' COMMENT '1-人工确认；2-可收派；3-不可以收派',
    `remark`                 varchar(255)   NOT NULL DEFAULT '' COMMENT 'filter_result=3时返回不可以收派的原因代码',
    `express_status`         tinyint        NOT NULL DEFAULT 0 COMMENT '快递状态',
    `origincode`             varchar(255)   NOT NULL DEFAULT '' COMMENT '原寄地区域代码 可用于顺丰电子面单标签打印',
    `destcode`               varchar(255)   NOT NULL DEFAULT '' COMMENT '目的地区域代码 可用于顺丰电子面单标签打印',

    `freight_price`          decimal(11, 2) NOT NULL DEFAULT '0.00' COMMENT '估算的运费',

    `return_tracking_no`     varchar(30)    NOT NULL DEFAULT '' COMMENT '顺丰签回单服务运单号',
    `source_transfer_code`   varchar(60)    NOT NULL DEFAULT '' COMMENT '原寄地中转场',
    `source_city_code`       varchar(60)    NOT NULL DEFAULT '' COMMENT '原寄地城市代码',
    `source_dept_code`       varchar(60)    NOT NULL DEFAULT '' COMMENT '原寄地网点代码',
    `source_team_code`       varchar(60)    NOT NULL DEFAULT '' COMMENT '原寄地单元区域',
    `dest_city_code`         varchar(60)    NOT NULL DEFAULT '' COMMENT '目的地城市代码	eg:755',
    `dest_dept_code`         varchar(60)    NOT NULL DEFAULT '' COMMENT '目的地网点代码	eg:755AQ',
    `dest_dept_code_mapping` varchar(60)    NOT NULL DEFAULT '' COMMENT '目的地网点代码映射码',
    `dest_team_code`         varchar(60)    NOT NULL DEFAULT '' COMMENT '目的地单元区域	eg:001',
    `dest_team_code_mapping` varchar(60)    NOT NULL DEFAULT '' COMMENT '目的地单元区域映射码',
    `dest_transfer_code`     varchar(60)    NOT NULL DEFAULT '' COMMENT '目的地中转场',
    `dest_route_label`       varchar(200)   NOT NULL DEFAULT '' COMMENT '路由标签信息',
    `pro_name`               varchar(60)    NOT NULL DEFAULT '' COMMENT '产品名称	对应RLS:pro_name',
    `cargo_type_code`        varchar(30)    NOT NULL DEFAULT '' COMMENT '快件内容	如:C816、SP601',
    `limit_type_code`        varchar(30)    NOT NULL DEFAULT '' COMMENT '时效代码	如:T4',
    `express_type_code`      varchar(30)    NOT NULL DEFAULT '' COMMENT '产品类型	如:B1',
    `coding_mapping`         varchar(60)    NOT NULL DEFAULT '' COMMENT '入港映射码	eg:S10',
    `coding_mapping_out`     varchar(60)    NOT NULL DEFAULT '' COMMENT '出港映射码',
    `xb_flag`                varchar(30)    NOT NULL DEFAULT '' COMMENT 'XB标志	0:不需要打印XB，1:需要打印XB',
    `print_flag`             varchar(60)    NOT NULL DEFAULT '' COMMENT '打印标志',
    `two_dimension_code`     varchar(600)   NOT NULL DEFAULT '' COMMENT '二维码',
    `pro_code`               varchar(30)    NOT NULL DEFAULT '' COMMENT '时效类型	值为二维码中的K4',
    `print_icon`             varchar(100)   NOT NULL DEFAULT '' COMMENT '打印图标',
    `ab_flag`                varchar(30)    NOT NULL DEFAULT '' COMMENT 'AB标',
    `dest_port_code`         varchar(100)   NOT NULL DEFAULT '' COMMENT '目的地口岸代码',
    `dest_country`           varchar(50)    NOT NULL DEFAULT '' COMMENT '目的国别	国别代码如:JP',
    `dest_post_code`         varchar(100)   NOT NULL DEFAULT '' COMMENT '目的地邮编',
    `goods_value_total`      varchar(30)    NOT NULL DEFAULT '' COMMENT '总价值	保留两位小数，数字类型，可补位',
    `currency_symbol`        varchar(30)    NOT NULL DEFAULT '' COMMENT '币种',
    `goods_number`           varchar(20)    NOT NULL DEFAULT '' COMMENT '件数',
    `two_dimension_code2`    varchar(600)   NOT NULL DEFAULT '' COMMENT '签回单二维码	下单时，当选择签回单增值服务时，会回传此字段，规则同“twoDimensionCode”',
    `new_icon`               varchar(100)   NOT NULL DEFAULT '' COMMENT 'ab标扩展',
    `new_abflag`             varchar(30)    NOT NULL DEFAULT '' COMMENT '打印图标扩展',

    `is_print`               tinyint        NOT NULL DEFAULT 1 COMMENT '是否打印 1无 2已打印',
    `print_num`              int            NOT NULL DEFAULT 0 COMMENT '打印次数',

    `created_at`             timestamp      NULL     DEFAULT NULL,
    `updated_at`             timestamp      NULL     DEFAULT NULL,
    KEY `order_express_id_index` (`order_express_id`),
    PRIMARY KEY (`mid`)
) ENGINE = InnoDB
  DEFAULT CHARSET utf8mb4
  COLLATE utf8mb4_unicode_ci COMMENT '订单快递表';

alter table kylin_order_express add send_type tinyint not null default 1 comment '发货类型 1发出 2用户退款发货' after freight_price;
alter table kylin_order_express add send_express_type tinyint not null default 0 comment '退票发货快递类型 1上门取件 2自主发货' after send_type;
alter table kylin_order_express add express_contacts varchar(255) not null default '' comment '退票发货快递人' after send_express_type;
alter table kylin_order_express add express_phone varchar(255) not null default '' comment '退票发货快递联系方式' after express_contacts;
alter table kylin_order_express add send_express_address varchar(255) not null default '' comment '退票发货快递地址' after express_phone;
alter table kylin_order_express add appointment_time varchar(255) not null default '' comment '退票发货快递预约取件时间' after send_express_address;

drop TABLE if exists `kylin_order_express_fee_info`;
CREATE TABLE `kylin_order_express_fee_info`
(
    `mid`                       int unsigned   NOT NULL AUTO_INCREMENT,
    `order_express_fee_info_id` varchar(255)   NOT NULL DEFAULT '' COMMENT 'order_express_fee_info_id',
    `order_express_id`          varchar(255)   NOT NULL DEFAULT '' COMMENT 'order_express_id',
    `type`                      varchar(2)     NOT NULL DEFAULT '0' COMMENT '费用类型',
    `name`                      varchar(200)   NOT NULL DEFAULT '' COMMENT '费用名称',
    `value`                     decimal(11, 2) NOT NULL DEFAULT '0.00' COMMENT '金额',
    `created_at`                timestamp      NULL     DEFAULT NULL,
    `updated_at`                timestamp      NULL     DEFAULT NULL,
    KEY `order_express_fee_info_id_index` (`order_express_fee_info_id`),
    PRIMARY KEY (`mid`)
) ENGINE = InnoDB COMMENT '订单快递费用信息表';

drop TABLE if exists `kylin_order_express_route`;
CREATE TABLE `kylin_order_express_route`
(
    `mid`                    int unsigned NOT NULL AUTO_INCREMENT,
    `order_express_route_id` varchar(255) NOT NULL DEFAULT '' COMMENT 'order_express_route_id',
    `order_express_id`       varchar(255) NOT NULL DEFAULT '' COMMENT 'order_express_id',
    `accept_address`         varchar(200) NOT NULL DEFAULT '' COMMENT '路由节点发生的城市',
    `accept_date`            varchar(200) NOT NULL DEFAULT '' COMMENT 'YYYY-MM-DD',
    `accept_time`            varchar(200) NOT NULL DEFAULT '' COMMENT 'HH24:MM:SS',
    `accept_totaltime`       varchar(200) NOT NULL DEFAULT '' COMMENT 'YYYY-MM-DD HH24:MM:SS',
    `remark`                 varchar(255) NOT NULL DEFAULT '' COMMENT '路由节点具体描述',
    `opcode`                 varchar(200) NOT NULL DEFAULT '' COMMENT '路由节点操作码',
    `created_at`             timestamp    NULL     DEFAULT NULL,
    `updated_at`             timestamp    NULL     DEFAULT NULL,
    KEY `order_express_route_id_index` (`order_express_route_id`),
    PRIMARY KEY (`mid`)
) ENGINE = InnoDB COMMENT '订单快递路由表';

drop TABLE if exists `kylin_order_express_status`;
CREATE TABLE `kylin_order_express_status`
(
    `mid`                     int unsigned NOT NULL AUTO_INCREMENT,
    `order_express_status_id` varchar(255) NOT NULL DEFAULT '' COMMENT 'order_express_status_id',
    `order_express_id`        varchar(255) NOT NULL DEFAULT '' COMMENT 'order_express_id',
    `order_state_code`        varchar(200) NOT NULL DEFAULT '' COMMENT '订单状态',
    `order_state_desc`        varchar(200) NOT NULL DEFAULT '' COMMENT '订单状态描述',
    `emp_code`                varchar(200) NOT NULL DEFAULT '' COMMENT '收件员工工号',
    `emp_phone`               varchar(200) NOT NULL DEFAULT '' COMMENT '收件员手机号',
    `net_code`                varchar(200) NOT NULL DEFAULT '' COMMENT '网点',
    `last_time`               varchar(255) NOT NULL DEFAULT '' COMMENT '最晚上门时间',
    `book_time`               varchar(200) NOT NULL DEFAULT '' COMMENT '客户预约时间',
    `carrier_code`            varchar(200) NOT NULL DEFAULT '' COMMENT '承运商代码(SF)',
    `created_at`              timestamp    NULL     DEFAULT NULL,
    `updated_at`              timestamp    NULL     DEFAULT NULL,
    KEY `order_express_status_id_index` (`order_express_status_id`),
    PRIMARY KEY (`mid`)
) ENGINE = InnoDB COMMENT '订单快递状态表';

drop TABLE if exists `kylin_order_express_performances`;
CREATE TABLE `kylin_order_express_performances`
(
    `mid`                           int unsigned NOT NULL AUTO_INCREMENT,
    `order_express_performances_id` varchar(255) NOT NULL DEFAULT '' COMMENT 'order_express_performances_id',
    `performances_id`               varchar(255) NOT NULL DEFAULT '' COMMENT 'performances_id',
    `total1`                        int          NOT NULL DEFAULT 0 COMMENT '已下单',
    `total2`                        int          NOT NULL DEFAULT 0 COMMENT '已揽收',
    `total3`                        int          NOT NULL DEFAULT 0 COMMENT '已签收',
    `created_at`                    timestamp    NULL     DEFAULT NULL,
    `updated_at`                    timestamp    NULL     DEFAULT NULL,
    KEY `order_express_performances_id_index` (`order_express_performances_id`),
    PRIMARY KEY (`mid`)
) ENGINE = InnoDB COMMENT '订单快递演出记录表';

drop TABLE if exists `kylin_order_refund_pic`;
CREATE TABLE `kylin_order_refund_pic`
(
    `mid`              int unsigned NOT NULL AUTO_INCREMENT,
    `refund_pic_id`    varchar(255) NOT NULL DEFAULT '' COMMENT 'refund_pic_id',
    `order_refunds_id` varchar(255) NOT NULL DEFAULT '' COMMENT '订单退款表id',
    `pic_url`          varchar(255) NOT NULL DEFAULT '' COMMENT '图片地址',
    `created_at`       timestamp    NULL     DEFAULT NULL,
    `updated_at`       timestamp    NULL     DEFAULT NULL,
    KEY `kylin_refund_pic_refund_pic_id_index` (`refund_pic_id`),
    KEY `kylin_refund_pic_order_refunds_id_index` (`order_refunds_id`),
    PRIMARY KEY (`mid`)
) ENGINE = InnoDB
  DEFAULT CHARSET utf8mb4
  COLLATE utf8mb4_unicode_ci COMMENT '订单退款图片表';

drop TABLE if exists `kylin_zhengzai_app_versions`;
CREATE TABLE `kylin_zhengzai_app_versions`
(
    `mid`                      int(11) unsigned NOT NULL AUTO_INCREMENT,
    `zhengzai_app_versions_id` varchar(255)     NOT NULL DEFAULT '' COMMENT 'zhengzai_app_versions_id',
    `name`                     varchar(128)     NOT NULL DEFAULT '' COMMENT '名称',
    `file_path`                varchar(255)     NOT NULL DEFAULT '' COMMENT '文件路径',
    `version`                  varchar(50)      NOT NULL DEFAULT '' COMMENT '版本号',
    `min_version`              varchar(10)      NOT NULL DEFAULT '' COMMENT '最近版本号',
    `type`                     tinyint          NOT NULL DEFAULT '0' COMMENT '上传类型 1-IOS 2-Android',
    `is_production`            tinyint          NOT NULL DEFAULT '0' COMMENT '是否是生产环境，2否 1是',
    `is_force`                 tinyint          NOT NULL DEFAULT '0' COMMENT '强制更新 2否 1是',
    `content`                  varchar(255)     NOT NULL DEFAULT '' COMMENT '升级描述',
    `is_deleted`               tinyint          NOT NULL DEFAULT '1' COMMENT '1正常 2已删除',
    `app_type`                 tinyint          NOT NULL DEFAULT '0' COMMENT '1正在现场app 2验票app',
    `created_at`               timestamp        NULL     DEFAULT NULL,
    `updated_at`               timestamp        NULL     DEFAULT NULL,
    KEY `kylin_zhengzai_app_versions_id_index` (`zhengzai_app_versions_id`),
    PRIMARY KEY (`mid`)
) ENGINE = InnoDB
  DEFAULT CHARSET utf8mb4
  COLLATE utf8mb4_unicode_ci COMMENT '正在现场app版本控制';

drop TABLE if exists `platform_oss_files`;
create table platform_oss_files
(
    `mid`           int(11) unsigned NOT NULL AUTO_INCREMENT,
    `oss_files_id`  varchar(255)     NOT NULL DEFAULT '' COMMENT 'oss_files_id',
    `file_name`     varchar(255)     NOT NULL DEFAULT '' COMMENT '源文件名称',
    `content_type`  varchar(255)     NOT NULL DEFAULT '' COMMENT '文件类型',
    `size`          int              NOT NULL DEFAULT 0 COMMENT '文件大小',
    `md5str`        varchar(255)     NOT NULL DEFAULT '' COMMENT 'md5值判断文件是否相同',
    `oss_path`      varchar(255)     NOT NULL DEFAULT '' COMMENT '文件地址（阿里oss）',
    `buck_type`     tinyint          NOT NULL DEFAULT '0' COMMENT 'buck_type',
    `uploader_uid`  varchar(255)     NOT NULL DEFAULT '' COMMENT '上传人id',
    `uploader_name` varchar(255)     NOT NULL DEFAULT '' COMMENT '上传人姓名',
    `created_at`    timestamp        NULL     DEFAULT NULL,
    `updated_at`    timestamp        NULL     DEFAULT NULL,
    KEY `kylin_oss_files_id_index` (`oss_files_id`),
    PRIMARY KEY (`mid`)
) ENGINE = InnoDB
  DEFAULT CHARSET utf8mb4
  COLLATE utf8mb4_unicode_ci COMMENT '阿里云OSS上传记录';

drop TABLE if exists `admin_upush`;
CREATE TABLE `admin_upush`
(
    `mid`               int(11) unsigned NOT NULL AUTO_INCREMENT,
    `upush_id`          varchar(255)     NOT NULL DEFAULT 0 COMMENT 'upush_id',
    `push_range`        tinyint          NOT NULL DEFAULT 0 COMMENT '推送设备 1all 2ios 3android',
    `push_title`        varchar(255)     NOT NULL DEFAULT '' COMMENT '推送标题',
    `push_content`      varchar(255)     NOT NULL DEFAULT '' COMMENT '推送内容',
    `img`               varchar(500)     NOT NULL DEFAULT '' COMMENT '封面图',
    `jump_type`         tinyint          NOT NULL DEFAULT 0 COMMENT '跳转类型',
    `jump_value`        varchar(255)     NOT NULL DEFAULT '' COMMENT '跳转值',
    `jump_content`      varchar(500)     NOT NULL DEFAULT '' COMMENT '跳转对应的值名称',
    `push_time`         timestamp        NULL     DEFAULT NULL COMMENT '推送时间',
    `is_push`           int              NOT NULL DEFAULT 0 COMMENT '是否发送推送消息，2不发送 1发送推送消息',
    `send_type`         int              NOT NULL DEFAULT 0 COMMENT '发送类型，2立即发送 1定时发送',
    `message_type`      int              NOT NULL DEFAULT 2 COMMENT '消息类型，2系统消息 1会员消息 会员不做了 默认2',
    `specify_type`      int              NOT NULL DEFAULT 2 COMMENT '用户类型，2全部用户 1指定手机号 指定手机不做了默认2',
    `message_show_type` int              NOT NULL DEFAULT 0 COMMENT '消息展示类型，2普通文本，1图文排版',
    `pushed_by`         varchar(255)     NOT NULL DEFAULT '' COMMENT '推送者ID',
    `pushed_name`       varchar(255)     NOT NULL DEFAULT '' COMMENT '推送者姓名',
    `task_id`           varchar(255)     NOT NULL DEFAULT '' COMMENT '任务类消息(type为broadcast、groupcast、filecast、customizedcast且file_id不为空)返回',
    `msg_id`            varchar(255)     NOT NULL DEFAULT '' COMMENT '单播类消息(type为unicast、listcast、customizedcast且不带file_id)返回',
    `error_code`        varchar(255)     NOT NULL DEFAULT '' COMMENT '错误码',
    `error_msg`         varchar(255)     NOT NULL DEFAULT '' COMMENT '错误信息',
    `created_at`        timestamp        NULL     DEFAULT NULL,
    `updated_at`        timestamp        NULL     DEFAULT NULL,
    KEY `admin_upush_id_index` (`upush_id`),
    PRIMARY KEY (`mid`)
) ENGINE = InnoDB
  DEFAULT CHARSET utf8mb4
  COLLATE utf8mb4_unicode_ci COMMENT '友盟消息推送';
