package com.liquidnet.service.goblin.dto.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 购物车vo
 * </p>
 *
 * @author liquidnet
 * @since 2021-12-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinShoppingCartVoo implements Serializable {
  @ApiModelProperty(value = "根据shop分类")
  private  List<GoblinShoppingCartVo> shopList;
  //mongodb 对应的id
  private String goblinShoppingCartId;
  //mongodb userid
  private  String userId;



  private static final GoblinShoppingCartVoo obj = new GoblinShoppingCartVoo();
  public static GoblinShoppingCartVoo getNew() {
    try {
      return (GoblinShoppingCartVoo) obj.clone();
    } catch (CloneNotSupportedException e) {
      return new GoblinShoppingCartVoo();
    }
  }
}
