package com.liquidnet.service.platform.controller.goblin;

import com.liquidnet.service.goblin.service.IGoblinExportService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import javax.servlet.http.HttpServletResponse;

@Api(tags = "商城-订单信息导出")
@Controller
@RequestMapping("/tools/export")
@Validated
public class GoblinExportDataController {

    @Autowired
    IGoblinExportService iGoblinExportService;

    /**
     * 导出商城订单信息
     *
     * @param beginTime
     * @param endTime
     * @return
     */
    @GetMapping("/exportMallOrder")
    @ApiOperation(value = "excel订单信息导出")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "beginTime", value = "开始时间"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "storeId", value = "店铺id"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "endTime", value = "结束时间"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "state", value = "状态逗号隔开字符串[0-待付款(用户刚下单)|2-代发货(用户付完款 等待商城发货)|3-代收货(商城已经发货 等待用户确认收货)|4-已完成(用户已经确认收货 订单结束)|5-取消订单(用户未付款前取消订单)|6-退款通过(用户已经付款但是商城还未发货，用户发出退款申请，商城同意退款)|7-退货通过(用户已经确认收货后用户发出退货申请，商城同意所有退货申请 ，一个订单可能有多个单品)|61-6的发起状态|71-7的发起状态】"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "mailType", value = "快递状态[0-全部|1-未发货|2-已发货]"),
    })
    public void exportMallOrder(HttpServletResponse response, @RequestParam("beginTime") String beginTime, @RequestParam("endTime") String endTime,
                                @RequestParam("state") String state, @RequestParam("mailType") Integer mailType, @RequestParam("storeId") String storeId) {
        iGoblinExportService.exportMallOrder(response, beginTime, endTime, state, mailType, storeId);
    }

}
