package com.liquidnet.service.galaxy.dto.param;

import com.liquidnet.commons.lang.util.JsonUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: GalaxyNftImageReqDto
 * @Package com.liquidnet.service.galaxy.dto.param
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/3/15 17:56
 */
@ApiModel(value = "GalaxyNftImageReqDto", description = "NFT图片检测")
@Data
public class GalaxyNftImageReqDto extends GalaxyBaseReqDto implements Serializable,Cloneable {
    @ApiModelProperty(position = 1, required = true, value = "素材地址(全路径)不能超过500字符")
    @NotBlank(message = "素材地址(全路径)不能为空！")
    @Size(min = 2, max = 500, message = "素材地址(全路径)不能超过500字符")
    private String nftOriginalUrl;

    @Override
    public String toString(){
        return JsonUtils.toJson(this);
    }

    private static final GalaxyNftImageReqDto obj = new GalaxyNftImageReqDto();

    public static GalaxyNftImageReqDto getNew() {
        try {
            return (GalaxyNftImageReqDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GalaxyNftImageReqDto();
        }
    }
}
