package com.liquidnet.service.kylin.dto.vo.express;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.LinkedList;

/**
 * <p>
 * 快递信息
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-07-01
 */

@Data
@ApiModel
public class KylinOrderExpressVo implements Serializable , Cloneable{

    private static final long serialVersionUID = 1626827142646063350L;
    @ApiModelProperty(value = "orderExpressId")
    private String orderExpressId;
    @ApiModelProperty(value = "orderTicketsId")
    private String orderTicketsId;
    @ApiModelProperty(value = "自己的快递单号")
    private String orderExpressCode;
    @ApiModelProperty(value = "顺丰快递单号")
    private String mailno;
    @ApiModelProperty(value = "快递状态")
    private Integer expressStatus;
    @ApiModelProperty(value = "1上门取件 2自主发货")
    private Integer sendExpressType;
    @ApiModelProperty(value = "物流数据")
    LinkedList<KylinOrderExpressRouteVo> routeList;

    private static final KylinOrderExpressVo obj = new KylinOrderExpressVo();

    public static KylinOrderExpressVo getNew() {
        try {
            return (KylinOrderExpressVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new KylinOrderExpressVo();
        }
    }

}
