package com.liquidnet.service.kylin.dto.vo.returns;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * refund batches返回给前端的数据字段
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-05-31 11:19 上午
 */

@Data
@ApiModel
public class KylinOrderRefundBatchesVo implements Serializable {

    @ApiModelProperty(value = "主键ID")
    private String refundBatchId;

    @ApiModelProperty(value = "演出id")
    private String targetId;

    @ApiModelProperty(value = "状态")
    private Integer status;

    private Integer totalNum;
    private BigDecimal totalAlipay;
    private BigDecimal totalWepay;

    private Integer totalRefundNum;
    private Integer totalCompleteRefundNum;

    @ApiModelProperty(value = "添加时间")
    private LocalDateTime createdAt;

    @ApiModelProperty(value = "更新时间")
    private LocalDateTime updatedAt;

}
