package com.liquidnet.service.goblin.dto.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

import static com.liquidnet.commons.lang.util.DateUtil.DTF_YMD_HMS;

/**
 * <p>
 *
 * </p>
 *
 * @author jobob
 * @since 2022-03-11
 */
@ApiModel(value = "SmileVProjectListVo")
@Data
public class SmileVProjectListVo implements Serializable, Cloneable {

    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value = "活动id")
    private String projectId;
    @ApiModelProperty(value = "标题")
    private String title;
    @ApiModelProperty(value = "开始时间")
    private String timeStart;
    @ApiModelProperty(value = "结束时间")
    private String timeEnd;
    @ApiModelProperty(value = "地址")
    private String address;
    @ApiModelProperty(value = "封面图")
    private String img;
    @ApiModelProperty(value = "报名状态[0-未报名|1-已报名]")
    private Integer applyStatus;
    @ApiModelProperty(value = "活动状态[0-未开始|1-进行中|2-已结束]")
    private Integer projectStatus;

    private static final SmileVProjectListVo obj = new SmileVProjectListVo();

    public static SmileVProjectListVo getNew() {
        try {
            return (SmileVProjectListVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new SmileVProjectListVo();
        }
    }


    public SmileVProjectListVo copy(SmileProjectDetailsVo source, Integer applyStatus) {
        this.setProjectId(source.getProjectId());
        this.setTitle(source.getTitle());
        this.setTimeStart(source.getTimeStart());
        this.setTimeEnd(source.getTimeEnd());
        this.setAddress(source.getAddress());
        this.setImg(source.getImg());
        this.setApplyStatus(applyStatus);
//        LocalDateTime now = LocalDateTime.now();
//        LocalDateTime ldtStart = LocalDateTime.parse(source.getTimeStart(), DTF_YMD_HMS);
//        LocalDateTime ldtEnd = LocalDateTime.parse(source.getTimeEnd(), DTF_YMD_HMS);
        this.setProjectStatus(1);
//        if (now.isAfter(ldtEnd)) {
//            this.setProjectStatus(2);
//        } else if (now.isBefore(ldtStart)) {
//            this.setProjectStatus(0);
//        }else{
//            this.setProjectStatus(1);
//        }
        return this;
    }

}
