package com.liquidnet.service.goblin.entity;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 店铺基础信息
 * </p>
 *
 * @author liquidnet
 * @since 2021-12-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinStoreInfo implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * 店铺id
     */
    private String storeId;

    /**
     * 店主UID
     */
    private String uid;

    /**
     * 店铺名称
     */
    private String storeName;

    /**
     * 店铺LOGO
     */
    private String logoPic;

    /**
     * 店铺背景图
     */
    private String backgroundPic;

    /**
     * 店铺介绍
     */
    private String introduce;

    /**
     * 店铺状态[0-填写资料中|1-店铺审核中|2-审核不通过|3-审核通过|4-停业|5-营业]
     */
    private String status;

    /**
     * 拒绝原因
     */
    private String reason;

    /**
     * 店铺类型[1-普通店铺|2-加盟|3-连锁|5-直营]
     */
    private String storeType;

    /**
     * 认证类型[1-企业/公司|2-个体工商户]
     */
    private String certType;

    /**
     * 店铺评分
     */
    private BigDecimal aveScore;

    /**
     * 客服账号
     */
    private String serviceAcc;

    /**
     * 店铺有效期
     */
    private LocalDateTime validity;

    /**
     * 删除标记[0-未删除|1-删除]
     */
    private String delFlg;

    private String createdBy;

    private LocalDateTime createdAt;

    private String updatedBy;

    private LocalDateTime updatedAt;

    private String deletedBy;

    private LocalDateTime deletedAt;

    private String comment;


}
