package com.liquidnet.service.goblin.service.impl.inner;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.commons.lang.util.HttpUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.galaxy.dto.param.GalaxyArtSeriesClaimReqDto;
import com.liquidnet.service.galaxy.dto.param.GalaxyArtSeriesClaimRespDto;
import com.liquidnet.service.galaxy.dto.param.GalaxyNftUploadReqDto;
import com.liquidnet.service.galaxy.dto.param.GalaxyNftUploadRespDto;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * Galaxy服务接口调用
 *
 * @author zhanggb
 * Created by IntelliJ IDEA at 2022/4/1
 */
@Slf4j
@Service
public class GoblinGalaxyService {
    @Autowired
    Environment env;
//    @Value("${liquidnet.service.galaxy.url}")// TODO: 2022/3/31 ==zhanggb
//    private String sevGalaxyUrl;

    /**
     * NFT素材上传
     *
     * @param nftUploadReqDto GalaxyNftUploadReqDto
     * @return GalaxyNftUploadRespDto
     */
    public GalaxyNftUploadRespDto uploadNftMaterial(GalaxyNftUploadReqDto nftUploadReqDto) {
//        String postUrl = sevGalaxyUrl + "/user/register", blockChainAddress;// TODO: 2022/3/31 ==zhanggb
        String postUrl = "https://ENVgalaxy.zhengzai.tv/galaxy/artwork/nftUpload".replace("ENV", env.getProperty(CurrentUtil.CK_ENV_ACTIVE)), blockChainAddress;
        String postBody = JsonUtils.toJson(nftUploadReqDto);
        try {
            String postRespStr = HttpUtil.postRaw(postUrl, postBody, null);
            JsonNode postRespJNode = JsonUtils.fromJson(postRespStr, JsonNode.class), postRespCode;
            if (null == postRespJNode || null == (postRespCode = postRespJNode.get("code")) || !postRespCode.asText().equals("0")) {
                log.warn("#NFT素材上传:请求失败[paramsStr={},postRespStr={}]", postBody, postRespStr);
                return null;
            }
            return JsonUtils.OM().convertValue(postRespJNode.get("data"), GalaxyNftUploadRespDto.class);
        } catch (Exception e) {
            log.error("Ex.NFT素材上传:请求异常[url={},paramsStr={}],ex:{}", postUrl, postBody, e.getMessage());
            return null;
        }
    }

    /**
     * NFT系列声明
     *
     * @param seriesClaimReqDto GalaxyArtSeriesClaimReqDto
     * @return GalaxyArtSeriesClaimRespDto
     */
    public GalaxyArtSeriesClaimRespDto claimNftSeries(GalaxyArtSeriesClaimReqDto seriesClaimReqDto) {
//        String postUrl = sevGalaxyUrl + "/user/register", blockChainAddress;// TODO: 2022/3/31 ==zhanggb
        String postUrl = "https://ENVgalaxy.zhengzai.tv/galaxy/artwork/nftUpload".replace("ENV", env.getProperty(CurrentUtil.CK_ENV_ACTIVE)), blockChainAddress;
        String postBody = JsonUtils.toJson(seriesClaimReqDto);
        try {
            String postRespStr = HttpUtil.postRaw(postUrl, postBody, null);
            JsonNode postRespJNode = JsonUtils.fromJson(postRespStr, JsonNode.class), postRespCode;
            if (null == postRespJNode || null == (postRespCode = postRespJNode.get("code")) || !postRespCode.asText().equals("0")) {
                log.warn("#NFT系列声明:请求失败[paramsStr={},postRespStr={}]", postBody, postRespStr);
                return null;
            }
            return JsonUtils.OM().convertValue(postRespJNode.get("data"), GalaxyArtSeriesClaimRespDto.class);
        } catch (Exception e) {
            log.error("Ex.NFT系列声明:请求异常[url={},paramsStr={}],ex:{}", postUrl, postBody, e.getMessage());
            return null;
        }
    }

    /**
     * NFT发行、购买结果查询
     *
     * @param uid
     * @param orderId
     * @param routerType
     * @return
     */
    public List<String> checkNftTradeResult(String uid, String orderId, String routerType) {
        ObjectNode postBodyNode = JsonUtils.OM().createObjectNode();
        postBodyNode.put("userId", uid);
        postBodyNode.put("nftOrderPayId", orderId);
        postBodyNode.put("routerType", routerType);

//        String postUrl = sevGalaxyUrl + "/user/register", blockChainAddress;// TODO: 2022/3/31 ==zhanggb
        String postUrl = "https://ENVgalaxy.zhengzai.tv/galaxy/nftTrade/nftPublishAndBuyResultQuery".replace("ENV", env.getProperty(CurrentUtil.CK_ENV_ACTIVE)), blockChainAddress;
        try {
            String postRespStr = HttpUtil.postRaw(postUrl, postBodyNode.toString(), null);
            JsonNode postRespJNode = JsonUtils.fromJson(postRespStr, JsonNode.class), postRespCode;
            if (null == postRespJNode || null == (postRespCode = postRespJNode.get("code")) || !postRespCode.asText().equals("0")) {
                log.warn("#NFT发行购买结果查询:查询失败[postBody={},postRespStr={}]", postBodyNode, postRespStr);
                return null;
            }
            JsonNode postRespDataJNode = postRespJNode.get("data");

            List<String> respDataList = CollectionUtil.arrayListString();
            respDataList.add(postRespDataJNode.get("nftId").asText());
            respDataList.add(postRespDataJNode.get("nftPublishChainTimestamp").asText());
            respDataList.add(postRespDataJNode.get("nftPublishTradeHash").asText());
            respDataList.add(postRespDataJNode.get("nftBuyChainTimestamp").asText());
            respDataList.add(postRespDataJNode.get("nftBuyTradeHash").asText());
            return respDataList;
        } catch (Exception e) {
            log.error("Ex.NFT发行购买结果查询:请求异常[url={},postBody={}],ex:{}", postUrl, postBodyNode, e.getMessage());
            return null;
        }
    }
}
