package com.liquidnet.service.sweet;

import io.swagger.annotations.ApiOperation;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.condition.RequestMethodsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

import java.util.List;
import java.util.Map;
import java.util.Set;

@RunWith(SpringJUnit4ClassRunner.class)
@SpringBootTest
@ConfigurationProperties(prefix = "global-auth")
public class SweetTest {
    private static final Logger log = LoggerFactory.getLogger(SweetTest.class);
    @Autowired
    private WebApplicationContext webApplicationContext;

    private final static AntPathMatcher antPathMatcher = new AntPathMatcher();
    private final static String CONTEXT = "/sweet";

    private List<String> excludeUrlPattern;

    public List<String> getExcludeUrlPattern() {
        return excludeUrlPattern;
    }

    public void setExcludeUrlPattern(List<String> excludeUrlPattern) {
        this.excludeUrlPattern = excludeUrlPattern;
    }

    @Test
    public void pullUrl() {
        //requestMappingHandlerMapping,swagger2ControllerMapping,controllerEndpointHandlerMapping
        RequestMappingHandlerMapping mapping = webApplicationContext.getBean("requestMappingHandlerMapping", RequestMappingHandlerMapping.class);
        Map<RequestMappingInfo, HandlerMethod> handlerMethodMap = mapping.getHandlerMethods();
        handlerMethodMap.forEach((c, m) -> {
            RequestMethodsRequestCondition methodsCondition = c.getMethodsCondition();

            ApiOperation methodAnnotation = m.getMethodAnnotation(ApiOperation.class);

            Set<String> patterns = c.getPatternsCondition().getPatterns();

            patterns.forEach(r -> {
                String url = CONTEXT.concat(r);
                boolean hitflg = false;
                for (String urlPattern : excludeUrlPattern) {
                    if (antPathMatcher.match(urlPattern, url)) {
                        hitflg = true;
                    }
                }
                log.info("{}AUTH {} {} {}", hitflg ? "NO" : "", methodsCondition.isEmpty() ? "-" : methodsCondition, url, null != methodAnnotation ? methodAnnotation.value() : "-");
            });
        });
    }
}
