package com.liquidnet.service.consumer.slowly.config;

import com.liquidnet.common.cache.redis.config.RedisStreamConfig;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.consumer.slowly.receiver.ConsumerSlimeFieldRdsReceiver;
import lombok.var;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.stream.StreamMessageListenerContainer;
import org.springframework.data.redis.stream.Subscription;

import java.util.ArrayList;
import java.util.List;

@Configuration
public class ConsumerSlimeFieldRedisStreamConfig extends RedisStreamConfig {
    @Autowired
    ConsumerSlimeFieldRdsReceiver consumerSlimeFieldRdsReceiver;

    @Autowired
    StringRedisTemplate stringRedisTemplate;

    @Bean
    public List<Subscription> subscriptionSqlField(RedisConnectionFactory factory) {
        List<Subscription> subscriptionList = new ArrayList<>();
        MQConst.SlimeQueue stream = MQConst.SlimeQueue.SQL_SLIME_FIELD;
        this.initStream(stringRedisTemplate, stream.getKey(), stream.getGroup());
        for (int i = 0; i < 1; i++) {
            StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer = this.buildStreamMessageListenerContainer(factory);
            subscriptionList.add(listenerContainer.receiveAutoAck(
                    Consumer.from(stream.getGroup(), getConsumerName(stream.name() + i)),
                    StreamOffset.create(stream.getKey(), ReadOffset.lastConsumed()), consumerSlimeFieldRdsReceiver
            ));
            listenerContainer.start();
        }
        return subscriptionList;
    }
//    /**
//     * 场地相关更新
//     *
//     * @param listenerContainer
//     * @param t
//     * @return
//     */
//    private Subscription receiveSqlField(StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer, int t) {
//        return listenerContainer.receiveAutoAck(Consumer.from(MQConst.SlimeQueue.SQL_SLIME_FIELD.getGroup(), getConsumerName(MQConst.SlimeQueue.SQL_SLIME_FIELD.name() + t)),
//                StreamOffset.create(MQConst.SlimeQueue.SQL_SLIME_FIELD.getKey(), ReadOffset.lastConsumed()), consumerSlimeFieldRdsReceiver);
//    }
//
//    /* —————————————————————————— ｜ —————————————————————————— ｜ —————————————————————————— */
//
//    /* -------------------------------------------------------- ｜ 场地相关更新 */
//
//    @Bean
//    public Subscription subscriptionReceiveSqlField0(RedisConnectionFactory factory) {
//        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
//        var subscription = receiveSqlField(listenerContainer, 0);
//        listenerContainer.start();
//        return subscription;
//    }
//
////    @Bean
////    public Subscription subscriptionReceiveSqlField1(RedisConnectionFactory factory) {
////        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
////        var subscription = receiveSqlField(listenerContainer, 1);
////        listenerContainer.start();
////        return subscription;
////    }
////
////    @Bean
////    public Subscription subscriptionReceiveSqlField2(RedisConnectionFactory factory) {
////        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
////        var subscription = receiveSqlField(listenerContainer, 2);
////        listenerContainer.start();
////        return subscription;
////    }
//
////    @Bean
////    public Subscription subscriptionReceiveSqlField3(RedisConnectionFactory factory) {
////        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
////        var subscription = receiveSqlField(listenerContainer, 3);
////        listenerContainer.start();
////        return subscription;
////    }
////
////    @Bean
////    public Subscription subscriptionReceiveSqlField4(RedisConnectionFactory factory) {
////        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
////        var subscription = receiveSqlField(listenerContainer, 4);
////        listenerContainer.start();
////        return subscription;
////    }
//
//    /* -------------------------------------------------------- ｜  */
}
