package com.liquidnet.service.goblin.dto.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.liquidnet.commons.lang.util.DateUtil;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 商城:用户优惠券展示信息（缓存）
 */
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class GoblinUserCouponVo implements Serializable, Cloneable {
    private static final long serialVersionUID = -5700053935603334517L;
    @ApiModelProperty(position = 10, value = "用户券ID[64]")
    private String ucouponId;
    @ApiModelProperty(position = 11, value = "卡券ID")
    private String storeCouponId;
    @ApiModelProperty(position = 12, value = "用户券状态[1-可用|2-无效|3-已过期|5-已使用]")
    private Integer state;
    @ApiModelProperty(position = 13, value = "激活时间")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern= DateUtil.DATE_FULL_STR)
    private LocalDateTime bindAt;
    @ApiModelProperty(position = 14, value = "到期时间")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern= DateUtil.DATE_FULL_STR)
    private LocalDateTime duedAt;
    @ApiModelProperty(position = 15, value = "使用时间")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern= DateUtil.DATE_FULL_STR)
    private LocalDateTime usedAt;
    @ApiModelProperty(position = 16, value = "用于记录购买的内容")
    private String usedFor;

    @ApiModelProperty(position = 21, value = "卡券名称")
    private String title;
    @ApiModelProperty(position = 22, value = "标注")
    private String label;
    @ApiModelProperty(position = 23, value = "卡券描述")
    private String notice;
    @ApiModelProperty(position = 24, value = "券类型[1-代金券|2-折扣券|3-满减券]")
    private String type;
    @ApiModelProperty(position = 25, value = "触发金额")
    private BigDecimal triggers;
    @ApiModelProperty(position = 26, value = "面值")
    private BigDecimal valFace;
    @ApiModelProperty(position = 27, value = "折扣[8折即0.8]")
    private BigDecimal discount;
    @ApiModelProperty(position = 28, value = "满减~满")
    private BigDecimal valOver;
    @ApiModelProperty(position = 29, value = "满减~减")
    private BigDecimal valMinus;
    @ApiModelProperty(position = 30, value = "抵扣上限金额（最多扣除金额）")
    private BigDecimal deduction;
    @ApiModelProperty(position = 31, value = "使用范围[0-全部商品|1-部分商品]")
    private String useScope;


    private static final GoblinUserCouponVo obj = new GoblinUserCouponVo();

    public static GoblinUserCouponVo getNew() {
        try {
            return (GoblinUserCouponVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinUserCouponVo();
        }
    }

    public GoblinUserCouponVo copy(GoblinUserCouponBasicVo source) {
        if (null == source) return this;
        this.setUcouponId(source.getUcouponId());
        this.setStoreCouponId(source.getStoreCouponId());
        this.setState(source.getState());
        this.setBindAt(source.getBindAt());
        this.setDuedAt(source.getDuedAt());
        this.setUsedAt(source.getUsedAt());
        this.setUsedFor(source.getUsedFor());
        this.setTitle(source.getTitle());
        this.setLabel(source.getLabel());
        this.setNotice(source.getNotice());
        this.setType(source.getType());
        this.setTriggers(source.getTriggers());
        this.setValFace(source.getValFace());
        this.setDiscount(source.getDiscount());
        this.setValOver(source.getValOver());
        this.setValMinus(source.getValMinus());
        this.setDeduction(source.getDeduction());
        this.setUseScope(source.getUseScope());
        return this;
    }
}
