package com.liquidnet.service.sweet.service.impl.five;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.entity.SweetManualSortFive;
import com.liquidnet.service.sweet.mapper.SweetManualSortFiveMapper;
import com.liquidnet.service.sweet.service.five.ISweetManualSortFiveService;
import com.liquidnet.service.sweet.utils.RedisFiveDataUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;

/**
 * <p>
 * 电子宣传手册显示内容表 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-08-09
 */
@Service
public class SweetManualSortFiveServiceImpl extends ServiceImpl<SweetManualSortFiveMapper, SweetManualSortFive> implements ISweetManualSortFiveService {

    @Autowired
    private SweetManualSortFiveMapper sweetManualSortFiveMapper;
    @Autowired
    private RedisFiveDataUtils redisDataUtils;

    @Override
    public ResponseDto<SweetManualSortFive> get(String manualId) {
        try {
            return ResponseDto.success(sweetManualSortFiveMapper.selectOne(Wrappers.lambdaQuery(SweetManualSortFive.class).eq(SweetManualSortFive::getManualId, manualId)));
        } catch (Exception e) {
            return ResponseDto.failure();
        }
    }

    @Override
    public ResponseDto<Boolean> add(String manualId, String content) {
        try {
            int count = sweetManualSortFiveMapper.selectCount(Wrappers.lambdaUpdate(SweetManualSortFive.class).eq(SweetManualSortFive::getManualId, manualId));
            if (count > 0) {
                SweetManualSortFive sweetManualSort = SweetManualSortFive.getNew();
                sweetManualSort.setManualId(manualId);
                sweetManualSort.setShowPosition(content);
                sweetManualSort.setUpdatedAt(LocalDateTime.now());
                sweetManualSortFiveMapper.update(sweetManualSort, Wrappers.lambdaUpdate(SweetManualSortFive.class).eq(SweetManualSortFive::getManualId, manualId));
            } else {
                SweetManualSortFive sweetManualSort = SweetManualSortFive.getNew();
                sweetManualSort.setManualId(manualId);
                sweetManualSort.setShowPosition(content);
                sweetManualSort.setCreatedAt(LocalDateTime.now());
                sweetManualSortFiveMapper.insert(sweetManualSort);
            }
            redisDataUtils.deleteSortRedisData(manualId);
        } catch (Exception e) {
            return ResponseDto.failure();
        }
        return ResponseDto.success();
    }

}
