package com.liquidnet.service.platform.controller.candy.task;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.candy.entity.CandyCoupon;
import com.liquidnet.service.platform.service.impl.candy.PlatformCandyCouponService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDateTime;

@Slf4j
@RestController
@RequestMapping("ccoupon/task")
public class CandyCouponTaskController {
    @Autowired
    private PlatformCandyCouponService platformCandyCouponService;

    @PutMapping("due/validity_check")
    public ResponseDto<String> dueCheck() {
        LocalDateTime now = LocalDateTime.now();

        LambdaQueryWrapper<CandyCoupon> queryWrapper = Wrappers.lambdaQuery(CandyCoupon.class);
        queryWrapper.eq(CandyCoupon::getState, 1);
        queryWrapper.eq(CandyCoupon::getExclusive, 0);
        queryWrapper.le(CandyCoupon::getExpireAt, now);
        int totalCount = platformCandyCouponService.count(queryWrapper);
        log.info("券到期检查总记录数:{} >>> BEGIN BEGIN BEGIN", totalCount);



        return ResponseDto.success();
    }
}
