package com.liquidnet.service.executor.main.handler;

import com.liquidnet.service.feign.sweet.task.FeignSweetTaskClient;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * XxlJob开发示例（Bean模式）
 * <p>
 * 开发步骤：
 * 1、在Spring Bean实例中，开发Job方法，方式格式要求为 "public ReturnT<String> execute(String param)"
 * 2、为Job方法添加注解 "@XxlJob(value="自定义jobhandler名称", init = "JobHandler初始化方法", destroy = "JobHandler销毁方法")"，注解value值对应的是调度中心新建任务的JobHandler属性的值。
 * 3、执行日志：需要通过 "XxlJobLogger.log" 打印执行日志；
 */
@Component
public class SweetTaskHandler {
    private static final Logger log = LoggerFactory.getLogger(SweetTaskHandler.class);

    @Autowired
    private FeignSweetTaskClient feignSweetTaskClient;

    @XxlJob(value = "sev-sweet:drawLuckAdd")
    public ReturnT<String> drawLuckAdd() {
        try {
            boolean result = feignSweetTaskClient.drawLuckAdd().getData();
            log.info("drawLuckAdd：结果："+result);
            return ReturnT.SUCCESS;
        } catch (Exception e) {
            return ReturnT.FAIL;
        }
    }

    @XxlJob(value = "sev-sweet:setDrawAllList")
    public ReturnT<String> setDrawAllListHandler() {
        try {
            String jobParam = XxlJobHelper.getJobParam();//执行参数
            log.info("jobParam = " + jobParam);
            String[] paramArray = jobParam.split(",");

            ReturnT<String> success = ReturnT.SUCCESS;

            for (String id : paramArray) {
                log.info("id = " + id);
                Boolean data = feignSweetTaskClient.setDrawAllList(id).getData();
                log.info("setDrawAllListHandler：结果：{}", data);
                success.setMsg(String.valueOf(data));
            }

            return success;
        } catch (Exception e) {
            log.error("exception of handler:{}", e.getMessage(), e);
            ReturnT<String> fail = ReturnT.FAIL;
            fail.setMsg(e.getLocalizedMessage());
            return fail;
        }
    }
}
