package com.liquidnet.service.platform.utils;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.service.adam.constant.AdamRedisConst;
import com.liquidnet.service.adam.dto.vo.AdamAddressesVo;
import com.liquidnet.service.adam.dto.vo.AdamEntersVo;
import com.liquidnet.service.adam.dto.vo.AdamUserMemberVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public class OrderUtils {

    @Autowired
    private DataUtils dataUtils;
    @Autowired
    private RedisUtil redisUtil;

    public String judgeOrderLimit(
            int type,
            String userId,
            String idCard,
            String performanceId,
            String ticketId,
            int performanceLimitCount,
            int performanceMemberLimitCount,
            int ticketLimitCount,
            int ticketMemberLimitCount,
            int performanceBuyCount,
            int ticketBuyCount,
            int memberType,
            int isTrueName
    ) {
        Integer[] integers;
        System.out.println("TYPE = " + type);
        if (101 == type) {
            integers = festivalOrderLimit(userId, idCard, performanceId, ticketId, performanceBuyCount, ticketBuyCount, isTrueName);
        } else {
            integers = roadShowOrderLimit(userId, idCard, performanceId, ticketId, performanceBuyCount, ticketBuyCount, isTrueName);
        }
        System.out.println("integers PERFORMANCE= " + integers[0]);
        System.out.println("integers TICKETS= " + integers[1]);

        return judgeMemberType(performanceLimitCount, performanceMemberLimitCount, ticketLimitCount, ticketMemberLimitCount, memberType, integers[0], integers[1]);
    }

    public Integer[] roadShowOrderLimit(
            String userId,
            String idCard,
            String performanceId,
            String ticketId,
            int performanceBuyCount,
            int ticketBuyCount,
            int isTrueName
    ) {
        if (1 == isTrueName) {//实名
            performanceBuyCount += dataUtils.getIdCardPBuyCount(idCard, performanceId);
            ticketBuyCount += dataUtils.getIdCardTBuyCount(idCard, ticketId);
        } else {//非实名
            performanceBuyCount += dataUtils.getUserPBuyCount(userId, performanceId);
            ticketBuyCount += dataUtils.getUserTBuyCount(userId, ticketId);
        }
        return new Integer[]{performanceBuyCount, ticketBuyCount};
    }

    public Integer[] festivalOrderLimit(
            String userId,
            String idCard,
            String performanceId,
            String ticketId,
            int performanceBuyCount,
            int ticketBuyCount,
            int isTrueName
    ) {
        if (1 == isTrueName) {//实名
            performanceBuyCount += dataUtils.getIdCardPBuyCount(idCard, performanceId);
            ticketBuyCount += dataUtils.getIdCardTBuyCount(idCard, ticketId);
        } else {//非实名
            performanceBuyCount += dataUtils.getUserPBuyCount(userId, performanceId);
            ticketBuyCount += dataUtils.getUserTBuyCount(userId, ticketId);
        }

        return new Integer[]{performanceBuyCount, ticketBuyCount};
    }

    public String judgeMemberType(int performanceLimitCount, int performanceMemberLimitCount, int ticketLimitCount, int ticketMemberLimitCount, int memberType, int performanceBuyCount, int ticketBuyCount) {
        if (memberType == 1 || memberType == 2) {
            if (performanceBuyCount > performanceMemberLimitCount && performanceMemberLimitCount != 0) {
                return "该演出只能购买" + performanceMemberLimitCount + "张";//超过演出维度购买量
            }
            if (ticketBuyCount > ticketMemberLimitCount && ticketMemberLimitCount != 0) {
                return "该票种只能购买" + ticketMemberLimitCount + "张";//超过票维度购买量
            }
        } else {//非会员区间
            if (performanceBuyCount > performanceLimitCount && performanceLimitCount != 0) {
                return "该演出只能购买" + performanceLimitCount + "张";//超过演出维度购买量
            }
            if (ticketBuyCount > ticketLimitCount && ticketLimitCount != 0) {
                return "该票种只能购买" + ticketLimitCount + "张";//超过票维度购买量
            }
        }
        return "";
    }

    public boolean isMember(String uid) {
        String rk = AdamRedisConst.INFO_USER_MEMBER.concat(uid);
        AdamUserMemberVo vo = (AdamUserMemberVo) redisUtil.get(rk);
        return null != vo && vo.isActive();
    }

    public AdamAddressesVo getAddress(String uid, String addressesId) {
        String rk = AdamRedisConst.INFO_ADDRESSES.concat(uid);
        List<AdamAddressesVo> vos = (List<AdamAddressesVo>) redisUtil.get(rk);
        return vos.stream().filter(r -> r.getAddressesId().equals(addressesId)).findAny().orElse(null);
    }

    public AdamEntersVo getEnters(String uid, String entersId) {
        String rk = AdamRedisConst.INFO_ENTERS.concat(uid);
        List<AdamEntersVo> vos = (List<AdamEntersVo>) redisUtil.get(rk);
        return vos.stream().filter(r -> r.getEntersId().equals(entersId)).findAny().orElse(null);
    }
}
