package com.liquidnet.service.merchant.util;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.liquidnet.commons.lang.util.*;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.kylin.dto.param.PerformancePartnerVo;
import com.liquidnet.service.kylin.dto.vo.middle.KylinTicketTimesVo;
import com.liquidnet.service.kylin.dto.vo.middle.KylinTicketVo;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinPerformanceVo;
import com.liquidnet.service.kylin.dto.vo.partner.*;
import com.liquidnet.service.kylin.entity.*;
import com.liquidnet.service.kylin.service.partner.IKylinTicketTimesPartnerService;
import com.liquidnet.service.kylin.service.partner.IKylinTicketsPartnerService;
import com.liquidnet.service.merchant.dto.vo.MerchantFieldsVo;
import com.mongodb.BasicDBObject;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.ReturnDocument;
import lombok.extern.slf4j.Slf4j;
import org.bson.Document;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.*;

@Component
@Slf4j
public class PerformanceUtils {

    @Autowired
    private RedisMerchantUtils redisMerchantUtils;
    @Autowired
    private MongoMerchantUtils mongoMerchantUtils;
    @Autowired
    QueueUtil queueUtil;
    @Autowired
    PerformanceUtils performanceUtils;
    @Autowired
    private IKylinTicketTimesPartnerService ticketTimesPartnerService;
    @Autowired
    private IKylinTicketsPartnerService ticketsPartnerService;

    /**
     * 根据票状态判断 演出状态 票状态
     *
     * @param performanceSingleId
     */
    public void performanceVoStatus(String performanceSingleId,Integer voStatus) {
        LinkedList<String> sqls = CollectionUtil.linkedListString();
        sqls.add(SqlMapping.get("kylin_ticket_status.VoStatus"));
        sqls.add(SqlMapping.get("kylin_performance_status.VoStatus"));
        LinkedList<Object[]> sqlsDataA = CollectionUtil.linkedListObjectArr();
        LinkedList<Object[]> sqlsDataB = CollectionUtil.linkedListObjectArr();
        LocalDateTime timeNow = LocalDateTime.now();
        List<String> performanceIdList = new ArrayList<>();
        if (performanceSingleId == null) {
            List<KylinPerformanceVo> list = mongoMerchantUtils.getPerformanceVoOnlineList();
            for (KylinPerformanceVo item : list) {
                performanceIdList.add(item.getPerformancesId());
            }
        } else {
            performanceIdList.add(performanceSingleId);
        }

        for (String performancesId : performanceIdList) {
            KylinPerformanceVo vo = combinePerformanceVoData(performancesId);
            if(voStatus!=null){
                vo.setAppStatus(voStatus);
            }
            //场次
            List<KylinTicketTimesVo> timesData = vo.getTicketTimeList();
            if (timesData.size() == 0) {
                continue;
            }
            int ticketCount = 0;            //总循环次数
            int status9Count = 0;            //未开售次数
            int status8Count = 0;            //售罄次数
            int status10Count = 0;            //已结束次数

            //演出数据
            int appStatus = 6;
            for (KylinTicketTimesVo kylinTicketTimesVoItem : timesData) {
                //票
                List<KylinTicketVo> kylinTicketVoList = kylinTicketTimesVoItem.getTicketList();
                ticketCount += kylinTicketVoList.size();
                for (KylinTicketVo kylinTicketVoItem : kylinTicketVoList) {
                    //时间判断
                    LocalDateTime timeStart = DateUtil.Formatter.yyyyMMddHHmmss.parse(kylinTicketVoItem.getMemberTimeStart());
                    LocalDateTime timeEnd = DateUtil.Formatter.yyyyMMddHHmmss.parse(kylinTicketVoItem.getTimeEnd());
                    int surplusGeneral = -1;
                    int status = 0;
                    if (timeStart.isAfter(timeNow)) {
                        //未开始
                        status = 9;
                        status9Count += 1;
                    } else if (timeEnd.isBefore(timeNow)) {
                        //结束
                        status = 10;
                        status10Count += 1;
                    } else {
                        //库存判断
                        surplusGeneral = redisMerchantUtils.getSurplusGeneral(kylinTicketVoItem.getTicketsId());
                        if (surplusGeneral > 0) {
                            status = 6;
                        } else {
                            status = 8;
                            status8Count += 1;
                        }
                    }

                    if (kylinTicketVoItem.getStatus() == 7) {
                        status = 7;
                    }

                    //修改票状态
                    KylinTicketStatus changeStatus = new KylinTicketStatus();
                    changeStatus.setStatus(status);
                    if (surplusGeneral != -1) {
                        changeStatus.setSurplusGeneral(surplusGeneral);
                    }
                    sqlsDataA.add(new Object[]{
                            changeStatus.getStatus(), changeStatus.getSurplusGeneral(), kylinTicketVoItem.getTicketsId(),timeNow,timeNow
                    });
                    kylinTicketVoItem.setStatus(status);

                    //演出状态
                    if (status == 6) {//单一票 可购买 则为可购买
                        appStatus = 6;
                    } else if (ticketCount == status10Count) {//全票结束 为结束
                        appStatus = 10;
                    } else if (ticketCount == status8Count) {//全票售罄为售罄
                        appStatus = 8;
                    } else if (ticketCount == status9Count) {//全票未开始 为未开始
                        appStatus = 9;
                    }
                }
            }
            if (vo.getAppStatus() <= 4) {
                appStatus = vo.getAppStatus();
            }
            if (vo.getAppStatus() == 7) {
                appStatus = 7;
            }
            //修改演出状态
            sqlsDataB.add(new Object[]{
                    appStatus, performancesId,timeNow,timeNow
            });
            String sqlData = SqlMapping.gets(sqls, sqlsDataA, sqlsDataB);
            queueUtil.sendMsgByRedis(MQConst.MerchantQueue.SQL_MERCHANT_PERFORMANCE_UPDATE.getKey(),
                    sqlData);

            vo.setAppStatus(appStatus);
            redisMerchantUtils.updatePerformanceMongo(performancesId, vo);
        }
    }

    /**
     * 生成 PerformanceCreatePartnerVo(用于审核第一次提交数据)
     *
     * @param performancesId
     * @return
     */
    public KylinPerformanceMisVo getPerformanceMisVo(String performancesId) {
        try {
            PerformancePartnerVo performanceData = mongoMerchantUtils.getPerformancePartnerVoNoMerchant(performancesId);
            List<KylinTicketTimesPartnerVo> kylinTicketTimesPartnerVos = ticketTimesPartnerService.getTimesMongoList(performancesId);
            List<TicketTimesTicketCreatePartnerVo> ticketTimesTicketCreatePartnerVoList = new ArrayList<TicketTimesTicketCreatePartnerVo>();

            ArrayList<BigDecimal> floatList = new ArrayList<>();
            ArrayList<String> StringList = new ArrayList<>();

            for (KylinTicketTimesPartnerVo ticketTimes : kylinTicketTimesPartnerVos) {
                TicketTimesTicketCreatePartnerVo ticketTimesTicketCreatePartnerVo = new TicketTimesTicketCreatePartnerVo();
                BeanUtils.copyProperties(ticketTimes, ticketTimesTicketCreatePartnerVo);
                List<KylinTicketPartnerVo> kylinTicketPartnerVos = ticketsPartnerService.getTicketMongoList(ticketTimes.getTicketTimesId());
                ticketTimesTicketCreatePartnerVo.setTicket(kylinTicketPartnerVos);
                ticketTimesTicketCreatePartnerVoList.add(ticketTimesTicketCreatePartnerVo);
                for (KylinTicketPartnerVo kylinTicketPartnerVoItem : kylinTicketPartnerVos) {
                    floatList.add(kylinTicketPartnerVoItem.getPrice());
                    StringList.add(kylinTicketPartnerVoItem.getTimeEnd());
                }
            }
            KylinPerformanceMisVo kylinPerformanceMisVo = new KylinPerformanceMisVo();
            BeanUtils.copyProperties(performanceData, kylinPerformanceMisVo);

            floatList.sort(Comparator.naturalOrder());
            StringList.sort(Comparator.naturalOrder());

            kylinPerformanceMisVo.setDetails(performanceData.getDetails());
            kylinPerformanceMisVo.setPrice(floatList.get(0) + "起");
            kylinPerformanceMisVo.setStopSellTime(StringList.get(0));
            kylinPerformanceMisVo.setTicketTimes(ticketTimesTicketCreatePartnerVoList);

            kylinPerformanceMisVo.setIsDistribution(0);
            kylinPerformanceMisVo.setSyncAgent(0);
            kylinPerformanceMisVo.setAuditStatus(0);

            return kylinPerformanceMisVo;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /**
     * 插入数据库
     *
     * @param performancesId
     * @param map
     * @param kylinPerformanceMisVo
     * @param updatedAt
     */
    public void createPerformanceMySql(String performancesId, HashMap<String, Object> map, KylinPerformanceMisVo kylinPerformanceMisVo, LocalDateTime updatedAt) {
        try {
            LinkedList<String> sqls = CollectionUtil.linkedListString();
            sqls.add(SqlMapping.get("kylin_performances.del"));
            sqls.add(SqlMapping.get("kylin_performances.insert"));
            sqls.add(SqlMapping.get("kylin_performance_status.del"));
            sqls.add(SqlMapping.get("kylin_performance_status.insert"));
            sqls.add(SqlMapping.get("kylin_performance_relations.del"));
            sqls.add(SqlMapping.get("kylin_performance_relations.insert"));
            sqls.add(SqlMapping.get("kylin_ticket_times.del"));
            sqls.add(SqlMapping.get("kylin_ticket_times.insert"));
            sqls.add(SqlMapping.get("kylin_ticket_time_relation.del"));
            sqls.add(SqlMapping.get("kylin_ticket_time_relation.insert"));
            sqls.add(SqlMapping.get("kylin_tickets.del"));
            sqls.add(SqlMapping.get("kylin_tickets.insert"));
            sqls.add(SqlMapping.get("kylin_ticket_status.del"));
            sqls.add(SqlMapping.get("kylin_ticket_status.insert"));
            sqls.add(SqlMapping.get("kylin_ticket_relations.del"));
            sqls.add(SqlMapping.get("kylin_ticket_relations.insert"));
            sqls.add(SqlMapping.get("kylin_ticket_express_module.del"));
            sqls.add(SqlMapping.get("kylin_ticket_express_module.insert"));

            LinkedList<Object[]> del1 = CollectionUtil.linkedListObjectArr();
            LinkedList<Object[]> del2 = CollectionUtil.linkedListObjectArr();
            LinkedList<Object[]> del3 = CollectionUtil.linkedListObjectArr();
            LinkedList<Object[]> del4 = CollectionUtil.linkedListObjectArr();
            LinkedList<Object[]> del5 = CollectionUtil.linkedListObjectArr();
            LinkedList<Object[]> del6 = CollectionUtil.linkedListObjectArr();
            LinkedList<Object[]> del7 = CollectionUtil.linkedListObjectArr();
            LinkedList<Object[]> del8 = CollectionUtil.linkedListObjectArr();
            LinkedList<Object[]> del9 = CollectionUtil.linkedListObjectArr();

            LinkedList<Object[]> insert1 = CollectionUtil.linkedListObjectArr();
            LinkedList<Object[]> insert2 = CollectionUtil.linkedListObjectArr();
            LinkedList<Object[]> insert3 = CollectionUtil.linkedListObjectArr();
            LinkedList<Object[]> insert4 = CollectionUtil.linkedListObjectArr();
            LinkedList<Object[]> insert5 = CollectionUtil.linkedListObjectArr();
            LinkedList<Object[]> insert6 = CollectionUtil.linkedListObjectArr();
            LinkedList<Object[]> insert7 = CollectionUtil.linkedListObjectArr();
            LinkedList<Object[]> insert8 = CollectionUtil.linkedListObjectArr();
            LinkedList<Object[]> insert9 = CollectionUtil.linkedListObjectArr();

            //创建演出
            KylinPerformances performances = new KylinPerformances();
            BeanUtils.copyProperties(kylinPerformanceMisVo, performances);
            KylinPerformanceStatus performanceStatus = new KylinPerformanceStatus();
            BeanUtils.copyProperties(kylinPerformanceMisVo, performanceStatus);
            KylinPerformanceRelations performanceRelations = new KylinPerformanceRelations();
            BeanUtils.copyProperties(kylinPerformanceMisVo, performanceRelations);

            performances.setCreatedAt(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(kylinPerformanceMisVo.getCreatedAt())));
            performances.setTimeStart(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(kylinPerformanceMisVo.getTimeStart())));
            performances.setTimeEnd(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(kylinPerformanceMisVo.getTimeEnd())));
            MerchantFieldsVo fieldsVo = redisMerchantUtils.getFieldVo(performanceRelations.getFieldId());
            performances.setCityName(fieldsVo.getCityName());
            performances.setCityId(Integer.parseInt(fieldsVo.getCityId()));
            performances.setUpdatedAt(updatedAt);

            performanceStatus.setPerformanceId(performances.getPerformancesId());
            performanceStatus.setPerformanceStatusId(IDGenerator.nextSnowId());
            performanceStatus.setCreatedAt(performances.getCreatedAt());
            performanceStatus.setAuditStatus(0);
            performanceStatus.setUpdatedAt(updatedAt);

            performanceStatus.setLimitCountMember(1);

            performanceRelations.setPerformanceId(performances.getPerformancesId());
            performanceRelations.setPerformanceRelationsId(IDGenerator.nextSnowId());
            performanceRelations.setCreatedAt(performances.getCreatedAt());
            performanceRelations.setUpdatedAt(updatedAt);

            del1.add(new Object[]{performances.getPerformancesId()});
            insert1.add(performances.insert(performances));
            del2.add(new Object[]{performances.getPerformancesId()});
            insert2.add(performanceStatus.insert(performanceStatus));
            del3.add(new Object[]{performances.getPerformancesId()});
            insert3.add(performanceRelations.insert(performanceRelations));

            //场次数据
            List<KylinTicketTimesPartnerVo> kylinTicketTimesPartnerVos = ticketTimesPartnerService.getTimesMongoList(performancesId);
            for (KylinTicketTimesPartnerVo ticketTimeItem : kylinTicketTimesPartnerVos) {
                //创建场次
                KylinTicketTimes ticketTimes = new KylinTicketTimes();
                BeanUtils.copyProperties(ticketTimeItem, ticketTimes);
                KylinTicketTimeRelation ticketTimeRelation = new KylinTicketTimeRelation();
                BeanUtils.copyProperties(ticketTimeItem, ticketTimeRelation);

                ticketTimes.setUseStart(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ticketTimeItem.getUseStart())));
                ticketTimes.setUseEnd(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ticketTimeItem.getUseEnd())));
                ticketTimes.setCreatedAt(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ticketTimeItem.getCreatedAt())));
                ticketTimes.setUpdatedAt(updatedAt);

                ticketTimeRelation.setPerformanceId(performancesId);
                ticketTimeRelation.setTicketTimeRelationId(IDGenerator.nextSnowId());
                ticketTimeRelation.setTimesId(ticketTimes.getTicketTimesId());
                ticketTimeRelation.setCreatedAt(ticketTimes.getCreatedAt());
                ticketTimeRelation.setUpdatedAt(updatedAt);

                del4.add(new Object[]{ticketTimes.getTicketTimesId()});
                insert4.add(ticketTimes.insert(ticketTimes));
                del5.add(new Object[]{ticketTimes.getTicketTimesId()});
                insert5.add(ticketTimeRelation.insert(ticketTimeRelation));

                //修改票
                for (KylinTicketPartnerVo ticketItem : ticketsPartnerService.getTicketMongoList(ticketTimeItem.getTicketTimesId())) {
                    Document docTicket = mongoMerchantUtils.getObjectTicketVo(map, ticketItem.getTicketsId());
                    KylinTicketPartnerVo kylinTicketPartnerVo = JsonUtils.fromJson(docTicket.toJson(), KylinTicketPartnerVo.class);

                    //创建演出
                    KylinTickets tickets = new KylinTickets();
                    BeanUtils.copyProperties(kylinTicketPartnerVo, tickets);
                    KylinTicketStatus ticketStatus = new KylinTicketStatus();
                    BeanUtils.copyProperties(kylinTicketPartnerVo, ticketStatus);
                    KylinTicketRelations ticketRelations = new KylinTicketRelations();
                    BeanUtils.copyProperties(kylinTicketPartnerVo, ticketRelations);
                    tickets.setPayCountdownMinute(kylinPerformanceMisVo.getPayCountdownMinute());
                    tickets.setPriceExpress(new BigDecimal("0.00"));
                    tickets.setPriceDiscountMember(new BigDecimal("0.00"));
                    tickets.setPriceDiscount(new BigDecimal("0.00"));
                    tickets.setTimeStart(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ticketItem.getTimeStart())));
                    tickets.setTimeEnd(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ticketItem.getTimeEnd())));
                    if (ticketItem.getIsExpress() == 1) {
                        tickets.setTimeEndExpress(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ticketItem.getTimeEndExpress())));
                        tickets.setDescribeExpress(ticketItem.getDescribeExpress());
                    }else{
                        tickets.setTimeEndExpress(updatedAt);
                        tickets.setDescribeExpress("");
                    }
                    if (ticketItem.getIsElectronic() == 1) {
                        tickets.setDescribeElectronic(ticketItem.getDescribeElectronic());
                    }else{
                        tickets.setDescribeElectronic("");
                    }
                    tickets.setUseStart(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ticketTimeItem.getUseStart())));
                    tickets.setUseEnd(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ticketTimeItem.getUseEnd())));
                    tickets.setSaleRemindMinute(60);
                    tickets.setAdvanceMinuteMember(5);
                    tickets.setCreatedAt(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ticketItem.getCreatedAt())));
                    tickets.setUpdatedAt(updatedAt);
                    ticketStatus.setTicketStatusId(IDGenerator.nextSnowId());
                    ticketStatus.setTicketId(tickets.getTicketsId());
                    ticketStatus.setIsMember(1);
                    ticketStatus.setIsExclusive(0);
                    ticketStatus.setIsTrueName(performanceStatus.getIsTrueName());
                    ticketStatus.setMemberLimitCount(1);
                    ticketStatus.setStatusExchange(7);
                    if (ticketItem.getIsShowCode() == 1) {
                        ticketStatus.setQrCodeShowTime(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ticketItem.getQrCodeShowTime())));
                    }else{
                        ticketStatus.setQrCodeShowTime(updatedAt);
                    }

                    ticketRelations.setCreatedAt(tickets.getCreatedAt());
                    ticketRelations.setUpdatedAt(updatedAt);
                    ticketRelations.setTicketRelationsId(IDGenerator.nextSnowId());
                    ticketRelations.setTicketId(tickets.getTicketsId());
                    ticketRelations.setCreatedAt(tickets.getCreatedAt());
                    ticketRelations.setUpdatedAt(updatedAt);

                    del6.add(new Object[]{tickets.getTicketsId()});
                    insert6.add(tickets.insert(tickets));
                    del7.add(new Object[]{tickets.getTicketsId()});
                    insert7.add(ticketStatus.insert(ticketStatus));
                    del8.add(new Object[]{tickets.getTicketsId()});
                    insert8.add(ticketRelations.insert(ticketRelations));

                    redisMerchantUtils.setSurplusExchange(tickets.getTicketsId(), ticketStatus.getSurplusExchange());
                    redisMerchantUtils.setSurplusGeneral(tickets.getTicketsId(), ticketStatus.getSurplusGeneral());

                    //快递相关
                    KylinTicketExpressModuleVo moduleVo = redisMerchantUtils.getTEMPVo(tickets.getTicketsId());
                    redisMerchantUtils.setTEMVo(tickets.getTicketsId(), moduleVo);
                    del9.add(new Object[]{tickets.getTicketsId()});
                    for (String mVo:moduleVo.getExpressModuleIdList())
                    insert9.add(new Object[]{
                            tickets.getTicketsId(),mVo,updatedAt,updatedAt
                    });
                }
            }
            String sqlData = SqlMapping.gets(sqls,
                    del1, insert1,
                    del2, insert2,
                    del3, insert3,
                    del4, insert4,
                    del5, insert5,
                    del6, insert6,
                    del7, insert7,
                    del8, insert8,
                    del9, insert9
            );
            queueUtil.sendMsgByRedis(MQConst.MerchantQueue.SQL_MERCHANT_PERFORMANCE_INSERT.getKey(),
                    sqlData);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    // 判断是否需要审核
    public boolean judgeIsAudit(String performanceId) {
        KylinPerformanceMisVo misVo = getPerformanceMisVo(performanceId);
        KylinPerformanceVo mongoVo = combinePerformanceVoData(performanceId);
        if (!misVo.getTitle().equals(mongoVo.getTitle())) {
            log.info("performanceId = " + performanceId + " NEED CHANGE TITLE");
            return true;
        }
        if (!misVo.getImgPoster().equals(mongoVo.getImgPoster())) {
            log.info("performanceId = " + performanceId + " NEED CHANGE IMGPOSTER");
            return true;
        } else if (!misVo.getType().equals(mongoVo.getType())) {
            log.info("performanceId = " + performanceId + " NEED CHANGE TYPE");
            return true;
        } else if (!misVo.getTimeStart().equals(mongoVo.getTimeStart())) {
            log.info("performanceId = " + performanceId + " NEED CHANGE TIMESTART");
            return true;
        } else if (!misVo.getTimeEnd().equals(mongoVo.getTimeEnd())) {
            log.info("performanceId = " + performanceId + " NEED CHANGE TIMEEND");
            return true;
        } else if (!misVo.getFieldId().equals(mongoVo.getFieldId())) {
            log.info("performanceId = " + performanceId + " NEED CHANGE FIELDID");
            return true;
        } else if (!misVo.getNotice().equals(mongoVo.getNotice())) {
            log.info("performanceId = " + performanceId + " NEED CHANGE NOTICE");
            return true;
        } else if (!misVo.getDetails().replace("'", "").equals(mongoVo.getDetails().replace("'", ""))) {
            log.info("performanceId = " + performanceId + " NEED CHANGE DETAILS");
            return true;
        } else if (!misVo.getApprovalUrl().equals(mongoVo.getApprovalUrl())) {
            log.info("performanceId = " + performanceId + " NEED CHANGE APPROVALURL");
            return true;
        } else if (!misVo.getPayCountdownMinute().equals(mongoVo.getPayCountdownMinute())) {
            log.info("performanceId = " + performanceId + " NEED CHANGE PAYCOUTDOWN");
            return true;
        }

        boolean exists = mongoMerchantUtils.isExistsAddTime(performanceId);
        if (exists) {
            log.info("performanceId = " + performanceId + " NEED CHANGE NEW TIMES");
            return true;
        }
        for (int i = 0; i < misVo.getTicketTimes().size(); i++) {
            TicketTimesTicketCreatePartnerVo times = misVo.getTicketTimes().get(i);
            KylinTicketTimesVo timesVo = mongoVo.getTicketTimeList().get(i);
            if (!times.getUseStart().equals(timesVo.getUseStart())) {
                log.info("performanceId = " + performanceId + " NEED CHANGE TIMES USE_START");
                return true;
            }
            if (!times.getUseEnd().equals(timesVo.getUseEnd())) {
                log.info("performanceId = " + performanceId + " NEED CHANGE TIMES USE_END");
                return true;
            }
            boolean exists2 = mongoMerchantUtils.isExistsAddTicket(times.getTicketTimesId());
            if (exists2) {
                log.info("performanceId = " + performanceId + " NEED CHANGE NEW TICKET");
                return true;
            }
            for (KylinTicketPartnerVo ticketPartnerVo : times.getTicket()) {
                for (KylinTicketVo ticketVo : timesVo.getTicketList()) {
                    if (ticketVo.getTicketsId().equals(ticketPartnerVo.getTicketsId())) {
                        if (!ticketVo.getTitle().equals(ticketPartnerVo.getTitle())) {
                            log.info("performanceId = " + performanceId + " ticketId = " + ticketVo.getTicketsId() + " NEED CHANGE TICKET TITLE");
                            return true;
                        } else if (!ticketVo.getDescribeElectronic().equals(ticketPartnerVo.getDescribeElectronic())) {
                            log.info("performanceId = " + performanceId + " ticketId = " + ticketVo.getTicketsId() + " NEED CHANGE TICKET DESCRIBEELECTRONIC");
                            return true;
                        } else if (!ticketVo.getDescribeExpress().equals(ticketPartnerVo.getDescribeExpress())) {
                            log.info("performanceId = " + performanceId + " ticketId = " + ticketVo.getTicketsId() + " NEED CHANGE TICKET DESCRIBEELEXPRESS");
                            return true;
                        }
                        if (!ticketVo.getDescribes().equals(ticketPartnerVo.getDescribes())) {
                            log.info("performanceId = " + performanceId + " NEED CHANGE TICKET DESCRIBES");
                            return true;
                        }
                        break;
                    }
                }
            }
        }
        return false;
    }

    public KylinPerformanceVo combinePerformanceVoData(String performancesId) {
        try {
            //演出数据
            KylinPerformanceVo vo = redisMerchantUtils.getPerformanceVoNoMerchant(performancesId);
            //场地相关数据
            KylinFields fields = new KylinFields();
            MerchantFieldsVo fieldsVo = redisMerchantUtils.getFieldVo(vo.getFieldId());
            fields.setCityId(Integer.parseInt(fieldsVo.getCityId()));
            fields.setLatitude(fieldsVo.getLatitude());
            fields.setLongitude(fieldsVo.getLongitude());
            fields.setCityName(fieldsVo.getCityName());
            fields.setName(fieldsVo.getName());

            //相关状态时间初始变量
            LocalDateTime stopSellTime = null;
            LocalDateTime sellTime = null;
            LocalDateTime sellMemberTime = null;

            int isLackRegister = 0;
            int isMember = 0;
            int isExclusive = 0;
            int isAdvance = 0;
            int isDiscount = 0;
            int payCountdownMinute = 15;
            BigDecimal price = new BigDecimal("0.00");

            //场次数据
            List<KylinTicketTimesVo> timeList = vo.getTicketTimeList();
            for (int x = 0; x < timeList.size(); x++) {
                KylinTicketTimesVo times = timeList.get(x);
                //票种数据
                List<KylinTicketVo> ticketList = times.getTicketList();
                for (int y = 0; y < ticketList.size(); y++) {
                    KylinTicketVo ticket = ticketList.get(y);
                    if (ticket.getIsMember() == 1) {
                        if (ticket.getMemberPrice().compareTo(ticket.getPrice()) != 0) {
                            isDiscount = 1;
                        }
                        if (DateUtil.compareStrDay(DateUtil.getNowTime(), ticket.getMemberTimeStart()) < 0) {
                            isAdvance = 1;
                        }
                        if (ticket.getIsMember() == 1) {
                            isMember = 1;
                        }
                        if (ticket.getIsExclusive() == 1) {
                            isExclusive = 1;
                        }
                        if (isAdvance == 0 && isDiscount == 0 && isExclusive == 0) {
                            isMember = 0;
                        }
                    }
                    if (ticket.getIsLackRegister() == 1) {
                        isLackRegister = 1;
                    }
                    payCountdownMinute = vo.getPayCountdownMinute();
                    if (price.compareTo(new BigDecimal("0.00")) == 0) {
                        price = ticket.getPrice();
                    } else {
                        if (ticket.getPrice().compareTo(price) < 0) {
                            price = ticket.getPrice();
                        }
                    }
                    LocalDateTime tTimeEnd = LocalDateTime.parse(ticket.getTimeEnd(), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
                    LocalDateTime tTimeStart = LocalDateTime.parse(ticket.getTimeStart(), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));

                    if ((stopSellTime == null || stopSellTime.isBefore(tTimeEnd)) && (ticket.getStatus() >= 6 && ticket.getStatus() != 7)) {
                        stopSellTime = tTimeEnd;
                    }
                    if ((sellMemberTime == null || sellMemberTime.isAfter(tTimeStart.plusMinutes(-ticket.getAdvanceMinuteMember()))) && (ticket.getStatus() >= 6 && ticket.getStatus() != 7)) {
                        sellMemberTime = tTimeStart.plusMinutes(-ticket.getAdvanceMinuteMember());
                    }
                    if ((sellTime == null || sellTime.isAfter(tTimeStart)) && (ticket.getStatus() >= 6 && ticket.getStatus() != 7)) {
                        sellTime = tTimeStart;
                    }
                }
            }
            vo.setFieldsData(fields, fields.getCityName());
            if (stopSellTime == null) {
                stopSellTime = DateUtil.Formatter.yyyyMMddHHmmss.parse("2030-12-01 12:00:00");
            }
            if (sellTime == null) {
                sellTime = DateUtil.Formatter.yyyyMMddHHmmss.parse("2030-12-01 12:00:00");
            }
            if (sellMemberTime == null) {
                sellMemberTime = DateUtil.Formatter.yyyyMMddHHmmss.parse("2030-12-01 12:00:00");
            }

            vo.setTimePriceVipAndLack(isLackRegister, isMember, isExclusive, price, stopSellTime, sellMemberTime, sellTime, isAdvance, isDiscount, payCountdownMinute);
            vo.setTicketTimeList(timeList);
            return vo;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}
