package com.liquidnet.service.kylin.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;


/**
 * 福袋配置表
 */

@Data
@EqualsAndHashCode(callSuper = false)
public class KylinLuckyBag implements Serializable, Cloneable{

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Integer mid;

    /**
     * 福袋ID
     */
    private String luckyBagId;

    /**
     * 福袋名称
     */
    private String name;

    /**
     * 福袋简介
     */
    private String introduction;

    /**
     * 所属品牌ID
     */
    private String brand_id;

    /**
     * 所属演出ID
     */
    private String performances_id;


    /**
     * 所属场次ID
     */
    private String ticket_times_id;

    /**
     * 所属票种ID
     */
    private String tickets_id;


    /**
     * 上线开始时间
     */
    private String onlineStartTime;

    /**
     * 上线结束时间
     */
    private String onlineEndTime;

    /**
     * 福袋发放时间
     */
    private String send_time;

    /**
     * 状态: 1-可用, 0-不可用
     */
    private Integer state;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 修改时间
     */
    private LocalDateTime updatedAt;

}
