package com.liquidnet.service.kylin.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 兑换码表
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class KylinRewardCode implements Serializable, Cloneable{

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Integer mid;

    /**
     * 兑换码
     */
    private String code;

    /**
     * 所属福袋ID
     */
    private String luckyBagId;

    /**
     * 状态: 1-可用, 0-不可用
     */
    private Integer state;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 修改时间
     */
    private LocalDateTime updatedAt;
}
