package com.liquidnet.service.kylin.service.impl;

import com.liquidnet.common.exception.LiquidnetServiceException;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.service.base.ErrorMapping;
import com.liquidnet.service.kylin.dto.vo.KylinLuckyBagVo;
import com.liquidnet.service.kylin.dto.vo.returns.OrderDetailsVo;
import com.liquidnet.service.kylin.mapper.*;
import com.liquidnet.service.kylin.service.IKylinLuckyBagService;
import com.liquidnet.service.kylin.service.IKylinOrderTicketsService;
import com.liquidnet.service.kylin.utils.DataUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class KylinLuckyBagServiceImpl implements IKylinLuckyBagService {

    private static final Logger log = LoggerFactory.getLogger(KylinLuckyBagServiceImpl.class);

    @Autowired
    private DataUtils dataUtils;

    @Autowired
    IKylinOrderTicketsService orderTicketsService;

    @Autowired
    private KylinLuckyBagMapper kylinLuckyBagMapper;
    @Autowired
    private KylinLuckyBagActivityMapper kylinLuckyBagActivityMapper;
    @Autowired
    private KylinBrandsMapper kylinBrandsMapper;
    @Autowired
    private KylinRewardCodeMapper kylinRewardCodeMapper;
    @Autowired
    private KylinUserRewardMapper kylinUserRewardMapper;




    @Override
    public List<KylinLuckyBagVo> getLuckyBagBenefitsByOrderId(String orderId) {
        //1. 首先校验用户权限
        OrderDetailsVo vo = orderTicketsService.orderDetails(orderId);
        String uid = CurrentUtil.getCurrentUid();
        if (null == vo) {
            log.error("获取订单详情为空, orderId: {}, uid: {}.", orderId, uid);
            ErrorMapping.ErrorMessage errorMessage = ErrorMapping.get("20003");
            throw new LiquidnetServiceException(errorMessage.getCode(), errorMessage.getMessage());
        }
        //2. 先查询福袋


        //3. 再查询满足的权益


        return null;
    }
}
