package com.liquidnet.service.goblin.dto.manage;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

@ApiModel(value = "GoblinStoreMgtNoticeFilterParam", description = "店铺管理:公告通知:公告列表筛选条件入参")
@Data
public class GoblinStoreMgtNoticeFilterParam implements Serializable {
    private static final long serialVersionUID = -4698854628491039006L;
    @ApiModelProperty(position = 10, required = true, value = "店铺ID[64]")
    @NotBlank(message = "店铺ID不能为空")
    private String storeId;
    @ApiModelProperty(position = 11, required = false, value = "关键字[50]")
    private String keyword;
    @ApiModelProperty(position = 12, required = true, value = "当前记录起始索引", example = "1")
    @Min(value = 1, message = "起始索引无效")
    @NotNull(message = "起始索引无效")
    private Integer pageNum;
    @ApiModelProperty(position = 13, required = true, value = "每页显示记录数", example = "20")
    @Max(value = 100, message = "显示记录数无效")
    @NotNull(message = "显示记录数无效")
    private Integer pageSize;
}
