package com.liquidnet.service.adam.entity;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 会员退款
 * </p>
 *
 * @author liquidnet
 * @since 2021-09-07
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class AdamMemberRefund implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * 退款请求编号
     */
    private String refundNo;

    /**
     * 对应支付中心order_code
     */
    private String orderNo;

    /**
     * 退款金额
     */
    private BigDecimal refundPrice;

    /**
     * 退款描述
     */
    private String refundReason;

    /**
     * 继续购买[1-可以｜2-不可]
     */
    private Integer renewable;

    /**
     * 退款状态[0-发起退款｜1-已退款｜2-关闭｜3-退款失败｜9-退款中]
     */
    private Integer refundState;

    /**
     * 支付中心退款编号
     */
    private String repayNo;

    /**
     * 支付中心退款描述
     */
    private String repayReason;

    /**
     * 操作人
     */
    private String operator;

    private LocalDateTime createdAt;

    private LocalDateTime updatedAt;

    /**
     * 退款时间
     */
    private LocalDateTime refundAt;

    private String comment;


}
