create database if not exists ln_scene character set utf8mb4 collate utf8mb4_unicode_ci;
use ln_scene;
-- >>------------------------------------------------------------------------------------
drop table if exists adam_third_party;
create table adam_third_party
(
    mid        bigint unsigned auto_increment primary key,
    uid        varchar(64) default '',
    open_id    varchar(64) comment '第三方ID',
    avatar     varchar(255) comment '第三方头像',
    nickname   varchar(100) comment '第三方昵称',
    platform   varchar(20) comment '平台名称',
    state      tinyint comment '0-INIT,1-NORMAL,2-INVALID',
    created_at datetime not null,
    updated_at datetime,
    comment    text
) engine = InnoDB comment '用户第三方账号信息';

create index idx_athird_party_uid_platform on adam_third_party (uid, platform);
create index idx_athird_party_state on adam_third_party (state);
create index idx_athird_party_open_id on adam_third_party (open_id);
# MDB.idx:uid,open_id,platform,state
-- >>------------------------------------------------------------------------------------
# drop table if exists adam_device_token;
# create table adam_device_token
# (
#     mid        int unsigned auto_increment primary key,
#     uid        varchar(64)  not null,
#     android    varchar(255) null,
#     ios        varchar(255) null,
#     ipad       varchar(255) null,
#     is_last    tinyint,
#     created_at datetime     not null,
#     updated_at datetime,
#     comment    text
# ) engine = InnoDB comment 'TOKEN';
#
# create index idx_adevice_token_uid on adam_device_token (uid);
-- >>------------------------------------------------------------------------------------
drop table if exists adam_user;
create table adam_user
(
    mid         bigint unsigned auto_increment primary key,
    uid         varchar(64) not null,
    mobile      varchar(30),
    passwd      varchar(64),
    pay_code    varchar(64),
    state       tinyint default 0 comment '1-NORMAL,2-INVALID',
    is_complete tinyint default 0 comment '完善信息进度:0-未完善,1-已完善',
    created_at  datetime(3) not null,
    updated_at  datetime(3),
    closed_at   datetime(3),
    comment     text
) ENGINE = InnoDB comment '用户';

create unique index uidx_auser_uid on adam_user (uid);
create index idx_auser_mobile on adam_user (mobile);
# MDB.idx:uid,mobile,state
-- >>------------------------------------------------------------------------------------
drop table if exists adam_user_info;
create table adam_user_info
(
    mid              bigint unsigned auto_increment primary key,
    uid              varchar(64) not null,
    nickname         varchar(100) comment '昵称',
    sex              varchar(60) comment '性别',
    birthday         date comment '生日YYYY-MM-DD',
    area             varchar(100) comment '常住地/区域',
    signature        varchar(255) comment '个性签名',
    avatar           varchar(255) comment '头像',
    background       varchar(255) comment '背景图',
    qr_code          varchar(255) comment '身份二维码',
    qr_pic           varchar(255) comment '身份二维码',
    tag_me           json comment '音乐标签',
    rong_cloud_token varchar(255),
    rong_cloud_tag   tinyint,
    comment          text
) engine = InnoDB comment '用户信息';

create unique index idx_auser_info_uid on adam_user_info (uid);
-- >>------------------------------------------------------------------------------------
drop table if exists adam_real_name;
create table adam_real_name
(
    mid          bigint unsigned auto_increment primary key,
    real_name_id varchar(64)                not null,
    uid          varchar(64)                not null,
    type         enum ('1','2','3','4','5') not null default '1' comment '1-大陆身份证,2-港澳通行证,3-台胞证,4-护照,5-军官证',
    name         varchar(60)                not null comment '真实姓名',
    id_card      varchar(30)                not null comment '证件号码',
    state        tinyint                    not null comment '0-INIT,1-NORMAL,2-INVALID',
    created_at   datetime(3)                not null,
    updated_at   datetime(3),
    comment      text
) engine = InnoDB comment '实名信息';

create unique index idx_areal_name_id on adam_real_name (real_name_id);
create index idx_areal_name_id_card_type on adam_real_name (id_card, type);
create index idx_areal_name_uid on adam_real_name (uid);
create index idx_areal_name_state on adam_real_name (state);
# MDB.idx:uid,state
-- >>------------------------------------------------------------------------------------
drop table if exists adam_enters;
create table adam_enters
(
    mid        bigint unsigned auto_increment primary key,
    enters_id  varchar(64) not null,
    uid        varchar(64) not null comment '用户id',
    type       tinyint     not null default '1' comment '1-大陆身份证,2-港澳通行证,3-台胞证,4-护照,5-军官证',
    name       varchar(60) not null default '' comment '入场人名称',
    mobile     varchar(20) not null default '' comment '入场人手机号',
    id_card    varchar(30) not null default '' comment '入场人身份号码，或护照号码',
    is_default boolean     not null default false comment '是否为默认:0-否,1-是，第一个入默认1',
    state      tinyint     not null comment '状态:0-INIT,1-NORMAL,2-INVALID',
    created_at datetime(3) not null,
    updated_at datetime(3),
    deleted_at datetime(3),
    comment    text
) engine = InnoDB comment ='入场人';

create unique index uidx_aenters_id on adam_enters (enters_id);
create index idx_aenters_uid_state on adam_enters (uid, state);
# MDB.idx:uid,state
-- >>------------------------------------------------------------------------------------
drop table if exists adam_addresses;
create table adam_addresses
(
    mid          bigint unsigned auto_increment not null primary key,
    addresses_id varchar(64)                    not null,
    uid          varchar(64)                    not null,
    name         varchar(120)                   not null comment '姓名',
    phone        varchar(30)                    not null comment '手机号',
    province     varchar(60)                    not null comment '省份',
    city         varchar(60)                    not null comment '城市',
    county       varchar(60)                    not null comment '区县',
    address      tinytext                       not null comment '详细地址',
    is_default   boolean                        not null default false comment '是否为默认:0-否,1-是,第一个默认1',
    state        tinyint                        not null comment '状态:0-INIT,1-NORMAL,2-INVALID',
    created_at   datetime(3)                    not null,
    updated_at   datetime(3),
    deleted_at   datetime(3),
    comment      text
) engine = InnoDB comment '收货地址';

create unique index uidx_aaddresses_id on adam_addresses (addresses_id);
create index idx_aaddresses_uid_state on adam_addresses (uid, state);
# MDB.idx:uid,state
-- >>------------------------------------------------------------------------------------
# drop table if exists adam_feedback;
# create table adam_feedback
# (
#     mid           int unsigned auto_increment                                  not null primary key,
#     uid           varchar(64)                                                  not null,
#     type          enum ('complaints', 'bug', 'order', 'video', 'other')        not null comment '反馈类型',
#     comment       varchar(255)                                                 not null comment '反馈内容',
#     reply_comment varchar(255)                                                 null comment '回复内容',
#     source        varchar(255)                                                 not null comment '来源终端',
#     version       varchar(255)                                                 not null comment '终端版本',
#     model         varchar(255)                              default ''         not null comment '设备',
#     status        enum ('notreply', 'replied', 'processed') default 'notreply' not null comment '状态',
#     mobile        varchar(50)                                                  not null comment '手机号',
#     admin_id      int                                       default 0          not null comment '处理人',
#     admin_name    varchar(255)                              default ''         not null comment '处理人姓名',
#     admin_time    datetime(3)                                                     null comment '处理时间',
#     created_at    datetime(3)                                                     not null,
#     updated_at    datetime(3)
# ) engine = InnoDB comment '反馈';
-- >>------------------------------------------------------------------------------------
drop table if exists adam_collection;
create table adam_collection
(
    mid        bigint unsigned auto_increment primary key,
    uid        varchar(64)       not null,
    content_id varchar(64)       not null,
    type       varchar(30)       not null comment '收藏类型:VIDEO,TICKET,SITE,ARTIST,BAND,BRAND,STYLE,GOODS,MUSIC,SONG',
    state      tinyint default 1 not null comment '1-正常,2-删除',
    created_at datetime(3)       not null,
    updated_at datetime(3),
    comment    text
) engine = InnoDB comment '收藏';

create index idx_acollection_uid on adam_collection (uid);
create index idx_acollection_content_id on adam_collection (content_id);
create index idx_acollection_state on adam_collection (state);
# MDB.idx:uid,state,content_id
-- >>------------------------------------------------------------------------------------
drop table if exists adam_disposed;
create table adam_disposed
(
    mid        bigint unsigned auto_increment not null primary key,
    uid        varchar(64)                    not null,
    content_id int unsigned                   not null,
    type       varchar(30)                    not null comment '想去类型:TICKET',
    state      tinyint default 1              not null comment '1-正常,2-删除',
    created_at datetime(3)                    not null,
    updated_at datetime(3),
    comment    text
) engine = InnoDB comment '想去';

create index idx_adisposed_uid on adam_disposed (uid);
create index idx_adisposed_content_id on adam_disposed (content_id);
create index idx_adisposed_state on adam_disposed (state);
# MDB.idx:uid,state,content_id
-- >>------------------------------------------------------------------------------------
drop table if exists adam_member;
create table adam_member
(
    mid               bigint unsigned auto_increment primary key,
    member_id         varchar(255) comment '会员id',
    name              varchar(80),
    title             varchar(100),
    sub_title         varchar(255) NOT NULL DEFAULT '' COMMENT '副标题',
    icon              varchar(255),
    avatar            varchar(255),
    start_no          varchar(20) comment '起始会员号',
    type              tinyint comment '会员类型',
    interests_detail  text comment '权益详情',
    #     gift_pack_id     varchar(64) comment '礼包ID',
    notes             text         NOT NULL COMMENT '注意事项',
    created_at        datetime(3),
    updated_at        datetime(3),
    is_notice         tinyint comment '是否展示须知',
    notice_info       text comment '须知内容',
    notice_title      varchar(255),
    need_question     int                   default 0 comment '是否需要答题 0不需要 1需要',
    display_agreement int          NOT NULL DEFAULT '0' COMMENT '是否打开0否1是',
    state             int          NOT NULL COMMENT '状态:1-NORMAL,2-INVALID',
    limitation        int                   default 0 comment '限购数量，0不限购',
    comment           text
) engine = InnoDB comment '会员卡信息';

create unique index uidx_amember_id on adam_member (member_id);
# MDB.idx:member_id,state
-- >>------------------------------------------------------------------------------------
drop table if exists adam_member_price;
create table adam_member_price
(
    mid             bigint unsigned auto_increment primary key,
    member_price_id varchar(64) comment '会员价格id',
    member_id       varchar(64)   NOT NULL comment '会员种类ID',
    state           tinyint       NOT NULL DEFAULT '0' COMMENT '0不可用、1上线中、2已下线',
    name            varchar(80)   NOT NULL DEFAULT '' COMMENT '会员包名称',
    price           decimal(8, 2) NOT NULL DEFAULT '0.00' COMMENT '会员包价格',
    price_fixed     decimal(8, 2) comment '折扣价',
    days            int           NOT NULL DEFAULT '0' COMMENT '会员包天数',
    detail          text          NOT NULL COMMENT '会员包须知',
    created_at      datetime(3),
    updated_at      datetime(3),
    comment         text
) engine = InnoDB comment '会员卡价格';

create unique index uidx_amember_price_id on adam_member_price (member_price_id);
create index idx_amember_price_member_id on adam_member_price (member_id);
# MDB.idx:member_id,state
-- >>------------------------------------------------------------------------------------
drop table if exists adam_member_order;
create table adam_member_order
(
    mid             bigint unsigned auto_increment primary key,
    order_no        varchar(64),
    uid             varchar(64),
    mode            tinyint comment '购买方式:0-购买会员,1-购买会员码',
    price           decimal(8, 2) comment '原价',
    price_paid      decimal(8, 2) comment '实际支付',
    member_name     varchar(80),
    member_id       varchar(255) comment '会员id',
    member_price_id varchar(255) comment '会员价格id',
    days            int         default 0 comment '购买天数',
    state           tinyint comment '订单状态',
    member_no       varchar(20) comment '会员号',
    birthday        varchar(20) default null comment '用户生日[yyyy-MM-dd]',
    device_from     varchar(20) comment '支付终端:app,wap,js,applet',
    pay_type        varchar(20) comment '支付方式:alipay,wepay,vipcode,giftcode',
    pay_no          varchar(64) comment '支付订单',
    payment_at      datetime(3) default null comment '支付时间',
    created_at      datetime(3),
    updated_at      datetime(3),
    client_ip       varchar(50),
    source          varchar(30),
    version         varchar(30),
    comment         text
) engine = InnoDB comment '用户会员订单';

create unique index uidx_amember_order_id on adam_member_order (order_no);
# MDB.idx:order_no
-- >>------------------------------------------------------------------------------------
drop table if exists adam_user_member;
create table adam_user_member
(
    mid        bigint unsigned auto_increment primary key,
    uid        varchar(64) not null,
    member_id  varchar(255) comment '会员类型id',
    member_no  varchar(20) not null,
    state      tinyint comment '1-NORMAL,2-INVALID',
    expiry_at  datetime(3) comment '到期日期',
    created_at datetime(3),
    updated_at datetime(3),
    comment    text
) engine = InnoDB comment '用户会员信息';

create index idx_auser_member_uid on adam_user_member (uid);
create index idx_auser_member_no on adam_user_member (member_no);
# MDB.idx:uid,member_no
-- >>------------------------------------------------------------------------------------
drop table if exists adam_member_code;
create table adam_member_code
(
    mid             bigint unsigned auto_increment primary key,
    code            varchar(20) comment '会员码',
    type            int          default 0 comment '类型:1-购买,2-赠送(后台生成)',
    member_id       varchar(255) comment '会员ID',
    member_price_id varchar(255) comment '会员价格ID',
    member_no       varchar(20) comment '预留会员号',
    state           tinyint comment '0-未用,1-已用,2-不可用',
    created_at      datetime(3),
    updated_at      datetime(3),
    buy_order_no    varchar(255) default null comment '购买会员码订单号',
    buy_uid         varchar(255) default null comment '购买会员码用户id',
    buy_at          datetime(3)  default null comment '购买时间',
    use_order_no    varchar(64)  default null comment '消费订单号',
    use_uid         varchar(64)  default null comment '消费用户ID',
    use_at          datetime(3)  default null,
    comment         text
) engine = InnoDB comment '会员兑换码';

create unique index uidx_amember_code_id on adam_member_code (code);
# MDB.idx:code
-- >>------------------------------------------------------------------------------------
-- >>------------------------------------------------------------------------------------
-- >>------------------------------------------------------------------------------------
