package com.liquidnet.service.kylin.config;

/**
 * @author AnJiabin <jiabin.an@lightnet.io>
 * @version V1.0
 * @Description:
 * @class: MongoSSL
 * @Package com.liquidnet.service.adam.config
 * @Copyright: LightNet @ Copyright (c) 2020
 * @date 2020/12/18 11:51 上午
 */

import com.mongodb.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

//mongoSSl连接配置类
@Slf4j
@Configuration
public class MongoSslConfig {
    @Value("${spring.data.mongodb.trustStore}")
    private String trustStore;
    @Value("${spring.data.mongodb.trustStorePassword}")
    private String trustStorePassword;
    @Value("${spring.data.mongodb.uri}")
    private String mongodbUri;
    @Value("${spring.data.mongodb.sslEnabled}")
    private boolean sslEnabled;

    @Bean
    public MongoClient createMongoClientByUri() {
        log.info("MongoSslConfig trustStore:{}",trustStore);
        log.info("MongoSslConfig trustStorePassword:{}",trustStorePassword);
        log.info("MongoSslConfig mongodbUri:{}",mongodbUri);
        log.info("MongoSslConfig sslEnabled:{}",sslEnabled);

        System.setProperty("javax.net.ssl.trustStore",trustStore);
        System.setProperty("javax.net.ssl.trustStorePassword",trustStorePassword);

        MongoClientURI uri = new MongoClientURI(mongodbUri,MongoClientOptions.builder().sslEnabled(sslEnabled));
        return new MongoClient(uri);
    }
}
