package com.liquidnet.service.galaxy.router.xuper.biz;

import com.liquidnet.common.exception.constant.ErrorCode;
import com.liquidnet.common.third.xuper.config.XuperConfig;
import com.liquidnet.common.third.xuper.dto.Xuper010QuerySdsReqDto;
import com.liquidnet.common.third.xuper.dto.Xuper010QuerySdsRespDto;
import com.liquidnet.common.third.xuper.dto.XuperResponseDto;
import com.liquidnet.common.third.xuper.exception.XupterException;
import com.liquidnet.common.third.xuper.util.XuperSdkUtil;
import com.liquidnet.commons.lang.util.BeanUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.galaxy.biz.GalaxyBeanTransferBiz;
import com.liquidnet.service.galaxy.biz.GalaxyEnumBiz;
import com.liquidnet.service.galaxy.constant.GalaxyEnum;
import com.liquidnet.service.galaxy.constant.GalaxyErrorEnum;
import com.liquidnet.service.galaxy.dto.bo.GalaxyNftOrderBindBo;
import com.liquidnet.service.galaxy.dto.bo.GalaxyNftOrderBo;
import com.liquidnet.service.galaxy.dto.param.*;
import com.liquidnet.service.galaxy.utils.GalaxyDataUtils;
import com.liquidnet.service.galaxy.utils.QueueUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.Date;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: XuperTradeBiz
 * @Package com.liquidnet.service.galaxy.router.xuper.biz
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/6/27 11:11
 */
@Slf4j
@Component
public class XuperTradeBiz {
    @Autowired
    private XuperSdkUtil xuperSdkUtil;

    @Autowired
    private GalaxyDataUtils dataUtils;

    @Autowired
    private XuperTradeCommonBiz xuperTradeCommonBiz;

    @Autowired
    private XuperPublishBiz xuperPublishBiz;

    /**
     * 发行和购买
     * @param reqDto
     * @return
     */
    public ResponseDto<GalaxyNftPublishAndBuyRespDto> nftPublishAndBuy(GalaxyNftPublishAndBuyReqDto reqDto) {
        return xuperTradeCommonBiz.nftPublishAndBuy(reqDto);
    }
    /**
     * NFT发行和购买
     * @param reqDto
     * @return
     */
    public ResponseDto<GalaxyNftPublishAndBuyResultQueryRespDto> nftPublishAndBuyResultQuery(GalaxyNftPublishAndBuyResultQueryReqDto reqDto) {
        //获取订单信息
        GalaxyNftOrderBo nftOrderBo = dataUtils.getNftOrderBo(reqDto.getRouterType(),reqDto.getNftOrderPayId());
        if(StringUtil.isNull(nftOrderBo)){
            return ResponseDto.failure(GalaxyErrorEnum.PUBLISH_ORDER_NOT_EXIST.getCode(), GalaxyErrorEnum.PUBLISH_ORDER_NOT_EXIST.getMessage());
        }

        /**
         * TODO 如果订单信息是购买失败，则直接调用至信链查询购买结果
         */
        //是否需要发起二次购买
        boolean isNeedSecondBuy = false;
        if(StringUtil.isNotEmpty(nftOrderBo.getNftPublishStatus())
                && (GalaxyEnum.TaskStatusEnum.INIT.getCode().equalsIgnoreCase(nftOrderBo.getNftPublishStatus())
                ||GalaxyEnum.TaskStatusEnum.PROCESSING.getCode().equalsIgnoreCase(nftOrderBo.getNftPublishStatus()))){
            //判断是否需要二次购买
            if(StringUtil.isEmpty(nftOrderBo.getNftPublishTaskId())){
                isNeedSecondBuy = true;
            }
            //执行nft发行结果查询
            GalaxyNftPublishResultQueryReqDto nftPublishResultQueryReqDto = GalaxyNftPublishResultQueryReqDto.getNew();
            nftPublishResultQueryReqDto.setNftOrderPayId(reqDto.getNftOrderPayId());
            nftPublishResultQueryReqDto.setRouterType(reqDto.getRouterType());
            ResponseDto<GalaxyNftPublishResultQueryRespDto> publishResultQueryRespDto = xuperPublishBiz.nftPublishResultQuery(nftPublishResultQueryReqDto);
        }else if(StringUtil.isNotEmpty(nftOrderBo.getNftBuyStatus())
                && (GalaxyEnum.TaskStatusEnum.INIT.getCode().equalsIgnoreCase(nftOrderBo.getNftBuyStatus())
                ||GalaxyEnum.TaskStatusEnum.PROCESSING.getCode().equalsIgnoreCase(nftOrderBo.getNftBuyStatus()))){
            //判断是否需要二次购买
            if(StringUtil.isEmpty(nftOrderBo.getNftBuyTaskId())){
                isNeedSecondBuy = true;
            }
            //执行nft购买结果查询
            GalaxyNftBuyResultQueryReqDto nftBuyResultQueryReqDto = GalaxyNftBuyResultQueryReqDto.getNew();
            nftBuyResultQueryReqDto.setNftOrderPayId(reqDto.getNftOrderPayId());
            nftBuyResultQueryReqDto.setRouterType(reqDto.getRouterType());
            ResponseDto<GalaxyNftBuyResultQueryRespDto> buyResultQueryRespDto= this.nftBuyResultQuery(nftBuyResultQueryReqDto,nftOrderBo);
        }

        GalaxyNftPublishAndBuyResultQueryRespDto resultQueryRespDto = GalaxyNftPublishAndBuyResultQueryRespDto.getNew();
        if(nftOrderBo.getNftPublishStatus().equalsIgnoreCase(GalaxyEnum.TaskStatusEnum.TASK_SUCCESS.getCode())&&
                nftOrderBo.getNftBuyStatus().equalsIgnoreCase(GalaxyEnum.TaskStatusEnum.TASK_SUCCESS.getCode())){
            BeanUtil.copy(nftOrderBo,resultQueryRespDto);
            return ResponseDto.success(resultQueryRespDto);
        }
        return ResponseDto.failure(GalaxyErrorEnum.NFT_PUBLISH_AND_BUY_QUERY_FAIL.getCode(),GalaxyErrorEnum.NFT_PUBLISH_AND_BUY_QUERY_FAIL.getMessage(),resultQueryRespDto);
    }

    private ResponseDto<GalaxyNftBuyResultQueryRespDto> nftBuyResultQuery(GalaxyNftBuyResultQueryReqDto reqDto,GalaxyNftOrderBo nftOrderBo) {
        //获取订单信息
//        GalaxyNftOrderBo nftOrderBo = dataUtils.getNftOrderBo(reqDto.getRouterType(),reqDto.getNftOrderPayId());
//        if(StringUtil.isNull(nftOrderBo)){
//            return ResponseDto.failure(GalaxyErrorEnum.PUBLISH_ORDER_NOT_EXIST.getCode(), GalaxyErrorEnum.PUBLISH_ORDER_NOT_EXIST.getMessage());
//        }

        if(StringUtil.isEmpty(nftOrderBo.getNftBuyTaskId())){
            return ResponseDto.failure(GalaxyErrorEnum.NFT_BUY_TASK_NOT_EXIST.getCode(), GalaxyErrorEnum.NFT_BUY_TASK_NOT_EXIST.getMessage());
        }
        try {
            //执行资产碎片授予查询
            Xuper010QuerySdsReqDto xuper010QuerySdsReqDto = Xuper010QuerySdsReqDto.getNew();
            // 定义返回结果对象
            Xuper010QuerySdsRespDto xuper010QuerySdsRespDto = null;
            long shardId = -1l;
            GalaxyNftOrderBindBo nftOrderBindBo = dataUtils.getGalaxyNftOrderBindBo(reqDto.getRouterType(),nftOrderBo.getNftOrderPayId());
            if(StringUtil.isNotNull(nftOrderBindBo)){
                shardId = nftOrderBindBo.getNftIdIndex().longValue();
            }

            xuper010QuerySdsReqDto.setAssetId(Long.parseLong(nftOrderBo.getSeriesId()));
            xuper010QuerySdsReqDto.setShardId(shardId);
            XuperResponseDto<Xuper010QuerySdsRespDto> xuperResponseDto = xuperSdkUtil.xuper010QuerySds(xuper010QuerySdsReqDto);
            log.info("xuper010QuerySds resp : "+ JsonUtils.toJson(xuperResponseDto));
            if(xuperResponseDto.isSuccess()){
                xuper010QuerySdsRespDto = xuperResponseDto.getParseData(Xuper010QuerySdsRespDto.class);
                if(String.valueOf(xuper010QuerySdsRespDto.getErrNo()).equalsIgnoreCase(ErrorCode.SUCCESS.getCode())){
                    //更新订单缓存数据状态
                    String nowTimeStr = DateUtil.getNowTime();
                    //转换任务状态
                    Integer taskStatus = Integer.valueOf(GalaxyEnumBiz.getGrantStatusEnum(reqDto.getRouterType(),String.valueOf(xuper010QuerySdsRespDto.getMeta().getStatus())).getCode());
                    //设置时间
                    String nftBuyChainTimestampStr = DateUtil.format(new Date(),DateUtil.Formatter.yyyyMMddHHmmss);
                    nftOrderBo.setNftBuyChainTimestamp(nftBuyChainTimestampStr);
                    nftOrderBo.setNftBuyStatus(taskStatus.toString());
                    nftOrderBo.setNftBuyTradeHash(xuper010QuerySdsRespDto.getMeta().getTxId());
                    nftOrderBo.setNftBuyPayTaskId(nftOrderBo.getNftBuyTaskId());
                    nftOrderBo.setUpdatedAt(LocalDateTime.now());
                    //先更新nft购买数据
                    dataUtils.updateNftOrderBuyInfo(nftOrderBo.getRouterType(),nftOrderBo.getNftOrderPayId(),nftOrderBo);


                    GalaxyNftBuyResultQueryRespDto resultQueryRespDto = GalaxyNftBuyResultQueryRespDto.getNew();
                    resultQueryRespDto.setTaskStatus(taskStatus);
                    resultQueryRespDto.setChainTimestamp(nowTimeStr);
                    resultQueryRespDto.setPayTaskId(xuper010QuerySdsRespDto.getMeta().getTxId());
                    resultQueryRespDto.setTxHash(xuper010QuerySdsRespDto.getMeta().getTxId());
                    return ResponseDto.success(resultQueryRespDto);
                }
            }
        }catch (XupterException e) {
            log.error("biz error msg "+e.getMessage(),e);
        }catch (Exception e) {
            log.error("sys error msg "+e.getMessage(),e);
        }
        return ResponseDto.failure(GalaxyErrorEnum.NFT_PUBLISH_AND_BUY_QUERY_FAIL.getCode(),GalaxyErrorEnum.NFT_PUBLISH_AND_BUY_QUERY_FAIL.getMessage());
    }
}
