package com.liquidnet.service.platform.controller.partner;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.dto.vo.KylinFieldsVo;
import com.liquidnet.service.platform.service.partner.impl.FieldsPartnerServiceImpl;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;

@Api
@RestController
@RequestMapping("partner/fields")
public class FieldsPartnerController {

    @Autowired
    private FieldsPartnerServiceImpl fieldsPartnerService;

//    @GetMapping(value = "details")
//    @ApiOperation(value = "获取场地详情")
//    @ApiResponse(response = FieldsVo.class, code = 200, message = "接口返回对象参数")
    public ResponseDto<KylinFieldsVo> fieldDetails(@RequestParam(value = "fieldId", defaultValue = "59666659929161728") String fieldId) {
        KylinFieldsVo result = null;
        result = fieldsPartnerService.fieldDetails(fieldId);
        if (null == result) {
            return ResponseDto.failure("场地详情查询失败");
        } else {
            return ResponseDto.success(result);
        }
    }

//    @GetMapping(value = "list")
//    @ApiOperation(value = "获取场地列表")
//    @ApiResponse(response = FieldsVo.class, code = 200, message = "接口返回对象参数")
    public ResponseDto<HashMap<String, Object>> fieldList(@RequestParam(value = "page", defaultValue = "1") int page, @RequestParam(value = "size", defaultValue = "10") int size, @RequestParam(value = "name", defaultValue = "") String name) {
        HashMap<String, Object> result = null;
        result = fieldsPartnerService.fieldList(page-1,size,name);
        if (null == result) {
            return ResponseDto.failure("场地列表获取失败");
        } else {
            return ResponseDto.success(result);
        }
    }

}
