package com.liquidnet.client.admin.web.controller.zhengzai.kylin;

import com.github.pagehelper.PageInfo;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.zhengzai.kylin.dto.PerformanceOrderStatisCountResp;
import com.liquidnet.client.admin.zhengzai.kylin.service.impl.KylinPerformancesAdminServiceImpl;
import com.liquidnet.service.kylin.dao.PerformanceAdminListDao;
import com.liquidnet.service.kylin.dao.PerformanceMemberAuditDao;
import com.liquidnet.service.kylin.dao.PerformanceOrderStatisticalDao;
import com.liquidnet.service.kylin.dto.param.PerformanceAdminListParam;
import com.liquidnet.service.kylin.dto.param.PerformanceMemberAuditParam;
import com.liquidnet.service.kylin.dto.vo.partner.KylinPerformanceMisVo;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.List;


/**
 * 演出Controller
 *
 * @author anjiabin
 * @date 2021-05-24
 */
@Controller
@RequestMapping("/kylin/performances")
public class KylinPerformancesController extends BaseController {
    private String prefix = "zhengzai/kylin/performances";

    @Autowired
    private KylinPerformancesAdminServiceImpl kylinPerformancesService;

    @RequiresPermissions("kylin:performances:view")
    @GetMapping()
    public String performances() {
        return prefix + "/performances";
    }

    /**
     * 查询演出列表
     */
    @RequiresPermissions("kylin:performances:list")
    @PostMapping("/list")
    @ResponseBody
    public TableDataInfo list(PerformanceAdminListParam performanceAdminListParam) {
        startPage();/**/
        PageInfo<PerformanceAdminListDao> result = kylinPerformancesService.getList(performanceAdminListParam);
        return getDataTable(result.getList());
    }

    @RequiresPermissions("kylin:performances:detail")
    @GetMapping(value = "/details/{performancesId}")
    public String performanceDetails(@PathVariable("performancesId") String performancesId, ModelMap mmap) {
        KylinPerformanceMisVo result = null;
        result = kylinPerformancesService.performanceDetails(performancesId);
        mmap.put("kylinPerformanceMisVo", result);
        return prefix + "/details";
    }

    @PostMapping(value = "/audit")
    @RequiresPermissions("kylin:performances:audit")
    @ResponseBody
    public AjaxResult performanceAudit(@RequestParam("performancesId") String performancesId, @RequestParam("status") int status, @RequestParam(value = "rejectTxt", required = false) String rejectTxt) {
        boolean result = kylinPerformancesService.performanceAudit(performancesId, status, rejectTxt);
        return toAjax(result);
    }

    @RequiresPermissions("kylin:performances:change")
    @PostMapping(value = "/isShow")
    @ResponseBody
    public AjaxResult setIsShow(String performancesId, Integer isShow) {
        return toAjax(kylinPerformancesService.setIsShow(performancesId, isShow));
    }

    @RequiresPermissions("kylin:performances:member")
    @GetMapping(value = "/memberInfo/{performancesId}")
    public String memberInfo(@PathVariable("performancesId") String performancesId, ModelMap mmap) {
        PerformanceMemberAuditDao result = kylinPerformancesService.performanceMemberInfo(performancesId);
        mmap.put("performanceMemberAuditDao", result);
        return prefix + "/memberInfo";
    }

    @RequiresPermissions("kylin:performances:member:change")
    @PostMapping(value = "/memberInfo/submit")
    @ResponseBody
    public AjaxResult memberInfo(PerformanceMemberAuditParam performanceMemberAuditParam) {
        boolean result = kylinPerformancesService.performanceMemberChange(performanceMemberAuditParam);
        return toAjax(result);
    }

    @RequiresPermissions("kylin:performances:performanceStatic")
    @GetMapping(value = "/performanceStatic/{performancesId}")
    public String performanceStatic(@PathVariable("performancesId") String performancesId, ModelMap mmap) {
        //获取演出详情
        KylinPerformanceMisVo performanceMisVo = kylinPerformancesService.performanceDetails(performancesId);

        List<PerformanceOrderStatisticalDao> result = kylinPerformancesService.getPerformanceOrderStatisticalList(performancesId);
        //构造top统计数据
        PerformanceOrderStatisCountResp perCountResp = new PerformanceOrderStatisCountResp();
        perCountResp.setPerformanceTitle(performanceMisVo.getTitle());
        if(result.size()>=2){
            PerformanceOrderStatisticalDao resdao = result.get(result.size()-1);
            perCountResp.setTotalSalePrice(resdao.getTotalSalePrice());
            perCountResp.setSaleGeneral(resdao.getSaleGeneral());
            perCountResp.setTotalGeneral(resdao.getTotalGeneral());
            perCountResp.setTotalExchange(resdao.getTotalExchange());
            perCountResp.setSurplusExchange(resdao.getSurplusGeneral());
            perCountResp.setTotalBuyUsers(resdao.getTotalBuyUsers());
            perCountResp.setTotalDisPrice(BigDecimal.ONE);
            perCountResp.setTotalRefundGeneral(resdao.getTotalRefundGeneral());
        }

        mmap.put("perCountResp", perCountResp);
        mmap.put("perOrderStaticList", result);
        return prefix + "/performancesStatic";
    }
}
