package com.liquidnet.service.account.wallet.dto;

import com.liquidnet.service.account.wallet.dto.base.WalletCallParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.time.LocalDateTime;
import java.util.List;

/**
 * WalletQueryParam.class
 *
 * @author zhanggb
 * Created by IntelliJ IDEA at 2020/10/21
 */
@ApiModel(value = "WalletQueryParam", description = "Parameters of wallet list")
public class WalletQueryParam extends WalletCallParam {
    private static final long serialVersionUID = -3964458494795359989L;
    @ApiModelProperty(position = 11, required = false, value = "User association ID [64]")
    private String userExtId;
    @ApiModelProperty(position = 12, required = false, value = "User association name [150]")
    private String userExtName;
    @ApiModelProperty(position = 13, required = false, value = "Wallet number [11]")
    private String walletNo;
    @ApiModelProperty(position = 14, required = false, value = "Wallet currency code [5]")
    private String currency;
    @ApiModelProperty(position = 15, required = false, value = "Wallet alias [100]")
    private String alias;
    @ApiModelProperty(position = 16, required = false, value = "Wallet status code [5]", example = "1")
    private Integer status;
    @ApiModelProperty(position = 17, required = false, value = "Wallet pay status code [5]", example = "1")
    private Integer payStatus;
    @ApiModelProperty(position = 18, required = false, value = "Wallet account opening time start")
    private LocalDateTime startTime;
    @ApiModelProperty(position = 19, required = false, value = "Wallet account opening time end")
    private LocalDateTime endTime;
    @ApiModelProperty(position = 20, required = false, value = "Wallet account fuzzy query")
    private String fuzzySearch;
    @ApiModelProperty(position = 21, required = false, value = "Wallet account fuzzy field default:0 [0,1]")
    private Integer fuzzyField;
    @ApiModelProperty(position = 22, required = false, value = "Page number [1...N]", example = "1")
    private Integer pageNum;
    @ApiModelProperty(position = 23, required = false, value = "Page list size [10...20]", example = "10")
    private Integer pageSize;
    @ApiModelProperty(position = 24, required = false, value = "Wallet number list [List<String>]")
    private List<String> walletNoList;

    public String getUserExtId() {
        return userExtId;
    }

    public void setUserExtId(String userExtId) {
        this.userExtId = userExtId;
    }

    public String getUserExtName() {
        return userExtName;
    }

    public void setUserExtName(String userExtName) {
        this.userExtName = userExtName;
    }

    public String getWalletNo() {
        return walletNo;
    }

    public void setWalletNo(String walletNo) {
        this.walletNo = walletNo;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getAlias() {
        return alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getPayStatus() {
        return payStatus;
    }

    public void setPayStatus(Integer payStatus) {
        this.payStatus = payStatus;
    }

    public LocalDateTime getStartTime() {
        return startTime;
    }

    public void setStartTime(LocalDateTime startTime) {
        this.startTime = startTime;
    }

    public LocalDateTime getEndTime() {
        return endTime;
    }

    public void setEndTime(LocalDateTime endTime) {
        this.endTime = endTime;
    }

    public String getFuzzySearch() {
        return fuzzySearch;
    }

    public void setFuzzySearch(String fuzzySearch) {
        this.fuzzySearch = fuzzySearch;
    }

    public Integer getFuzzyField() {
        return fuzzyField;
    }

    public void setFuzzyField(Integer fuzzyField) {
        this.fuzzyField = fuzzyField;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public List<String> getWalletNoList() {
        return walletNoList;
    }

    public void setWalletNoList(List<String> walletNoList) {
        this.walletNoList = walletNoList;
    }
}
