package com.liquidnet.service.merchant.dto.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.util.List;

@ApiModel(value = "MerchantAuthorizationRecordParam", description = "授权验票统计入参")
@Data
public class MerchantAuthorizationRecordParam implements java.io.Serializable{
    private static final long serialVersionUID = -673681507332688410L;

    @ApiModelProperty(position = 10, required = true, value = "演出ID")
    @NotBlank
    private String performanceId;

    @ApiModelProperty(position = 11, required = true, value = "权利人演出角色 CHECKER")
    @NotBlank
    private String uidRole;
    @ApiModelProperty(position = 12, required = true, value = "权利人UID")
    @NotBlank
    private String uid;
    @ApiModelProperty(position = 13, required = true, value = "权利人手机号")
    @NotBlank
    private String mobile;
    @ApiModelProperty(position = 14, required = true, value = "权利人姓名")
    @NotBlank
    private String name;

    @ApiModelProperty(position = 15, required = true, value = "授权权限")
    @NotEmpty
    private List<MerchantAuthorizationPermissionParam> permissions;
}
