package com.liquidnet.service.merchant.dto.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

@ApiModel(value = "MerchantStationsVo", description = "小站")
@Data
public class MerchantStationsVo implements Cloneable {

    @ApiModelProperty(position = 10, value = "类型 fieldApply-场地申请、field-场地、sponsorApply主办申请、sponsor-主办")
    private String stationType;

    @ApiModelProperty(position = 20, value = "申请状态 0-待审核 1-通过 2-驳回")
    private Integer applyStatus;
    @ApiModelProperty(position = 21, value = "申请类型 claim-认领、create-创建")
    private String applyType;
    @ApiModelProperty(position = 22, value = "驳回原因")
    private String reject;

    @ApiModelProperty(position = 30, value = "主办ID")
    private String name;
    @ApiModelProperty(position = 31, value = "logo图片地址")
    private String logo;

    @ApiModelProperty(position = 40, value = "场地申请ID")
    private String fieldApplyId;
    @ApiModelProperty(position = 41, value = "场地ID")
    private String fieldId;

    @ApiModelProperty(position = 50, value = "主办申请ID")
    private String sponsorApplyId;
    @ApiModelProperty(position = 51, value = "主办ID")
    private String sponsorId;


    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime createdAt;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime updatedAt;

    private static final MerchantStationsVo obj = new MerchantStationsVo();

    public static MerchantStationsVo getNew() {
        try {
            return (MerchantStationsVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new MerchantStationsVo();
    }
}
