package com.liquidnet.service.sweet.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 答题表
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-08-12
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class SweetAnswer implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * answer_id
     */
    private String answerId;

    /**
     * 手机号
     */
    private String phone;

    /**
     * 答案json
     */
    private String answerJson;

    /**
     * 图片
     */
    private String imgUrl;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 更新时间
     */
    private LocalDateTime updatedAt;

    private static final SweetAnswer obj = new SweetAnswer();
    public static SweetAnswer getNew() {
        try {
            return (SweetAnswer) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new SweetAnswer();
        }
    }


}
