package com.liquidnet.service.executor.main.handler;

import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.DESUtils;
import com.liquidnet.commons.lang.util.HttpUtil;
import com.liquidnet.service.feign.platform.task.FeignPlatformErpTaskClient;
import com.liquidnet.service.feign.platform.task.FeignPlatformGoblinTaskClient;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;

/**
 * platform:goblin
 */
@Component
public class PlatformErpTaskHandler {
    @Autowired
    private FeignPlatformErpTaskClient feignPlatformErpTaskClient;

    @XxlJob(value = "sev-platform:syncErpSpuStock")
    public void syncErpSpuStock() {
        try {
            XxlJobHelper.handleSuccess("结果：" + feignPlatformErpTaskClient.syncErpSpuStock("",Integer.parseInt(XxlJobHelper.getJobParam())).getData());
        } catch (Exception e) {
            XxlJobHelper.log(e);
            XxlJobHelper.handleFail();
        }
    }
}
