package com.liquidnet.service.account.funding.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

/**
 * AccountBalanceInfo.class
 *
 * @author zhanggb
 * Created by IntelliJ IDEA at 2020/10/22
 */
@ApiModel(value = "AccountBalanceInfo", description = "Details of funding account balance")
public class AccountBalanceInfo implements java.io.Serializable {
    private static final long serialVersionUID = -322159038546103830L;
    @ApiModelProperty(position = 11, value = "Funding account number [32]")
    private String accNo;
    @ApiModelProperty(position = 12, value = "Funding account group ID [32]")
    private String accGroupId;
    @ApiModelProperty(position = 13, value = "Funding account number balance [20,6]")
    private BigDecimal balance;

    public String getAccNo() {
        return accNo;
    }

    public void setAccNo(String accNo) {
        this.accNo = accNo;
    }

    public String getAccGroupId() {
        return accGroupId;
    }

    public void setAccGroupId(String accGroupId) {
        this.accGroupId = accGroupId;
    }

    public BigDecimal getBalance() {
        return balance;
    }

    public void setBalance(BigDecimal balance) {
        this.balance = balance;
    }
}
