package com.liquidnet.service.kylin.utils;

import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinIpAreaVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.stream.StreamRecords;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.HashMap;

@Component
public class QueueUtils {

//    @Autowired
//    private RabbitTemplate rabbitTemplate;
    @Autowired
    StringRedisTemplate stringRedisTemplate;
    @Autowired
    DataUtils dataUtils;

    /**
     * 发送消息 - RABBIT
     *
     * @param exchange 交换机
     * @param routeKey 路径
     * @param jsonMsg  Json字符串
     */
//    public void sendSqlRabbit(String exchange, String routeKey, String jsonMsg) {
//        rabbitTemplate.convertAndSend(exchange, routeKey, jsonMsg);
//    }

    /**
     * 发送消息 - REDIS
     *
     * @param streamKey Redis消费Key
     * @param jsonMsg   Json字符串
     */
    public void sendMsgByRedis(String streamKey, String jsonMsg) {
        HashMap<String, String> map = CollectionUtil.mapStringString();
        map.put(MQConst.QUEUE_MESSAGE_KEY, jsonMsg);
        stringRedisTemplate.opsForStream().add(StreamRecords.mapBacked(map).withStreamKey(streamKey));
    }

    public void pushPvUv(String uid, String accessType, String performanceId, String orderId, String orderCode, String ipAddress) {
        try {
            KylinIpAreaVo vo = dataUtils.getKylinIpAreaVo(ipAddress);
            String area = vo.getArea();
            String areaProvince = vo.getProvince();
            String areaCity = vo.getCity();
            String areaCounty = vo.getCounty();
            sendMsgByRedis(MQConst.KylinQueue.SQL_PERFORMANCE_LACK.getKey(),
                    SqlMapping.get("bi_ticket_access_records.insert", new Object[]{
                            uid, accessType, performanceId, orderId, orderCode,
                            ipAddress, area, areaProvince, areaCity, areaCounty,
                            LocalDateTime.now(),
                    }));
        } catch (Exception e) {

        }
    }
}
